package io.smallrye.jwt.config;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class ConfigLogging_$logger extends DelegatingBasicLogger implements ConfigLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigLogging_$logger.class.getName();
    public ConfigLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void configValues(final String jwtPublicKey, final String jwtIssuer, final String jwtLocation) {
        super.log.logf(FQCN, DEBUG, null, configValues$str(), jwtPublicKey, jwtIssuer, jwtLocation);
    }
    protected String configValues$str() {
        return "SRJWT03000: init, mpJwtPublicKey=%s, mpJwtIssuer=%s, mpJwtLocation=%s";
    }
    @Override
    public final void publicKeyAndLocationAreUnavailable() {
        super.log.logf(FQCN, DEBUG, null, publicKeyAndLocationAreUnavailable$str());
    }
    protected String publicKeyAndLocationAreUnavailable$str() {
        return "SRJWT03001: Neither mpJwtPublicKey nor mpJwtLocation properties are configured, JWTAuthContextInfo will not be available";
    }
    @Override
    public final void publicKeyParsedAsJwk() {
        super.log.logf(FQCN, DEBUG, null, publicKeyParsedAsJwk$str());
    }
    protected String publicKeyParsedAsJwk$str() {
        return "SRJWT03002: mpJwtPublicKey parsed as JWK(S)";
    }
    @Override
    public final void parsingPublicKeyAsJwkFailed(final String exceptionMessage) {
        super.log.logf(FQCN, DEBUG, null, parsingPublicKeyAsJwkFailed$str(), exceptionMessage);
    }
    protected String parsingPublicKeyAsJwkFailed$str() {
        return "SRJWT03003: mpJwtPublicKey failed as JWK(S), %s";
    }
    @Override
    public final void publicKeyParsedAsPem() {
        super.log.logf(FQCN, DEBUG, null, publicKeyParsedAsPem$str());
    }
    protected String publicKeyParsedAsPem$str() {
        return "SRJWT03004: mpJwtPublicKey parsed as PEM";
    }
    @Override
    public final void unsupportedKeyFormat() {
        super.log.logf(FQCN, DEBUG, null, unsupportedKeyFormat$str());
    }
    protected String unsupportedKeyFormat$str() {
        return "SRJWT03005: Unsupported key format";
    }
    @Override
    public final void replacedConfig(final String originalConfig, final String newConfig) {
        super.log.logf(FQCN, WARN, null, replacedConfig$str(), originalConfig, newConfig);
    }
    protected String replacedConfig$str() {
        return "SRJWT03006: '%s' property is deprecated and will be removed in a future version. Use '%s ' property instead";
    }
    @Override
    public final void publicKeyConfiguredButOtherKeyPropertiesAreAlsoUsed() {
        super.log.logf(FQCN, WARN, null, publicKeyConfiguredButOtherKeyPropertiesAreAlsoUsed$str());
    }
    protected String publicKeyConfiguredButOtherKeyPropertiesAreAlsoUsed$str() {
        return "SRJWT03007: Public key is configured but either the secret key or key location are also configured and will be ignored";
    }
    @Override
    public final void secretKeyConfiguredButKeyLocationIsAlsoUsed() {
        super.log.logf(FQCN, WARN, null, secretKeyConfiguredButKeyLocationIsAlsoUsed$str());
    }
    protected String secretKeyConfiguredButKeyLocationIsAlsoUsed$str() {
        return "SRJWT03008: Secret key is configured but the key location is also configured and will be ignored";
    }
}
