package io.smallrye.jwt.auth;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class AuthLogging_$logger extends DelegatingBasicLogger implements AuthLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = AuthLogging_$logger.class.getName();
    public AuthLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void tokenHeaderName(final String headerName) {
        super.log.logf(FQCN, DEBUG, null, tokenHeaderName$str(), headerName);
    }
    protected String tokenHeaderName$str() {
        return "SRJWT06000: tokenHeaderName = %s";
    }
    @Override
    public final void headerIsNull(final String headerName) {
        super.log.logf(FQCN, DEBUG, null, headerIsNull$str(), headerName);
    }
    protected String headerIsNull$str() {
        return "SRJWT06001: Header %s was null";
    }
    @Override
    public final void tokenCookieName(final String cookieName) {
        super.log.logf(FQCN, DEBUG, null, tokenCookieName$str(), cookieName);
    }
    protected String tokenCookieName$str() {
        return "SRJWT06002: tokenCookieName = %s";
    }
    @Override
    public final void cookieIsNull(final String cookieName) {
        super.log.logf(FQCN, DEBUG, null, cookieIsNull$str(), cookieName);
    }
    protected String cookieIsNull$str() {
        return "SRJWT06003: Cookie %s was null";
    }
    @Override
    public final void authHeaderDoesNotContainBearerPrefix() {
        super.log.logf(FQCN, DEBUG, null, authHeaderDoesNotContainBearerPrefix$str());
    }
    protected String authHeaderDoesNotContainBearerPrefix$str() {
        return "SRJWT06004: Authorization header does not contain a Bearer prefix";
    }
    @Override
    public final void authHeaderIsNull() {
        super.log.logf(FQCN, DEBUG, null, authHeaderIsNull$str());
    }
    protected String authHeaderIsNull$str() {
        return "SRJWT06005: Authorization header was null";
    }
}
