package io.smallrye.jwt.build.spi;

import java.util.Locale;
import java.io.Serializable;
import java.lang.Throwable;
import io.smallrye.jwt.build.JwtException;
import java.lang.String;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class SpiMessages_$bundle implements SpiMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected SpiMessages_$bundle() {}
    public static final SpiMessages_$bundle INSTANCE = new SpiMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String providerNotFound$str() {
        return "SRJWT04000: JwtProvider %s has not been found: %s";
    }
    @Override
    public final JwtException providerNotFound(final String provider, final String exceptionMessage, final Throwable throwable) {
        final JwtException result = new JwtException(String.format(getLoggingLocale(), providerNotFound$str(), provider, exceptionMessage), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String providerClassCannotBeAccessed$str() {
        return "SRJWT04001: JwtProvider %s class could not be accessed: %s";
    }
    @Override
    public final JwtException providerClassCannotBeAccessed(final String provider, final String exceptionMessage, final Throwable throwable) {
        final JwtException result = new JwtException(String.format(getLoggingLocale(), providerClassCannotBeAccessed$str(), provider, exceptionMessage), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String providerCannotBeInstantiated$str() {
        return "SRJWT04002: JwtProvider %s could not be instantiated: %s";
    }
    @Override
    public final JwtException providerCannotBeInstantiated(final String provider, final String exceptionMessage, final Throwable throwable) {
        final JwtException result = new JwtException(String.format(getLoggingLocale(), providerCannotBeInstantiated$str(), provider, exceptionMessage), throwable);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
