/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.config.FallbackValidation;
import io.smallrye.faulttolerance.config.SecurityActions;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.PrivilegedActionException;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public interface FallbackConfig
extends Fallback,
Config {
    default public void validate() {
        String INVALID_FALLBACK_ON = "Invalid @Fallback on ";
        Method guardedMethod = null;
        try {
            guardedMethod = this.method().reflect();
        }
        catch (NoSuchMethodException e) {
            throw new FaultToleranceDefinitionException((Throwable)e);
        }
        if (!"".equals(this.fallbackMethod())) {
            Method fallbackMethod;
            if (!Fallback.DEFAULT.class.equals((Object)this.value())) {
                throw new FaultToleranceDefinitionException("Invalid @Fallback on " + this.method() + ": fallback handler class and fallback method can't be specified both at the same time");
            }
            try {
                fallbackMethod = SecurityActions.getDeclaredMethod(this.beanClass(), guardedMethod.getDeclaringClass(), this.fallbackMethod(), guardedMethod.getGenericParameterTypes());
            }
            catch (PrivilegedActionException e) {
                throw new FaultToleranceDefinitionException("Invalid @Fallback on " + this.method() + ": can't find fallback method " + this.fallbackMethod() + " with same parameters as the method", (Throwable)e);
            }
            if (fallbackMethod == null) {
                throw new FaultToleranceDefinitionException("Invalid @Fallback on " + this.method() + ": can't find fallback method " + this.fallbackMethod() + " with same parameters as the method");
            }
            if (!guardedMethod.getReturnType().equals(Void.TYPE) && !FallbackValidation.isAssignableFrom(guardedMethod.getGenericReturnType(), fallbackMethod.getGenericReturnType())) {
                throw new FaultToleranceDefinitionException("Invalid @Fallback on " + this.method() + ": fallback method " + this.fallbackMethod() + " return type '" + fallbackMethod.getGenericReturnType() + "' is not assignable to method's return type '" + guardedMethod.getGenericReturnType() + "'");
            }
        }
        if (!Fallback.DEFAULT.class.equals((Object)this.value())) {
            Type boxedReturnType;
            Class fbhc = this.value();
            Type fallbackType = null;
            for (Type genericInterface : fbhc.getGenericInterfaces()) {
                ParameterizedType parameterizedType;
                if (!(genericInterface instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)genericInterface).getRawType().equals(FallbackHandler.class)) continue;
                fallbackType = parameterizedType.getActualTypeArguments()[0];
                break;
            }
            if (!(boxedReturnType = FallbackValidation.box(guardedMethod.getGenericReturnType())).equals(fallbackType)) {
                throw new FaultToleranceDefinitionException("Invalid @Fallback on " + this.method() + ": fallback handler's type " + fallbackType + " is not the same as method's return type");
            }
        }
    }
}

