/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.apiimpl;

import io.smallrye.faulttolerance.api.CircuitBreakerState;
import io.smallrye.faulttolerance.api.CustomBackoffStrategy;
import io.smallrye.faulttolerance.api.FaultTolerance;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.Invocation;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.apiimpl.BasicCircuitBreakerMaintenanceImpl;
import io.smallrye.faulttolerance.core.apiimpl.EventHandlers;
import io.smallrye.faulttolerance.core.async.CompletionStageExecution;
import io.smallrye.faulttolerance.core.async.RememberEventLoop;
import io.smallrye.faulttolerance.core.async.types.AsyncTypes;
import io.smallrye.faulttolerance.core.async.types.AsyncTypesConversion;
import io.smallrye.faulttolerance.core.bulkhead.CompletionStageThreadPoolBulkhead;
import io.smallrye.faulttolerance.core.bulkhead.SemaphoreBulkhead;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreakerEvents;
import io.smallrye.faulttolerance.core.circuit.breaker.CompletionStageCircuitBreaker;
import io.smallrye.faulttolerance.core.event.loop.EventLoop;
import io.smallrye.faulttolerance.core.fallback.CompletionStageFallback;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import io.smallrye.faulttolerance.core.retry.BackOff;
import io.smallrye.faulttolerance.core.retry.CompletionStageRetry;
import io.smallrye.faulttolerance.core.retry.ConstantBackOff;
import io.smallrye.faulttolerance.core.retry.CustomBackOff;
import io.smallrye.faulttolerance.core.retry.ExponentialBackOff;
import io.smallrye.faulttolerance.core.retry.FibonacciBackOff;
import io.smallrye.faulttolerance.core.retry.Jitter;
import io.smallrye.faulttolerance.core.retry.RandomJitter;
import io.smallrye.faulttolerance.core.retry.Retry;
import io.smallrye.faulttolerance.core.retry.ThreadSleepDelay;
import io.smallrye.faulttolerance.core.retry.TimerDelay;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.stopwatch.SystemStopwatch;
import io.smallrye.faulttolerance.core.timeout.CompletionStageTimeout;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatcher;
import io.smallrye.faulttolerance.core.timeout.TimerTimeoutWatcher;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.core.util.DirectExecutor;
import io.smallrye.faulttolerance.core.util.ExceptionDecision;
import io.smallrye.faulttolerance.core.util.Initializer;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class FaultToleranceImpl<T>
implements FaultTolerance<T> {
    private final FaultToleranceStrategy<T> strategy;
    private final EventHandlers eventHandlers;
    private final Initializer initializer;

    FaultToleranceImpl(FaultToleranceStrategy<T> strategy, EventHandlers eventHandlers, Initializer initializer) {
        this.strategy = strategy;
        this.eventHandlers = eventHandlers;
        this.initializer = initializer;
    }

    public T call(Callable<T> action) throws Exception {
        this.initializer.runOnce();
        InvocationContext<T> ctx = new InvocationContext<T>(action);
        this.eventHandlers.register(ctx);
        return this.strategy.apply(ctx);
    }

    public static final class BuilderImpl<T, R>
    implements FaultTolerance.Builder<T, R> {
        private final boolean ftEnabled;
        private final Executor executor;
        private final Timer timer;
        private final EventLoop eventLoop;
        private final BasicCircuitBreakerMaintenanceImpl cbMaintenance;
        private final boolean isAsync;
        private final Class<?> asyncType;
        private final Function<FaultTolerance<T>, R> finisher;
        private String description;
        private BulkheadBuilderImpl<T, R> bulkheadBuilder;
        private CircuitBreakerBuilderImpl<T, R> circuitBreakerBuilder;
        private FallbackBuilderImpl<T, R> fallbackBuilder;
        private RetryBuilderImpl<T, R> retryBuilder;
        private TimeoutBuilderImpl<T, R> timeoutBuilder;
        private boolean offloadToAnotherThread;

        public BuilderImpl(boolean ftEnabled, Executor executor, Timer timer, EventLoop eventLoop, BasicCircuitBreakerMaintenanceImpl cbMaintenance, boolean isAsync, Class<?> asyncType, Function<FaultTolerance<T>, R> finisher) {
            this.ftEnabled = ftEnabled;
            this.executor = executor;
            this.timer = timer;
            this.eventLoop = eventLoop;
            this.cbMaintenance = cbMaintenance;
            this.isAsync = isAsync;
            this.asyncType = asyncType;
            this.finisher = finisher;
            this.description = UUID.randomUUID().toString();
        }

        public FaultTolerance.Builder<T, R> withDescription(String value) {
            this.description = Preconditions.checkNotNull(value, "Description must be set");
            return this;
        }

        public FaultTolerance.Builder.BulkheadBuilder<T, R> withBulkhead() {
            return new BulkheadBuilderImpl(this);
        }

        public FaultTolerance.Builder.CircuitBreakerBuilder<T, R> withCircuitBreaker() {
            return new CircuitBreakerBuilderImpl(this);
        }

        public FaultTolerance.Builder.FallbackBuilder<T, R> withFallback() {
            return new FallbackBuilderImpl(this);
        }

        public FaultTolerance.Builder.RetryBuilder<T, R> withRetry() {
            return new RetryBuilderImpl(this);
        }

        public FaultTolerance.Builder.TimeoutBuilder<T, R> withTimeout() {
            return new TimeoutBuilderImpl(this);
        }

        public FaultTolerance.Builder<T, R> withThreadOffload(boolean value) {
            if (!this.isAsync) {
                throw new IllegalStateException("Thread offload may only be set for asynchronous invocations");
            }
            this.offloadToAnotherThread = value;
            return this;
        }

        public R build() {
            Consumer<CircuitBreakerEvents.StateTransition> cbMaintenanceEventHandler = null;
            if (this.circuitBreakerBuilder != null && ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).name != null) {
                cbMaintenanceEventHandler = this.cbMaintenance.stateTransitionEventHandler(((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).name);
            }
            EventHandlers eventHandlers = new EventHandlers(this.bulkheadBuilder != null ? ((BulkheadBuilderImpl)this.bulkheadBuilder).onAccepted : null, this.bulkheadBuilder != null ? ((BulkheadBuilderImpl)this.bulkheadBuilder).onRejected : null, this.bulkheadBuilder != null ? ((BulkheadBuilderImpl)this.bulkheadBuilder).onFinished : null, cbMaintenanceEventHandler, this.circuitBreakerBuilder != null ? ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).onStateChange : null, this.circuitBreakerBuilder != null ? ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).onSuccess : null, this.circuitBreakerBuilder != null ? ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).onFailure : null, this.circuitBreakerBuilder != null ? ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).onPrevented : null, this.retryBuilder != null ? ((RetryBuilderImpl)this.retryBuilder).onRetry : null, this.retryBuilder != null ? ((RetryBuilderImpl)this.retryBuilder).onSuccess : null, this.retryBuilder != null ? ((RetryBuilderImpl)this.retryBuilder).onFailure : null, this.timeoutBuilder != null ? ((TimeoutBuilderImpl)this.timeoutBuilder).onTimeout : null, this.timeoutBuilder != null ? ((TimeoutBuilderImpl)this.timeoutBuilder).onFinished : null);
            ArrayList<Runnable> initActions = new ArrayList<Runnable>();
            FaultToleranceStrategy<T> strategy = this.isAsync ? this.buildAsyncStrategy(initActions) : this.buildSyncStrategy(initActions);
            FaultToleranceImpl<T> result = new FaultToleranceImpl<T>(strategy, eventHandlers, new Initializer(initActions));
            return this.finisher.apply(result);
        }

        private FaultToleranceStrategy<T> buildSyncStrategy(List<Runnable> initActions) {
            FaultToleranceStrategy<Object> result = Invocation.invocation();
            if (this.ftEnabled && this.bulkheadBuilder != null) {
                result = new SemaphoreBulkhead(result, this.description, ((BulkheadBuilderImpl)this.bulkheadBuilder).limit);
            }
            if (this.ftEnabled && this.timeoutBuilder != null) {
                result = new Timeout(result, this.description, ((TimeoutBuilderImpl)this.timeoutBuilder).durationInMillis, new TimerTimeoutWatcher(this.timer));
            }
            if (this.ftEnabled && this.circuitBreakerBuilder != null) {
                result = new CircuitBreaker(result, this.description, BuilderImpl.createExceptionDecision(((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).skipOn, ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).failOn), ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).delayInMillis, ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).requestVolumeThreshold, ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).failureRatio, ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).successThreshold, new SystemStopwatch());
                if (((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).name != null) {
                    this.cbMaintenance.registerName(((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).name);
                    CircuitBreaker circuitBreaker = (CircuitBreaker)result;
                    initActions.add(() -> this.cbMaintenance.register(((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).name, circuitBreaker));
                }
            }
            if (this.ftEnabled && this.retryBuilder != null) {
                Supplier<BackOff> backoff = BuilderImpl.prepareRetryBackoff(this.retryBuilder);
                result = new Retry(result, this.description, BuilderImpl.createExceptionDecision(((RetryBuilderImpl)this.retryBuilder).abortOn, ((RetryBuilderImpl)this.retryBuilder).retryOn), ((RetryBuilderImpl)this.retryBuilder).maxRetries, ((RetryBuilderImpl)this.retryBuilder).maxDurationInMillis, () -> new ThreadSleepDelay((BackOff)backoff.get()), new SystemStopwatch());
            }
            if (this.fallbackBuilder != null) {
                FallbackFunction<Object> fallbackFunction = ctx -> ((FallbackBuilderImpl)this.fallbackBuilder).handler.apply(ctx.failure);
                result = new Fallback<Object>(result, this.description, fallbackFunction, BuilderImpl.createExceptionDecision(((FallbackBuilderImpl)this.fallbackBuilder).skipOn, ((FallbackBuilderImpl)this.fallbackBuilder).applyOn));
            }
            return result;
        }

        private FaultToleranceStrategy<T> buildAsyncStrategy(List<Runnable> initActions) {
            FaultToleranceStrategy<Object> result = Invocation.invocation();
            result = new AsyncTypesConversion.ToCompletionStage(result, AsyncTypes.get(this.asyncType));
            result = this.buildCompletionStageChain(result, initActions);
            result = new AsyncTypesConversion.FromCompletionStage(result, AsyncTypes.get(this.asyncType));
            return result;
        }

        private FaultToleranceStrategy<CompletionStage<T>> buildCompletionStageChain(FaultToleranceStrategy<CompletionStage<T>> invocation, List<Runnable> initActions) {
            FaultToleranceStrategy result = invocation;
            Executor executor = this.offloadToAnotherThread ? this.executor : DirectExecutor.INSTANCE;
            result = new CompletionStageExecution(result, executor);
            if (this.ftEnabled && this.bulkheadBuilder != null) {
                result = new CompletionStageThreadPoolBulkhead(result, this.description, ((BulkheadBuilderImpl)this.bulkheadBuilder).limit, ((BulkheadBuilderImpl)this.bulkheadBuilder).queueSize);
            }
            if (this.ftEnabled && this.timeoutBuilder != null) {
                result = new CompletionStageTimeout(result, this.description, ((TimeoutBuilderImpl)this.timeoutBuilder).durationInMillis, (TimeoutWatcher)new TimerTimeoutWatcher(this.timer));
            }
            if (this.ftEnabled && this.circuitBreakerBuilder != null) {
                result = new CompletionStageCircuitBreaker(result, this.description, BuilderImpl.createExceptionDecision(((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).skipOn, ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).failOn), ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).delayInMillis, ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).requestVolumeThreshold, ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).failureRatio, ((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).successThreshold, (Stopwatch)new SystemStopwatch());
                if (((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).name != null) {
                    this.cbMaintenance.registerName(((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).name);
                    CircuitBreaker circuitBreaker = (CircuitBreaker)result;
                    initActions.add(() -> this.cbMaintenance.register(((CircuitBreakerBuilderImpl)this.circuitBreakerBuilder).name, circuitBreaker));
                }
            }
            if (this.ftEnabled && this.retryBuilder != null) {
                Supplier<BackOff> backoff = BuilderImpl.prepareRetryBackoff(this.retryBuilder);
                result = new CompletionStageRetry(result, this.description, BuilderImpl.createExceptionDecision(((RetryBuilderImpl)this.retryBuilder).abortOn, ((RetryBuilderImpl)this.retryBuilder).retryOn), (long)((RetryBuilderImpl)this.retryBuilder).maxRetries, ((RetryBuilderImpl)this.retryBuilder).maxDurationInMillis, () -> new TimerDelay((BackOff)backoff.get(), this.timer), (Stopwatch)new SystemStopwatch());
            }
            if (this.fallbackBuilder != null) {
                FallbackFunction fallbackFunction = ctx -> (CompletionStage)AsyncTypes.toCompletionStageIfRequired(((FallbackBuilderImpl)this.fallbackBuilder).handler.apply(ctx.failure), this.asyncType);
                result = new CompletionStageFallback(result, this.description, fallbackFunction, BuilderImpl.createExceptionDecision(((FallbackBuilderImpl)this.fallbackBuilder).skipOn, ((FallbackBuilderImpl)this.fallbackBuilder).applyOn));
            }
            if (!this.offloadToAnotherThread) {
                result = new RememberEventLoop(result, this.eventLoop);
            }
            return result;
        }

        private static long getTimeInMs(long time, ChronoUnit unit) {
            return Duration.of(time, unit).toMillis();
        }

        private static ExceptionDecision createExceptionDecision(Collection<Class<? extends Throwable>> consideredExpected, Collection<Class<? extends Throwable>> consideredFailure) {
            return new ExceptionDecision(BuilderImpl.createSetOfThrowables(consideredFailure), BuilderImpl.createSetOfThrowables(consideredExpected), true);
        }

        private static SetOfThrowables createSetOfThrowables(Collection<Class<? extends Throwable>> throwableClasses) {
            return throwableClasses == null ? SetOfThrowables.EMPTY : SetOfThrowables.create(throwableClasses);
        }

        private static Supplier<BackOff> prepareRetryBackoff(RetryBuilderImpl<?, ?> retryBuilder) {
            Jitter jitter;
            long jitterMs = ((RetryBuilderImpl)retryBuilder).jitterInMillis;
            Jitter jitter2 = jitter = jitterMs == 0L ? Jitter.ZERO : new RandomJitter(jitterMs);
            if (((RetryBuilderImpl)retryBuilder).exponentialBackoffBuilder != null) {
                int factor = ((RetryBuilderImpl)retryBuilder).exponentialBackoffBuilder.factor;
                long maxDelay = ((RetryBuilderImpl)retryBuilder).exponentialBackoffBuilder.maxDelayInMillis;
                return () -> new ExponentialBackOff(((RetryBuilderImpl)retryBuilder).delayInMillis, factor, jitter, maxDelay);
            }
            if (((RetryBuilderImpl)retryBuilder).fibonacciBackoffBuilder != null) {
                long maxDelay = ((RetryBuilderImpl)retryBuilder).fibonacciBackoffBuilder.maxDelayInMillis;
                return () -> new FibonacciBackOff(((RetryBuilderImpl)retryBuilder).delayInMillis, jitter, maxDelay);
            }
            if (((RetryBuilderImpl)retryBuilder).customBackoffBuilder != null) {
                Supplier strategy = ((RetryBuilderImpl)retryBuilder).customBackoffBuilder.strategy;
                return () -> BuilderImpl.lambda$prepareRetryBackoff$8((Supplier)strategy, retryBuilder);
            }
            return () -> new ConstantBackOff(((RetryBuilderImpl)retryBuilder).delayInMillis, jitter);
        }

        private static /* synthetic */ BackOff lambda$prepareRetryBackoff$8(Supplier strategy, RetryBuilderImpl retryBuilder) {
            CustomBackoffStrategy instance = (CustomBackoffStrategy)strategy.get();
            instance.init(retryBuilder.delayInMillis);
            return new CustomBackOff(arg_0 -> ((CustomBackoffStrategy)instance).nextDelayInMillis(arg_0));
        }

        static class TimeoutBuilderImpl<T, R>
        implements FaultTolerance.Builder.TimeoutBuilder<T, R> {
            private final BuilderImpl<T, R> parent;
            private long durationInMillis = 1000L;
            private Runnable onTimeout;
            private Runnable onFinished;

            TimeoutBuilderImpl(BuilderImpl<T, R> parent) {
                this.parent = parent;
            }

            public FaultTolerance.Builder.TimeoutBuilder<T, R> duration(long value, ChronoUnit unit) {
                Preconditions.check(value, value >= 0L, "Timeout duration must be >= 0");
                Preconditions.checkNotNull(unit, "Timeout duration unit must be set");
                this.durationInMillis = BuilderImpl.getTimeInMs(value, unit);
                return this;
            }

            public FaultTolerance.Builder.TimeoutBuilder<T, R> onTimeout(Runnable callback) {
                this.onTimeout = Preconditions.checkNotNull(callback, "Timeout callback must be set");
                return this;
            }

            public FaultTolerance.Builder.TimeoutBuilder<T, R> onFinished(Runnable callback) {
                this.onFinished = Preconditions.checkNotNull(callback, "Finished callback must be set");
                return this;
            }

            public FaultTolerance.Builder<T, R> done() {
                ((BuilderImpl)this.parent).timeoutBuilder = this;
                return this.parent;
            }
        }

        static class RetryBuilderImpl<T, R>
        implements FaultTolerance.Builder.RetryBuilder<T, R> {
            private final BuilderImpl<T, R> parent;
            private int maxRetries = 3;
            private long delayInMillis = 0L;
            private long maxDurationInMillis = 180000L;
            private long jitterInMillis = 200L;
            private Collection<Class<? extends Throwable>> retryOn = Collections.singleton(Exception.class);
            private Collection<Class<? extends Throwable>> abortOn = Collections.emptySet();
            private ExponentialBackoffBuilderImpl<T, R> exponentialBackoffBuilder;
            private FibonacciBackoffBuilderImpl<T, R> fibonacciBackoffBuilder;
            private CustomBackoffBuilderImpl<T, R> customBackoffBuilder;
            private Runnable onRetry;
            private Runnable onSuccess;
            private Runnable onFailure;

            RetryBuilderImpl(BuilderImpl<T, R> parent) {
                this.parent = parent;
            }

            public FaultTolerance.Builder.RetryBuilder<T, R> maxRetries(int value) {
                this.maxRetries = Preconditions.check(value, value >= -1, "Max retries must be >= -1");
                return this;
            }

            public FaultTolerance.Builder.RetryBuilder<T, R> delay(long value, ChronoUnit unit) {
                Preconditions.check(value, value >= 0L, "Delay must be >= 0");
                Preconditions.checkNotNull(unit, "Delay unit must be set");
                this.delayInMillis = BuilderImpl.getTimeInMs(value, unit);
                return this;
            }

            public FaultTolerance.Builder.RetryBuilder<T, R> maxDuration(long value, ChronoUnit unit) {
                Preconditions.check(value, value >= 0L, "Max duration must be >= 0");
                Preconditions.checkNotNull(unit, "Max duration unit must be set");
                this.maxDurationInMillis = BuilderImpl.getTimeInMs(value, unit);
                return this;
            }

            public FaultTolerance.Builder.RetryBuilder<T, R> jitter(long value, ChronoUnit unit) {
                Preconditions.check(value, value >= 0L, "Jitter must be >= 0");
                Preconditions.checkNotNull(unit, "Jitter unit must be set");
                this.jitterInMillis = BuilderImpl.getTimeInMs(value, unit);
                return this;
            }

            public FaultTolerance.Builder.RetryBuilder<T, R> retryOn(Collection<Class<? extends Throwable>> value) {
                this.retryOn = Preconditions.checkNotNull(value, "Exceptions to retry on must be set");
                return this;
            }

            public FaultTolerance.Builder.RetryBuilder<T, R> abortOn(Collection<Class<? extends Throwable>> value) {
                this.abortOn = Preconditions.checkNotNull(value, "Exceptions to abort retrying on must be set");
                return this;
            }

            public FaultTolerance.Builder.RetryBuilder.ExponentialBackoffBuilder<T, R> withExponentialBackoff() {
                return new ExponentialBackoffBuilderImpl(this);
            }

            public FaultTolerance.Builder.RetryBuilder.FibonacciBackoffBuilder<T, R> withFibonacciBackoff() {
                return new FibonacciBackoffBuilderImpl(this);
            }

            public FaultTolerance.Builder.RetryBuilder.CustomBackoffBuilder<T, R> withCustomBackoff() {
                return new CustomBackoffBuilderImpl(this);
            }

            public FaultTolerance.Builder.RetryBuilder<T, R> onRetry(Runnable callback) {
                this.onRetry = Preconditions.checkNotNull(callback, "Retry callback must be set");
                return this;
            }

            public FaultTolerance.Builder.RetryBuilder<T, R> onSuccess(Runnable callback) {
                this.onSuccess = Preconditions.checkNotNull(callback, "Success callback must be set");
                return this;
            }

            public FaultTolerance.Builder.RetryBuilder<T, R> onFailure(Runnable callback) {
                this.onFailure = Preconditions.checkNotNull(callback, "Failure callback must be set");
                return this;
            }

            public FaultTolerance.Builder<T, R> done() {
                int backoffStrategies = 0;
                if (this.exponentialBackoffBuilder != null) {
                    ++backoffStrategies;
                }
                if (this.fibonacciBackoffBuilder != null) {
                    ++backoffStrategies;
                }
                if (this.customBackoffBuilder != null) {
                    ++backoffStrategies;
                }
                if (backoffStrategies > 1) {
                    throw new IllegalStateException("Only one backoff strategy may be set for retry");
                }
                ((BuilderImpl)this.parent).retryBuilder = this;
                return this.parent;
            }

            static class CustomBackoffBuilderImpl<T, R>
            implements FaultTolerance.Builder.RetryBuilder.CustomBackoffBuilder<T, R> {
                private final RetryBuilderImpl<T, R> parent;
                private Supplier<CustomBackoffStrategy> strategy;

                CustomBackoffBuilderImpl(RetryBuilderImpl<T, R> parent) {
                    this.parent = parent;
                }

                public FaultTolerance.Builder.RetryBuilder.CustomBackoffBuilder<T, R> strategy(Supplier<CustomBackoffStrategy> value) {
                    this.strategy = Preconditions.checkNotNull(value, "Custom backoff strategy must be set");
                    return this;
                }

                public FaultTolerance.Builder.RetryBuilder<T, R> done() {
                    Preconditions.checkNotNull(this.strategy, "Custom backoff strategy must be set");
                    ((RetryBuilderImpl)this.parent).customBackoffBuilder = this;
                    return this.parent;
                }
            }

            static class FibonacciBackoffBuilderImpl<T, R>
            implements FaultTolerance.Builder.RetryBuilder.FibonacciBackoffBuilder<T, R> {
                private final RetryBuilderImpl<T, R> parent;
                private long maxDelayInMillis = 60000L;

                FibonacciBackoffBuilderImpl(RetryBuilderImpl<T, R> parent) {
                    this.parent = parent;
                }

                public FaultTolerance.Builder.RetryBuilder.FibonacciBackoffBuilder<T, R> maxDelay(long value, ChronoUnit unit) {
                    Preconditions.check(value, value >= 0L, "Max delay must be >= 0");
                    Preconditions.checkNotNull(unit, "Max delay unit must be set");
                    this.maxDelayInMillis = BuilderImpl.getTimeInMs(value, unit);
                    return this;
                }

                public FaultTolerance.Builder.RetryBuilder<T, R> done() {
                    ((RetryBuilderImpl)this.parent).fibonacciBackoffBuilder = this;
                    return this.parent;
                }
            }

            static class ExponentialBackoffBuilderImpl<T, R>
            implements FaultTolerance.Builder.RetryBuilder.ExponentialBackoffBuilder<T, R> {
                private final RetryBuilderImpl<T, R> parent;
                private int factor = 2;
                private long maxDelayInMillis = 60000L;

                ExponentialBackoffBuilderImpl(RetryBuilderImpl<T, R> parent) {
                    this.parent = parent;
                }

                public FaultTolerance.Builder.RetryBuilder.ExponentialBackoffBuilder<T, R> factor(int value) {
                    this.factor = Preconditions.check(value, value >= 1, "Factor must be >= 1");
                    return this;
                }

                public FaultTolerance.Builder.RetryBuilder.ExponentialBackoffBuilder<T, R> maxDelay(long value, ChronoUnit unit) {
                    Preconditions.check(value, value >= 0L, "Max delay must be >= 0");
                    Preconditions.checkNotNull(unit, "Max delay unit must be set");
                    this.maxDelayInMillis = BuilderImpl.getTimeInMs(value, unit);
                    return this;
                }

                public FaultTolerance.Builder.RetryBuilder<T, R> done() {
                    ((RetryBuilderImpl)this.parent).exponentialBackoffBuilder = this;
                    return this.parent;
                }
            }
        }

        static class FallbackBuilderImpl<T, R>
        implements FaultTolerance.Builder.FallbackBuilder<T, R> {
            private final BuilderImpl<T, R> parent;
            private Function<Throwable, T> handler;
            private Collection<Class<? extends Throwable>> applyOn = Collections.singleton(Throwable.class);
            private Collection<Class<? extends Throwable>> skipOn = Collections.emptySet();

            FallbackBuilderImpl(BuilderImpl<T, R> parent) {
                this.parent = parent;
            }

            public FaultTolerance.Builder.FallbackBuilder<T, R> handler(Supplier<T> value) {
                Preconditions.checkNotNull(value, "Fallback handler must be set");
                this.handler = ignored -> value.get();
                return this;
            }

            public FaultTolerance.Builder.FallbackBuilder<T, R> handler(Function<Throwable, T> value) {
                this.handler = Preconditions.checkNotNull(value, "Fallback handler must be set");
                return this;
            }

            public FaultTolerance.Builder.FallbackBuilder<T, R> applyOn(Collection<Class<? extends Throwable>> value) {
                this.applyOn = Preconditions.checkNotNull(value, "Exceptions to apply fallback on must be set");
                return this;
            }

            public FaultTolerance.Builder.FallbackBuilder<T, R> skipOn(Collection<Class<? extends Throwable>> value) {
                this.skipOn = Preconditions.checkNotNull(value, "Exceptions to skip fallback on must be set");
                return this;
            }

            public FaultTolerance.Builder<T, R> done() {
                Preconditions.checkNotNull(this.handler, "Fallback handler must be set");
                ((BuilderImpl)this.parent).fallbackBuilder = this;
                return this.parent;
            }
        }

        static class CircuitBreakerBuilderImpl<T, R>
        implements FaultTolerance.Builder.CircuitBreakerBuilder<T, R> {
            private final BuilderImpl<T, R> parent;
            private Collection<Class<? extends Throwable>> failOn = Collections.singleton(Throwable.class);
            private Collection<Class<? extends Throwable>> skipOn = Collections.emptySet();
            private long delayInMillis = 5000L;
            private int requestVolumeThreshold = 20;
            private double failureRatio = 0.5;
            private int successThreshold = 1;
            private String name;
            private Consumer<CircuitBreakerState> onStateChange;
            private Runnable onSuccess;
            private Runnable onFailure;
            private Runnable onPrevented;

            CircuitBreakerBuilderImpl(BuilderImpl<T, R> parent) {
                this.parent = parent;
            }

            public FaultTolerance.Builder.CircuitBreakerBuilder<T, R> failOn(Collection<Class<? extends Throwable>> value) {
                this.failOn = Preconditions.checkNotNull(value, "Exceptions considered failure must be set");
                return this;
            }

            public FaultTolerance.Builder.CircuitBreakerBuilder<T, R> skipOn(Collection<Class<? extends Throwable>> value) {
                this.skipOn = Preconditions.checkNotNull(value, "Exceptions considered success must be set");
                return this;
            }

            public FaultTolerance.Builder.CircuitBreakerBuilder<T, R> delay(long value, ChronoUnit unit) {
                Preconditions.check(value, value >= 0L, "Delay must be >= 0");
                Preconditions.checkNotNull(unit, "Delay unit must be set");
                this.delayInMillis = BuilderImpl.getTimeInMs(value, unit);
                return this;
            }

            public FaultTolerance.Builder.CircuitBreakerBuilder<T, R> requestVolumeThreshold(int value) {
                this.requestVolumeThreshold = Preconditions.check(value, value >= 1, "Request volume threshold must be >= 1");
                return this;
            }

            public FaultTolerance.Builder.CircuitBreakerBuilder<T, R> failureRatio(double value) {
                this.failureRatio = Preconditions.check(value, value >= 0.0 && value <= 1.0, "Failure ratio must be >= 0 and <= 1");
                return this;
            }

            public FaultTolerance.Builder.CircuitBreakerBuilder<T, R> successThreshold(int value) {
                this.successThreshold = Preconditions.check(value, value >= 1, "Success threshold must be >= 1");
                return this;
            }

            public FaultTolerance.Builder.CircuitBreakerBuilder<T, R> name(String value) {
                this.name = Preconditions.checkNotNull(value, "Circuit breaker name must be set");
                return this;
            }

            public FaultTolerance.Builder.CircuitBreakerBuilder<T, R> onStateChange(Consumer<CircuitBreakerState> callback) {
                this.onStateChange = Preconditions.checkNotNull(callback, "On state change callback must be set");
                return this;
            }

            public FaultTolerance.Builder.CircuitBreakerBuilder<T, R> onSuccess(Runnable callback) {
                this.onSuccess = Preconditions.checkNotNull(callback, "On success callback must be set");
                return this;
            }

            public FaultTolerance.Builder.CircuitBreakerBuilder<T, R> onFailure(Runnable callback) {
                this.onFailure = Preconditions.checkNotNull(callback, "On failure callback must be set");
                return this;
            }

            public FaultTolerance.Builder.CircuitBreakerBuilder<T, R> onPrevented(Runnable callback) {
                this.onPrevented = Preconditions.checkNotNull(callback, "On prevented callback must be set");
                return this;
            }

            public FaultTolerance.Builder<T, R> done() {
                ((BuilderImpl)this.parent).circuitBreakerBuilder = this;
                return this.parent;
            }
        }

        static class BulkheadBuilderImpl<T, R>
        implements FaultTolerance.Builder.BulkheadBuilder<T, R> {
            private final BuilderImpl<T, R> parent;
            private int limit = 10;
            private int queueSize = 10;
            private Runnable onAccepted;
            private Runnable onRejected;
            private Runnable onFinished;

            BulkheadBuilderImpl(BuilderImpl<T, R> parent) {
                this.parent = parent;
            }

            public FaultTolerance.Builder.BulkheadBuilder<T, R> limit(int value) {
                this.limit = Preconditions.check(value, value >= 1, "Limit must be >= 1");
                return this;
            }

            public FaultTolerance.Builder.BulkheadBuilder<T, R> queueSize(int value) {
                if (!((BuilderImpl)this.parent).isAsync) {
                    throw new IllegalStateException("Bulkhead queue size may only be set for asynchronous invocations");
                }
                this.queueSize = Preconditions.check(value, value >= 1, "Queue size must be >= 1");
                return this;
            }

            public FaultTolerance.Builder.BulkheadBuilder<T, R> onAccepted(Runnable callback) {
                this.onAccepted = Preconditions.checkNotNull(callback, "Accepted callback must be set");
                return this;
            }

            public FaultTolerance.Builder.BulkheadBuilder<T, R> onRejected(Runnable callback) {
                this.onRejected = Preconditions.checkNotNull(callback, "Rejected callback must be set");
                return this;
            }

            public FaultTolerance.Builder.BulkheadBuilder<T, R> onFinished(Runnable callback) {
                this.onFinished = Preconditions.checkNotNull(callback, "Finished callback must be set");
                return this;
            }

            public FaultTolerance.Builder<T, R> done() {
                ((BuilderImpl)this.parent).bulkheadBuilder = this;
                return this.parent;
            }
        }
    }
}

