/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.timeout;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.timeout.TimeoutEvent;
import io.smallrye.faulttolerance.core.util.NamedFutureTask;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;

public class AsyncTimeout<V>
implements FaultToleranceStrategy<Future<V>> {
    private final FaultToleranceStrategy<Future<V>> delegate;
    private final Executor executor;

    public AsyncTimeout(FaultToleranceStrategy<Future<V>> delegate, Executor executor) {
        this.delegate = delegate;
        this.executor = Preconditions.checkNotNull(executor, "Executor must be set");
    }

    @Override
    public Future<V> apply(InvocationContext<Future<V>> ctx) throws Exception {
        AsyncTimeoutTask<Future> task = new AsyncTimeoutTask<Future>("AsyncTimeout", () -> this.delegate.apply(ctx));
        ctx.registerEventHandler(TimeoutEvent.class, task::timedOut);
        this.executor.execute(task);
        try {
            return (Future)task.get();
        }
        catch (ExecutionException e) {
            throw SneakyThrow.sneakyThrow(e.getCause());
        }
    }

    private static class AsyncTimeoutTask<T>
    extends NamedFutureTask<T> {
        public AsyncTimeoutTask(String name, Callable<T> callable) {
            super(name, callable);
        }

        public void timedOut(TimeoutEvent event) {
            super.setException((Throwable)event.timeoutException());
        }
    }
}

