/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ImmutableArrayList;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeInterning;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.Utils;

final class MethodInternal {
    static final MethodInternal[] EMPTY_ARRAY = new MethodInternal[0];
    static final NameAndParameterComponentComparator NAME_AND_PARAMETER_COMPONENT_COMPARATOR = new NameAndParameterComponentComparator();
    static final byte[][] EMPTY_PARAMETER_NAMES = new byte[0][];
    private byte[] name;
    private byte[][] parameterNames;
    private Type[] parameterTypes;
    private Type returnType;
    private Type[] exceptions;
    private short flags;
    private ExtraInfo extra;
    private final Type[] descriptorParameterTypes;

    MethodInternal(byte[] name, byte[][] parameterNames, Type[] parameterTypes, Type returnType, short flags) {
        this(name, parameterNames, parameterTypes, returnType, flags, Type.EMPTY_ARRAY, Type.EMPTY_ARRAY);
    }

    MethodInternal(byte[] name, byte[][] parameterNames, Type[] parameterTypes, Type returnType, short flags, Type[] typeParameters, Type[] exceptions) {
        this(name, parameterNames, parameterTypes, returnType, flags, null, typeParameters, exceptions, AnnotationInstance.EMPTY_ARRAY, null);
    }

    MethodInternal(byte[] name, byte[][] parameterNames, Type[] parameterTypes, Type returnType, short flags, Type receiverType, Type[] typeParameters, Type[] exceptions, AnnotationInstance[] annotations, AnnotationValue defaultValue) {
        this.name = name;
        this.parameterNames = parameterNames;
        this.parameterTypes = parameterTypes.length == 0 ? Type.EMPTY_ARRAY : parameterTypes;
        this.returnType = returnType;
        this.flags = flags;
        this.exceptions = exceptions;
        if (annotations != null && annotations.length > 0) {
            if (this.extra == null) {
                this.extra = new ExtraInfo();
            }
            this.extra.annotations = annotations;
        }
        if (typeParameters != null && typeParameters.length > 0) {
            if (this.extra == null) {
                this.extra = new ExtraInfo();
            }
            this.extra.typeParameters = typeParameters;
        }
        if (receiverType != null) {
            if (this.extra == null) {
                this.extra = new ExtraInfo();
            }
            this.extra.receiverType = receiverType;
        }
        if (defaultValue != null) {
            if (this.extra == null) {
                this.extra = new ExtraInfo();
            }
            this.extra.defaultValue = defaultValue;
        }
        this.descriptorParameterTypes = this.parameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInternal methodInternal = (MethodInternal)o;
        if (this.extra != null && methodInternal.extra == null || this.extra == null && methodInternal.extra != null) {
            return false;
        }
        if (this.flags != methodInternal.flags) {
            return false;
        }
        if (this.extra != null && !Arrays.equals(this.extra.annotations, methodInternal.extra.annotations)) {
            return false;
        }
        if (!Arrays.equals(this.exceptions, methodInternal.exceptions)) {
            return false;
        }
        if (!Arrays.equals(this.name, methodInternal.name)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.parameterNames, (Object[])methodInternal.parameterNames)) {
            return false;
        }
        if (!Arrays.equals(this.parameterTypes, methodInternal.parameterTypes)) {
            return false;
        }
        if (!Arrays.equals(this.descriptorParameterTypes, methodInternal.descriptorParameterTypes)) {
            return false;
        }
        if (this.extra != null && (this.extra.receiverType != null ? !this.extra.receiverType.equals(methodInternal.extra.receiverType) : methodInternal.extra.receiverType != null)) {
            return false;
        }
        if (!this.returnType.equals(methodInternal.returnType)) {
            return false;
        }
        if (this.extra != null && (this.extra.defaultValue != null ? !this.extra.defaultValue.equals(methodInternal.extra.defaultValue) : methodInternal.extra.defaultValue != null)) {
            return false;
        }
        return this.extra == null || Arrays.equals(this.extra.typeParameters, methodInternal.extra.typeParameters);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.name);
        result = 31 * result + Arrays.deepHashCode((Object[])this.parameterNames);
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        result = 31 * result + Arrays.hashCode(this.descriptorParameterTypes);
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + Arrays.hashCode(this.exceptions);
        result = 31 * result + (this.extra != null && this.extra.receiverType != null ? this.extra.receiverType.hashCode() : 0);
        result = 31 * result + (this.extra != null ? Arrays.hashCode(this.extra.typeParameters) : 0);
        result = 31 * result + (this.extra != null && this.extra.defaultValue != null ? this.extra.defaultValue.hashCode() : 0);
        result = 31 * result + this.flags;
        return result;
    }

    boolean internEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInternal methodInternal = (MethodInternal)o;
        if (this.extra != null && methodInternal.extra == null || this.extra == null && methodInternal.extra != null) {
            return false;
        }
        if (this.flags != methodInternal.flags) {
            return false;
        }
        if (this.extra != null && !Arrays.equals(this.extra.annotations, methodInternal.extra.annotations)) {
            return false;
        }
        if (!TypeInterning.arrayEquals(this.exceptions, methodInternal.exceptions)) {
            return false;
        }
        if (!Arrays.equals(this.name, methodInternal.name)) {
            return false;
        }
        if (!Arrays.deepEquals((Object[])this.parameterNames, (Object[])methodInternal.parameterNames)) {
            return false;
        }
        if (!TypeInterning.arrayEquals(this.parameterTypes, methodInternal.parameterTypes)) {
            return false;
        }
        if (!TypeInterning.arrayEquals(this.descriptorParameterTypes, methodInternal.descriptorParameterTypes)) {
            return false;
        }
        if (this.extra != null && (this.extra.receiverType != null ? !this.extra.receiverType.internEquals(methodInternal.extra.receiverType) : methodInternal.extra.receiverType != null)) {
            return false;
        }
        if (!this.returnType.internEquals(methodInternal.returnType)) {
            return false;
        }
        if (this.extra != null && (this.extra.defaultValue != null ? !this.extra.defaultValue.equals(methodInternal.extra.defaultValue) : methodInternal.extra.defaultValue != null)) {
            return false;
        }
        return this.extra == null || TypeInterning.arrayEquals(this.extra.typeParameters, methodInternal.extra.typeParameters);
    }

    int internHashCode() {
        int result = Arrays.hashCode(this.name);
        result = 31 * result + Arrays.deepHashCode((Object[])this.parameterNames);
        result = 31 * result + TypeInterning.arrayHashCode(this.parameterTypes);
        result = 31 * result + TypeInterning.arrayHashCode(this.descriptorParameterTypes);
        result = 31 * result + this.returnType.internHashCode();
        result = 31 * result + TypeInterning.arrayHashCode(this.exceptions);
        result = 31 * result + (this.extra != null && this.extra.receiverType != null ? this.extra.receiverType.internHashCode() : 0);
        result = 31 * result + (this.extra != null ? TypeInterning.arrayHashCode(this.extra.typeParameters) : 0);
        result = 31 * result + (this.extra != null ? Arrays.hashCode(this.extra.annotations) : 0);
        result = 31 * result + (this.extra != null && this.extra.defaultValue != null ? this.extra.defaultValue.hashCode() : 0);
        result = 31 * result + this.flags;
        return result;
    }

    final String name() {
        return Utils.fromUTF8(this.name);
    }

    final int parametersCount() {
        return this.parameterTypes.length;
    }

    final String parameterName(int i) {
        if (i >= this.parameterNames.length) {
            return null;
        }
        return Utils.fromUTF8(this.parameterNames[i]);
    }

    final byte[] nameBytes() {
        return this.name;
    }

    final byte[][] parameterNamesBytes() {
        return this.parameterNames;
    }

    final Type[] copyParameterTypes() {
        return (Type[])this.parameterTypes.clone();
    }

    final Type[] parameterTypesArray() {
        return this.parameterTypes;
    }

    final Type[] copyExceptions() {
        return (Type[])this.exceptions.clone();
    }

    final List<Type> parameterTypes() {
        return new ImmutableArrayList<Type>(this.parameterTypes);
    }

    final List<Type> descriptorParameterTypes() {
        return new ImmutableArrayList<Type>(this.descriptorParameterTypes);
    }

    final Type[] descriptorParameterTypesArray() {
        return this.descriptorParameterTypes;
    }

    final Type returnType() {
        return this.returnType;
    }

    final Type receiverType(ClassInfo clazz) {
        if (this.extra != null && this.extra.receiverType != null) {
            return this.extra.receiverType;
        }
        if (clazz.typeParameterArray().length > 0) {
            Type[] classTypeParameters = clazz.typeParameterArray();
            Type[] receiverTypeArguments = new Type[classTypeParameters.length];
            for (int i = 0; i < classTypeParameters.length; ++i) {
                receiverTypeArguments[i] = classTypeParameters[i].copyType(AnnotationInstance.EMPTY_ARRAY);
            }
            return new ParameterizedType(clazz.name(), receiverTypeArguments, null);
        }
        return ClassType.create(clazz.name());
    }

    final Type receiverTypeField() {
        return this.extra != null ? this.extra.receiverType : null;
    }

    final List<Type> exceptions() {
        return new ImmutableArrayList<Type>(this.exceptions);
    }

    final Type[] exceptionArray() {
        return this.exceptions;
    }

    final List<TypeVariable> typeParameters() {
        return this.extra != null && this.extra.typeParameters != null ? new ImmutableArrayList<Type>(this.extra.typeParameters) : Collections.emptyList();
    }

    final List<AnnotationInstance> annotations() {
        return this.extra != null && this.extra.annotations != null ? new ImmutableArrayList<AnnotationInstance>(this.extra.annotations) : Collections.emptyList();
    }

    final AnnotationInstance[] annotationArray() {
        return this.extra != null && this.extra.annotations != null ? this.extra.annotations : AnnotationInstance.EMPTY_ARRAY;
    }

    final AnnotationInstance annotation(DotName name) {
        return this.extra != null && this.extra.annotations != null ? AnnotationInstance.binarySearch(this.extra.annotations, name) : null;
    }

    final boolean hasAnnotation(DotName name) {
        return this.annotation(name) != null;
    }

    final Type[] typeParameterArray() {
        return this.extra != null && this.extra.typeParameters != null ? this.extra.typeParameters : Type.EMPTY_ARRAY;
    }

    final AnnotationValue defaultValue() {
        return this.extra != null ? this.extra.defaultValue : null;
    }

    final short flags() {
        return this.flags;
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        String name = this.name();
        builder.append(this.returnType.toString(true)).append(' ').append(name).append('(');
        if (this.extra != null && this.extra.receiverType != null) {
            builder.append(this.extra.receiverType.toString(true)).append(" this");
            if (this.parameterTypes.length > 0) {
                builder.append(", ");
            }
        }
        for (i = 0; i < this.parameterTypes.length; ++i) {
            builder.append(this.parameterTypes[i].toString(true));
            String parameterName = this.parameterName(i);
            if (parameterName != null) {
                builder.append(' ');
                builder.append(parameterName);
            }
            if (i + 1 >= this.parameterTypes.length) continue;
            builder.append(", ");
        }
        builder.append(')');
        if (this.exceptions.length > 0) {
            builder.append(" throws ");
            for (i = 0; i < this.exceptions.length; ++i) {
                builder.append(this.exceptions[i].toString(true));
                if (i >= this.exceptions.length - 1) continue;
                builder.append(", ");
            }
        }
        return builder.toString();
    }

    void setTypeParameters(Type[] typeParameters) {
        if (typeParameters.length > 0) {
            if (this.extra == null) {
                this.extra = new ExtraInfo();
            }
            this.extra.typeParameters = typeParameters;
        }
    }

    void setParameterNames(byte[][] parameterNames) {
        this.parameterNames = parameterNames;
    }

    void setParameterTypes(Type[] parameterTypes) {
        this.parameterTypes = parameterTypes.length == 0 ? Type.EMPTY_ARRAY : parameterTypes;
    }

    void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    void setExceptions(Type[] exceptions) {
        this.exceptions = exceptions.length == 0 ? Type.EMPTY_ARRAY : exceptions;
    }

    void setReceiverType(Type receiverType) {
        if (this.extra == null) {
            this.extra = new ExtraInfo();
        }
        this.extra.receiverType = receiverType;
    }

    void setAnnotations(List<AnnotationInstance> annotations) {
        if (!annotations.isEmpty()) {
            if (this.extra == null) {
                this.extra = new ExtraInfo();
            }
            this.extra.annotations = annotations.toArray(new AnnotationInstance[0]);
            Arrays.sort(this.extra.annotations, AnnotationInstance.NAME_COMPARATOR);
        }
    }

    void setDefaultValue(AnnotationValue defaultValue) {
        if (this.extra == null) {
            this.extra = new ExtraInfo();
        }
        this.extra.defaultValue = defaultValue;
    }

    private static final class ExtraInfo {
        Type receiverType;
        Type[] typeParameters;
        AnnotationValue defaultValue;
        AnnotationInstance[] annotations;

        private ExtraInfo() {
        }
    }

    private static final class NameAndParameterComponentComparator
    implements Comparator<MethodInternal> {
        private NameAndParameterComponentComparator() {
        }

        @Override
        private int compare(byte[] left, byte[] right) {
            int i = 0;
            for (int j = 0; i < left.length && j < right.length; ++i, ++j) {
                int a = left[i] & 0xFF;
                int b = right[j] & 0xFF;
                if (a == b) continue;
                return a - b;
            }
            return left.length - right.length;
        }

        @Override
        public int compare(MethodInternal instance, MethodInternal instance2) {
            int x = this.compare(instance.name, instance2.name);
            if (x != 0) {
                return x;
            }
            Type[] parameterTypes1 = instance.parameterTypes;
            Type[] parameterTypes2 = instance2.parameterTypes;
            int min = Math.min(parameterTypes1.length, parameterTypes2.length);
            for (int i = 0; i < min; ++i) {
                Type t1 = parameterTypes1[i];
                Type t2 = parameterTypes2[i];
                x = t1.name().compareTo(t2.name());
                if (x == 0) continue;
                return x;
            }
            x = parameterTypes1.length - parameterTypes2.length;
            if (x != 0) {
                return x;
            }
            return (instance.flags & 0x1040) - (instance2.flags & 0x1040);
        }
    }
}

