package io.smallrye.config.inject;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.lang.reflect.Type;
import jakarta.enterprise.inject.spi.InjectionPoint;
import io.smallrye.config.inject.ConfigException;
import java.lang.Class;
import java.lang.String;
import java.util.Arrays;
import java.lang.Exception;
import java.util.NoSuchElementException;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
public class InjectionMessages_$bundle implements InjectionMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected InjectionMessages_$bundle() {}
    public static final InjectionMessages_$bundle INSTANCE = new InjectionMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String noConfigValue$str() {
        return "SRCFG02000: Failed to Inject @ConfigProperty for key %s into %s since the config property could not be found in any config source";
    }
    @Override
    public final io.smallrye.config.inject.ConfigException noConfigValue(final String configPropertyName, final String location) {
        final io.smallrye.config.inject.ConfigException result = new io.smallrye.config.inject.ConfigException(String.format(getLoggingLocale(), noConfigValue$str(), configPropertyName, location), configPropertyName);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String retrieveConfigFailure$str() {
        return "SRCFG02001: Failed to Inject @ConfigProperty for key %s into %s %s";
    }
    @Override
    public final io.smallrye.config.inject.ConfigException retrieveConfigFailure(final String configPropertyName, final String location, final String causeMessage, final Exception e) {
        final io.smallrye.config.inject.ConfigException result = new io.smallrye.config.inject.ConfigException(String.format(getLoggingLocale(), retrieveConfigFailure$str(), configPropertyName, location, causeMessage), configPropertyName, e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noConfigPropertyDefaultName$str() {
        return "SRCFG02002: Could not find default name for @ConfigProperty InjectionPoint %s";
    }
    @Override
    public final IllegalStateException noConfigPropertyDefaultName(final InjectionPoint injectionPoint) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noConfigPropertyDefaultName$str(), injectionPoint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unhandledConfigProperty$str() {
        return "SRCFG02003: Unhandled ConfigProperty";
    }
    @Override
    public final IllegalStateException unhandledConfigProperty() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unhandledConfigProperty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String propertyNotFound$str() {
        return "SRCFG02004: Required property %s not found";
    }
    @Override
    public final NoSuchElementException propertyNotFound(final String name) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), propertyNotFound$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noRawType$str() {
        return "SRCFG02005: Type has no raw type class: %s";
    }
    @Override
    public final IllegalArgumentException noRawType(final Type type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noRawType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalConversion$str() {
        return "SRCFG02006: The property %s cannot be converted to %s";
    }
    @Override
    public final IllegalArgumentException illegalConversion(final String name, final Type type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalConversion$str(), name, type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noRegisteredConverter$str() {
        return "SRCFG02007: No Converter registered for %s";
    }
    @Override
    public final IllegalArgumentException noRegisteredConverter(final Class<?> type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noRegisteredConverter$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
