/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config.inject;

import io.smallrye.config.SecuritySupport;
import io.smallrye.config.inject.ConfigProducerUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class ConfigProducer
implements Serializable {
    @Produces
    Config getConfig(InjectionPoint injectionPoint) {
        return ConfigProvider.getConfig((ClassLoader)SecuritySupport.getContextClassLoader());
    }

    @Dependent
    @Produces
    @ConfigProperty
    String produceStringConfigProperty(InjectionPoint ip) {
        return (String)ConfigProducerUtil.getValue(ip, this.getConfig(ip));
    }

    @Dependent
    @Produces
    @ConfigProperty
    Long getLongValue(InjectionPoint ip) {
        return (Long)ConfigProducerUtil.getValue(ip, this.getConfig(ip));
    }

    @Dependent
    @Produces
    @ConfigProperty
    Integer getIntegerValue(InjectionPoint ip) {
        return (Integer)ConfigProducerUtil.getValue(ip, this.getConfig(ip));
    }

    @Dependent
    @Produces
    @ConfigProperty
    Float produceFloatConfigProperty(InjectionPoint ip) {
        return (Float)ConfigProducerUtil.getValue(ip, this.getConfig(ip));
    }

    @Dependent
    @Produces
    @ConfigProperty
    Double produceDoubleConfigProperty(InjectionPoint ip) {
        return (Double)ConfigProducerUtil.getValue(ip, this.getConfig(ip));
    }

    @Dependent
    @Produces
    @ConfigProperty
    Boolean produceBooleanConfigProperty(InjectionPoint ip) {
        return (Boolean)ConfigProducerUtil.getValue(ip, this.getConfig(ip));
    }

    @Dependent
    @Produces
    @ConfigProperty
    <T> Optional<T> produceOptionalConfigValue(InjectionPoint ip) {
        return (Optional)ConfigProducerUtil.getValue(ip, this.getConfig(ip));
    }

    @Dependent
    @Produces
    @ConfigProperty
    <T> Set<T> producesSetConfigProperty(InjectionPoint ip) {
        return (Set)ConfigProducerUtil.getValue(ip, this.getConfig(ip));
    }

    @Dependent
    @Produces
    @ConfigProperty
    <T> List<T> producesListConfigProperty(InjectionPoint ip) {
        return (List)ConfigProducerUtil.getValue(ip, this.getConfig(ip));
    }

    @Dependent
    @Produces
    @ConfigProperty
    OptionalInt produceOptionalIntConfigProperty(InjectionPoint ip) {
        return (OptionalInt)ConfigProducerUtil.getValue(ip, this.getConfig(ip));
    }

    @Dependent
    @Produces
    @ConfigProperty
    OptionalLong produceOptionalLongConfigProperty(InjectionPoint ip) {
        return (OptionalLong)ConfigProducerUtil.getValue(ip, this.getConfig(ip));
    }

    @Dependent
    @Produces
    @ConfigProperty
    OptionalDouble produceOptionalDoubleConfigProperty(InjectionPoint ip) {
        return (OptionalDouble)ConfigProducerUtil.getValue(ip, this.getConfig(ip));
    }
}

