/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.instruction;

import io.smallrye.classfile.Label;
import io.smallrye.classfile.PseudoInstruction;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.AbstractPseudoInstruction;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ClassDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LocalVariable
extends PseudoInstruction {
    public int slot();

    public Utf8Entry name();

    public Utf8Entry type();

    default public ClassDesc typeSymbol() {
        return Util.fieldTypeSymbol(this.type());
    }

    public Label startScope();

    public Label endScope();

    public static LocalVariable of(int slot, Utf8Entry nameEntry, Utf8Entry descriptorEntry, Label startScope, Label endScope) {
        return new AbstractPseudoInstruction.UnboundLocalVariable(slot, nameEntry, descriptorEntry, startScope, endScope);
    }

    public static LocalVariable of(int slot, String name, ClassDesc descriptor, Label startScope, Label endScope) {
        return LocalVariable.of(slot, TemporaryConstantPool.INSTANCE.utf8Entry(name), TemporaryConstantPool.INSTANCE.utf8Entry(descriptor), startScope, endScope);
    }
}

