/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.instruction;

import io.smallrye.classfile.Instruction;
import io.smallrye.classfile.Opcode;
import io.smallrye.classfile.TypeKind;
import io.smallrye.classfile.constantpool.LoadableConstantEntry;
import io.smallrye.classfile.impl.AbstractInstruction;
import io.smallrye.classfile.impl.BytecodeHelpers;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ConstantDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConstantInstruction
extends Instruction {
    public ConstantDesc constantValue();

    public TypeKind typeKind();

    public static IntrinsicConstantInstruction ofIntrinsic(Opcode op) {
        Util.checkKind(op, Opcode.Kind.CONSTANT);
        if (op.sizeIfFixed() != 1) {
            throw new IllegalArgumentException(String.format("Wrong opcode specified; found %s, expected xCONST_val", new Object[]{op}));
        }
        return new AbstractInstruction.UnboundIntrinsicConstantInstruction(op);
    }

    public static ArgumentConstantInstruction ofArgument(Opcode op, int value) {
        if (op == Opcode.BIPUSH) {
            BytecodeHelpers.validateBipush(value);
        } else if (op == Opcode.SIPUSH) {
            BytecodeHelpers.validateSipush(value);
        } else {
            throw new IllegalArgumentException(String.format("Wrong opcode specified; found %s, expected BIPUSH or SIPUSH", new Object[]{op}));
        }
        return new AbstractInstruction.UnboundArgumentConstantInstruction(op, value);
    }

    public static LoadConstantInstruction ofLoad(Opcode op, LoadableConstantEntry constant) {
        Util.checkKind(op, Opcode.Kind.CONSTANT);
        if (op != Opcode.LDC && op != Opcode.LDC_W && op != Opcode.LDC2_W) {
            throw new IllegalArgumentException(String.format("Wrong opcode specified; found %s, expected LDC, LDC_W or LDC2_W", new Object[]{op}));
        }
        return new AbstractInstruction.UnboundLoadConstantInstruction(op, constant);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface LoadConstantInstruction
    extends ConstantInstruction {
        public LoadableConstantEntry constantEntry();

        @Override
        default public TypeKind typeKind() {
            return this.constantEntry().typeKind();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ArgumentConstantInstruction
    extends ConstantInstruction {
        @Override
        public Integer constantValue();

        @Override
        default public TypeKind typeKind() {
            return TypeKind.INT;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface IntrinsicConstantInstruction
    extends ConstantInstruction {
        @Override
        default public TypeKind typeKind() {
            return BytecodeHelpers.intrinsicConstantType(this.opcode());
        }
    }
}

