/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl.verifier;

import io.smallrye.classfile.impl.verifier.VerificationSignature;

final class VerificationBytecodes {
    static final int _breakpoint = 202;
    static final int _fast_agetfield = 203;
    static final int _fast_bgetfield = 204;
    static final int _fast_cgetfield = 205;
    static final int _fast_dgetfield = 206;
    static final int _fast_fgetfield = 207;
    static final int _fast_igetfield = 208;
    static final int _fast_lgetfield = 209;
    static final int _fast_sgetfield = 210;
    static final int _fast_aputfield = 211;
    static final int _fast_bputfield = 212;
    static final int _fast_zputfield = 213;
    static final int _fast_cputfield = 214;
    static final int _fast_dputfield = 215;
    static final int _fast_fputfield = 216;
    static final int _fast_iputfield = 217;
    static final int _fast_lputfield = 218;
    static final int _fast_sputfield = 219;
    static final int _fast_aload_0 = 220;
    static final int _fast_iaccess_0 = 221;
    static final int _fast_aaccess_0 = 222;
    static final int _fast_faccess_0 = 223;
    static final int _fast_iload = 224;
    static final int _fast_iload2 = 225;
    static final int _fast_icaload = 226;
    static final int _fast_invokevfinal = 227;
    static final int _fast_linearswitch = 228;
    static final int _fast_binaryswitch = 229;
    static final int _fast_aldc = 230;
    static final int _fast_aldc_w = 231;
    static final int _return_register_finalizer = 232;
    static final int _invokehandle = 233;
    static final int _nofast_getfield = 234;
    static final int _nofast_putfield = 235;
    static final int _nofast_aload_0 = 236;
    static final int _nofast_iload = 237;
    static final int _shouldnotreachhere = 238;
    static final int number_of_codes = 239;
    static final int[] _lengths = new int[239];

    VerificationBytecodes() {
    }

    static int code_or_bp_at(byte[] code, int bci) {
        return code[bci] & 0xFF;
    }

    static boolean is_valid(int code) {
        return 0 <= code && code < 239;
    }

    static boolean is_store_into_local(int code) {
        return 54 <= code && code <= 78;
    }

    static int align(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    static void def(int code, String name, String format, String wide_format, VerificationSignature.BasicType result_type, int depth) {
        VerificationBytecodes.def(code, name, format, wide_format, result_type, depth, code);
    }

    static void def(int code, String name, String format, String wide_format, VerificationSignature.BasicType result_type, int depth, int java_code) {
        if (wide_format != null && format == null) {
            throw new IllegalArgumentException("short form must exist if there's a wide form");
        }
        int len = format != null ? format.length() : 0;
        int wlen = wide_format != null ? wide_format.length() : 0;
        VerificationBytecodes._lengths[code] = wlen << 4 | len & 0xF;
    }

    static {
        VerificationBytecodes.def(0, "nop", "b", null, VerificationSignature.BasicType.T_VOID, 0);
        VerificationBytecodes.def(1, "aconst_null", "b", null, VerificationSignature.BasicType.T_OBJECT, 1);
        VerificationBytecodes.def(2, "iconst_m1", "b", null, VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(3, "iconst_0", "b", null, VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(4, "iconst_1", "b", null, VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(5, "iconst_2", "b", null, VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(6, "iconst_3", "b", null, VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(7, "iconst_4", "b", null, VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(8, "iconst_5", "b", null, VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(9, "lconst_0", "b", null, VerificationSignature.BasicType.T_LONG, 2);
        VerificationBytecodes.def(10, "lconst_1", "b", null, VerificationSignature.BasicType.T_LONG, 2);
        VerificationBytecodes.def(11, "fconst_0", "b", null, VerificationSignature.BasicType.T_FLOAT, 1);
        VerificationBytecodes.def(12, "fconst_1", "b", null, VerificationSignature.BasicType.T_FLOAT, 1);
        VerificationBytecodes.def(13, "fconst_2", "b", null, VerificationSignature.BasicType.T_FLOAT, 1);
        VerificationBytecodes.def(14, "dconst_0", "b", null, VerificationSignature.BasicType.T_DOUBLE, 2);
        VerificationBytecodes.def(15, "dconst_1", "b", null, VerificationSignature.BasicType.T_DOUBLE, 2);
        VerificationBytecodes.def(16, "bipush", "bc", null, VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(17, "sipush", "bcc", null, VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(18, "ldc", "bk", null, VerificationSignature.BasicType.T_ILLEGAL, 1);
        VerificationBytecodes.def(19, "ldc_w", "bkk", null, VerificationSignature.BasicType.T_ILLEGAL, 1);
        VerificationBytecodes.def(20, "ldc2_w", "bkk", null, VerificationSignature.BasicType.T_ILLEGAL, 2);
        VerificationBytecodes.def(21, "iload", "bi", "wbii", VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(22, "lload", "bi", "wbii", VerificationSignature.BasicType.T_LONG, 2);
        VerificationBytecodes.def(23, "fload", "bi", "wbii", VerificationSignature.BasicType.T_FLOAT, 1);
        VerificationBytecodes.def(24, "dload", "bi", "wbii", VerificationSignature.BasicType.T_DOUBLE, 2);
        VerificationBytecodes.def(25, "aload", "bi", "wbii", VerificationSignature.BasicType.T_OBJECT, 1);
        VerificationBytecodes.def(26, "iload_0", "b", null, VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(27, "iload_1", "b", null, VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(28, "iload_2", "b", null, VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(29, "iload_3", "b", null, VerificationSignature.BasicType.T_INT, 1);
        VerificationBytecodes.def(30, "lload_0", "b", null, VerificationSignature.BasicType.T_LONG, 2);
        VerificationBytecodes.def(31, "lload_1", "b", null, VerificationSignature.BasicType.T_LONG, 2);
        VerificationBytecodes.def(32, "lload_2", "b", null, VerificationSignature.BasicType.T_LONG, 2);
        VerificationBytecodes.def(33, "lload_3", "b", null, VerificationSignature.BasicType.T_LONG, 2);
        VerificationBytecodes.def(34, "fload_0", "b", null, VerificationSignature.BasicType.T_FLOAT, 1);
        VerificationBytecodes.def(35, "fload_1", "b", null, VerificationSignature.BasicType.T_FLOAT, 1);
        VerificationBytecodes.def(36, "fload_2", "b", null, VerificationSignature.BasicType.T_FLOAT, 1);
        VerificationBytecodes.def(37, "fload_3", "b", null, VerificationSignature.BasicType.T_FLOAT, 1);
        VerificationBytecodes.def(38, "dload_0", "b", null, VerificationSignature.BasicType.T_DOUBLE, 2);
        VerificationBytecodes.def(39, "dload_1", "b", null, VerificationSignature.BasicType.T_DOUBLE, 2);
        VerificationBytecodes.def(40, "dload_2", "b", null, VerificationSignature.BasicType.T_DOUBLE, 2);
        VerificationBytecodes.def(41, "dload_3", "b", null, VerificationSignature.BasicType.T_DOUBLE, 2);
        VerificationBytecodes.def(42, "aload_0", "b", null, VerificationSignature.BasicType.T_OBJECT, 1);
        VerificationBytecodes.def(43, "aload_1", "b", null, VerificationSignature.BasicType.T_OBJECT, 1);
        VerificationBytecodes.def(44, "aload_2", "b", null, VerificationSignature.BasicType.T_OBJECT, 1);
        VerificationBytecodes.def(45, "aload_3", "b", null, VerificationSignature.BasicType.T_OBJECT, 1);
        VerificationBytecodes.def(46, "iaload", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(47, "laload", "b", null, VerificationSignature.BasicType.T_LONG, 0);
        VerificationBytecodes.def(48, "faload", "b", null, VerificationSignature.BasicType.T_FLOAT, -1);
        VerificationBytecodes.def(49, "daload", "b", null, VerificationSignature.BasicType.T_DOUBLE, 0);
        VerificationBytecodes.def(50, "aaload", "b", null, VerificationSignature.BasicType.T_OBJECT, -1);
        VerificationBytecodes.def(51, "baload", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(52, "caload", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(53, "saload", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(54, "istore", "bi", "wbii", VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(55, "lstore", "bi", "wbii", VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(56, "fstore", "bi", "wbii", VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(57, "dstore", "bi", "wbii", VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(58, "astore", "bi", "wbii", VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(59, "istore_0", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(60, "istore_1", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(61, "istore_2", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(62, "istore_3", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(63, "lstore_0", "b", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(64, "lstore_1", "b", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(65, "lstore_2", "b", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(66, "lstore_3", "b", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(67, "fstore_0", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(68, "fstore_1", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(69, "fstore_2", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(70, "fstore_3", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(71, "dstore_0", "b", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(72, "dstore_1", "b", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(73, "dstore_2", "b", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(74, "dstore_3", "b", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(75, "astore_0", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(76, "astore_1", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(77, "astore_2", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(78, "astore_3", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(79, "iastore", "b", null, VerificationSignature.BasicType.T_VOID, -3);
        VerificationBytecodes.def(80, "lastore", "b", null, VerificationSignature.BasicType.T_VOID, -4);
        VerificationBytecodes.def(81, "fastore", "b", null, VerificationSignature.BasicType.T_VOID, -3);
        VerificationBytecodes.def(82, "dastore", "b", null, VerificationSignature.BasicType.T_VOID, -4);
        VerificationBytecodes.def(83, "aastore", "b", null, VerificationSignature.BasicType.T_VOID, -3);
        VerificationBytecodes.def(84, "bastore", "b", null, VerificationSignature.BasicType.T_VOID, -3);
        VerificationBytecodes.def(85, "castore", "b", null, VerificationSignature.BasicType.T_VOID, -3);
        VerificationBytecodes.def(86, "sastore", "b", null, VerificationSignature.BasicType.T_VOID, -3);
        VerificationBytecodes.def(87, "pop", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(88, "pop2", "b", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(89, "dup", "b", null, VerificationSignature.BasicType.T_VOID, 1);
        VerificationBytecodes.def(90, "dup_x1", "b", null, VerificationSignature.BasicType.T_VOID, 1);
        VerificationBytecodes.def(91, "dup_x2", "b", null, VerificationSignature.BasicType.T_VOID, 1);
        VerificationBytecodes.def(92, "dup2", "b", null, VerificationSignature.BasicType.T_VOID, 2);
        VerificationBytecodes.def(93, "dup2_x1", "b", null, VerificationSignature.BasicType.T_VOID, 2);
        VerificationBytecodes.def(94, "dup2_x2", "b", null, VerificationSignature.BasicType.T_VOID, 2);
        VerificationBytecodes.def(95, "swap", "b", null, VerificationSignature.BasicType.T_VOID, 0);
        VerificationBytecodes.def(96, "iadd", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(97, "ladd", "b", null, VerificationSignature.BasicType.T_LONG, -2);
        VerificationBytecodes.def(98, "fadd", "b", null, VerificationSignature.BasicType.T_FLOAT, -1);
        VerificationBytecodes.def(99, "dadd", "b", null, VerificationSignature.BasicType.T_DOUBLE, -2);
        VerificationBytecodes.def(100, "isub", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(101, "lsub", "b", null, VerificationSignature.BasicType.T_LONG, -2);
        VerificationBytecodes.def(102, "fsub", "b", null, VerificationSignature.BasicType.T_FLOAT, -1);
        VerificationBytecodes.def(103, "dsub", "b", null, VerificationSignature.BasicType.T_DOUBLE, -2);
        VerificationBytecodes.def(104, "imul", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(105, "lmul", "b", null, VerificationSignature.BasicType.T_LONG, -2);
        VerificationBytecodes.def(106, "fmul", "b", null, VerificationSignature.BasicType.T_FLOAT, -1);
        VerificationBytecodes.def(107, "dmul", "b", null, VerificationSignature.BasicType.T_DOUBLE, -2);
        VerificationBytecodes.def(108, "idiv", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(109, "ldiv", "b", null, VerificationSignature.BasicType.T_LONG, -2);
        VerificationBytecodes.def(110, "fdiv", "b", null, VerificationSignature.BasicType.T_FLOAT, -1);
        VerificationBytecodes.def(111, "ddiv", "b", null, VerificationSignature.BasicType.T_DOUBLE, -2);
        VerificationBytecodes.def(112, "irem", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(113, "lrem", "b", null, VerificationSignature.BasicType.T_LONG, -2);
        VerificationBytecodes.def(114, "frem", "b", null, VerificationSignature.BasicType.T_FLOAT, -1);
        VerificationBytecodes.def(115, "drem", "b", null, VerificationSignature.BasicType.T_DOUBLE, -2);
        VerificationBytecodes.def(116, "ineg", "b", null, VerificationSignature.BasicType.T_INT, 0);
        VerificationBytecodes.def(117, "lneg", "b", null, VerificationSignature.BasicType.T_LONG, 0);
        VerificationBytecodes.def(118, "fneg", "b", null, VerificationSignature.BasicType.T_FLOAT, 0);
        VerificationBytecodes.def(119, "dneg", "b", null, VerificationSignature.BasicType.T_DOUBLE, 0);
        VerificationBytecodes.def(120, "ishl", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(121, "lshl", "b", null, VerificationSignature.BasicType.T_LONG, -1);
        VerificationBytecodes.def(122, "ishr", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(123, "lshr", "b", null, VerificationSignature.BasicType.T_LONG, -1);
        VerificationBytecodes.def(124, "iushr", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(125, "lushr", "b", null, VerificationSignature.BasicType.T_LONG, -1);
        VerificationBytecodes.def(126, "iand", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(127, "land", "b", null, VerificationSignature.BasicType.T_LONG, -2);
        VerificationBytecodes.def(128, "ior", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(129, "lor", "b", null, VerificationSignature.BasicType.T_LONG, -2);
        VerificationBytecodes.def(130, "ixor", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(131, "lxor", "b", null, VerificationSignature.BasicType.T_LONG, -2);
        VerificationBytecodes.def(132, "iinc", "bic", "wbiicc", VerificationSignature.BasicType.T_VOID, 0);
        VerificationBytecodes.def(133, "i2l", "b", null, VerificationSignature.BasicType.T_LONG, 1);
        VerificationBytecodes.def(134, "i2f", "b", null, VerificationSignature.BasicType.T_FLOAT, 0);
        VerificationBytecodes.def(135, "i2d", "b", null, VerificationSignature.BasicType.T_DOUBLE, 1);
        VerificationBytecodes.def(136, "l2i", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(137, "l2f", "b", null, VerificationSignature.BasicType.T_FLOAT, -1);
        VerificationBytecodes.def(138, "l2d", "b", null, VerificationSignature.BasicType.T_DOUBLE, 0);
        VerificationBytecodes.def(139, "f2i", "b", null, VerificationSignature.BasicType.T_INT, 0);
        VerificationBytecodes.def(140, "f2l", "b", null, VerificationSignature.BasicType.T_LONG, 1);
        VerificationBytecodes.def(141, "f2d", "b", null, VerificationSignature.BasicType.T_DOUBLE, 1);
        VerificationBytecodes.def(142, "d2i", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(143, "d2l", "b", null, VerificationSignature.BasicType.T_LONG, 0);
        VerificationBytecodes.def(144, "d2f", "b", null, VerificationSignature.BasicType.T_FLOAT, -1);
        VerificationBytecodes.def(145, "i2b", "b", null, VerificationSignature.BasicType.T_BYTE, 0);
        VerificationBytecodes.def(146, "i2c", "b", null, VerificationSignature.BasicType.T_CHAR, 0);
        VerificationBytecodes.def(147, "i2s", "b", null, VerificationSignature.BasicType.T_SHORT, 0);
        VerificationBytecodes.def(148, "lcmp", "b", null, VerificationSignature.BasicType.T_VOID, -3);
        VerificationBytecodes.def(149, "fcmpl", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(150, "fcmpg", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(151, "dcmpl", "b", null, VerificationSignature.BasicType.T_VOID, -3);
        VerificationBytecodes.def(152, "dcmpg", "b", null, VerificationSignature.BasicType.T_VOID, -3);
        VerificationBytecodes.def(153, "ifeq", "boo", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(154, "ifne", "boo", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(155, "iflt", "boo", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(156, "ifge", "boo", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(157, "ifgt", "boo", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(158, "ifle", "boo", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(159, "if_icmpeq", "boo", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(160, "if_icmpne", "boo", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(161, "if_icmplt", "boo", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(162, "if_icmpge", "boo", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(163, "if_icmpgt", "boo", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(164, "if_icmple", "boo", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(165, "if_acmpeq", "boo", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(166, "if_acmpne", "boo", null, VerificationSignature.BasicType.T_VOID, -2);
        VerificationBytecodes.def(167, "goto", "boo", null, VerificationSignature.BasicType.T_VOID, 0);
        VerificationBytecodes.def(168, "jsr", "boo", null, VerificationSignature.BasicType.T_INT, 0);
        VerificationBytecodes.def(169, "ret", "bi", "wbii", VerificationSignature.BasicType.T_VOID, 0);
        VerificationBytecodes.def(170, "tableswitch", "", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(171, "lookupswitch", "", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(172, "ireturn", "b", null, VerificationSignature.BasicType.T_INT, -1);
        VerificationBytecodes.def(173, "lreturn", "b", null, VerificationSignature.BasicType.T_LONG, -2);
        VerificationBytecodes.def(174, "freturn", "b", null, VerificationSignature.BasicType.T_FLOAT, -1);
        VerificationBytecodes.def(175, "dreturn", "b", null, VerificationSignature.BasicType.T_DOUBLE, -2);
        VerificationBytecodes.def(176, "areturn", "b", null, VerificationSignature.BasicType.T_OBJECT, -1);
        VerificationBytecodes.def(177, "return", "b", null, VerificationSignature.BasicType.T_VOID, 0);
        VerificationBytecodes.def(178, "getstatic", "bJJ", null, VerificationSignature.BasicType.T_ILLEGAL, 1);
        VerificationBytecodes.def(179, "putstatic", "bJJ", null, VerificationSignature.BasicType.T_ILLEGAL, -1);
        VerificationBytecodes.def(180, "getfield", "bJJ", null, VerificationSignature.BasicType.T_ILLEGAL, 0);
        VerificationBytecodes.def(181, "putfield", "bJJ", null, VerificationSignature.BasicType.T_ILLEGAL, -2);
        VerificationBytecodes.def(182, "invokevirtual", "bJJ", null, VerificationSignature.BasicType.T_ILLEGAL, -1);
        VerificationBytecodes.def(183, "invokespecial", "bJJ", null, VerificationSignature.BasicType.T_ILLEGAL, -1);
        VerificationBytecodes.def(184, "invokestatic", "bJJ", null, VerificationSignature.BasicType.T_ILLEGAL, 0);
        VerificationBytecodes.def(185, "invokeinterface", "bJJ__", null, VerificationSignature.BasicType.T_ILLEGAL, -1);
        VerificationBytecodes.def(186, "invokedynamic", "bJJJJ", null, VerificationSignature.BasicType.T_ILLEGAL, 0);
        VerificationBytecodes.def(187, "new", "bkk", null, VerificationSignature.BasicType.T_OBJECT, 1);
        VerificationBytecodes.def(188, "newarray", "bc", null, VerificationSignature.BasicType.T_OBJECT, 0);
        VerificationBytecodes.def(189, "anewarray", "bkk", null, VerificationSignature.BasicType.T_OBJECT, 0);
        VerificationBytecodes.def(190, "arraylength", "b", null, VerificationSignature.BasicType.T_VOID, 0);
        VerificationBytecodes.def(191, "athrow", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(192, "checkcast", "bkk", null, VerificationSignature.BasicType.T_OBJECT, 0);
        VerificationBytecodes.def(193, "instanceof", "bkk", null, VerificationSignature.BasicType.T_INT, 0);
        VerificationBytecodes.def(194, "monitorenter", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(195, "monitorexit", "b", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(196, "wide", "", null, VerificationSignature.BasicType.T_VOID, 0);
        VerificationBytecodes.def(197, "multianewarray", "bkkc", null, VerificationSignature.BasicType.T_OBJECT, 1);
        VerificationBytecodes.def(198, "ifnull", "boo", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(199, "ifnonnull", "boo", null, VerificationSignature.BasicType.T_VOID, -1);
        VerificationBytecodes.def(200, "goto_w", "boooo", null, VerificationSignature.BasicType.T_VOID, 0);
        VerificationBytecodes.def(201, "jsr_w", "boooo", null, VerificationSignature.BasicType.T_INT, 0);
        VerificationBytecodes.def(202, "breakpoint", "", null, VerificationSignature.BasicType.T_VOID, 0);
        VerificationBytecodes.def(203, "fast_agetfield", "bJJ", null, VerificationSignature.BasicType.T_OBJECT, 0, 180);
        VerificationBytecodes.def(204, "fast_bgetfield", "bJJ", null, VerificationSignature.BasicType.T_INT, 0, 180);
        VerificationBytecodes.def(205, "fast_cgetfield", "bJJ", null, VerificationSignature.BasicType.T_CHAR, 0, 180);
        VerificationBytecodes.def(206, "fast_dgetfield", "bJJ", null, VerificationSignature.BasicType.T_DOUBLE, 0, 180);
        VerificationBytecodes.def(207, "fast_fgetfield", "bJJ", null, VerificationSignature.BasicType.T_FLOAT, 0, 180);
        VerificationBytecodes.def(208, "fast_igetfield", "bJJ", null, VerificationSignature.BasicType.T_INT, 0, 180);
        VerificationBytecodes.def(209, "fast_lgetfield", "bJJ", null, VerificationSignature.BasicType.T_LONG, 0, 180);
        VerificationBytecodes.def(210, "fast_sgetfield", "bJJ", null, VerificationSignature.BasicType.T_SHORT, 0, 180);
        VerificationBytecodes.def(211, "fast_aputfield", "bJJ", null, VerificationSignature.BasicType.T_OBJECT, 0, 181);
        VerificationBytecodes.def(212, "fast_bputfield", "bJJ", null, VerificationSignature.BasicType.T_INT, 0, 181);
        VerificationBytecodes.def(213, "fast_zputfield", "bJJ", null, VerificationSignature.BasicType.T_INT, 0, 181);
        VerificationBytecodes.def(214, "fast_cputfield", "bJJ", null, VerificationSignature.BasicType.T_CHAR, 0, 181);
        VerificationBytecodes.def(215, "fast_dputfield", "bJJ", null, VerificationSignature.BasicType.T_DOUBLE, 0, 181);
        VerificationBytecodes.def(216, "fast_fputfield", "bJJ", null, VerificationSignature.BasicType.T_FLOAT, 0, 181);
        VerificationBytecodes.def(217, "fast_iputfield", "bJJ", null, VerificationSignature.BasicType.T_INT, 0, 181);
        VerificationBytecodes.def(218, "fast_lputfield", "bJJ", null, VerificationSignature.BasicType.T_LONG, 0, 181);
        VerificationBytecodes.def(219, "fast_sputfield", "bJJ", null, VerificationSignature.BasicType.T_SHORT, 0, 181);
        VerificationBytecodes.def(220, "fast_aload_0", "b", null, VerificationSignature.BasicType.T_OBJECT, 1, 42);
        VerificationBytecodes.def(221, "fast_iaccess_0", "b_JJ", null, VerificationSignature.BasicType.T_INT, 1, 42);
        VerificationBytecodes.def(222, "fast_aaccess_0", "b_JJ", null, VerificationSignature.BasicType.T_OBJECT, 1, 42);
        VerificationBytecodes.def(223, "fast_faccess_0", "b_JJ", null, VerificationSignature.BasicType.T_OBJECT, 1, 42);
        VerificationBytecodes.def(224, "fast_iload", "bi", null, VerificationSignature.BasicType.T_INT, 1, 21);
        VerificationBytecodes.def(225, "fast_iload2", "bi_i", null, VerificationSignature.BasicType.T_INT, 2, 21);
        VerificationBytecodes.def(226, "fast_icaload", "bi_", null, VerificationSignature.BasicType.T_INT, 0, 21);
        VerificationBytecodes.def(227, "fast_invokevfinal", "bJJ", null, VerificationSignature.BasicType.T_ILLEGAL, -1, 182);
        VerificationBytecodes.def(228, "fast_linearswitch", "", null, VerificationSignature.BasicType.T_VOID, -1, 171);
        VerificationBytecodes.def(229, "fast_binaryswitch", "", null, VerificationSignature.BasicType.T_VOID, -1, 171);
        VerificationBytecodes.def(232, "return_register_finalizer", "b", null, VerificationSignature.BasicType.T_VOID, 0, 177);
        VerificationBytecodes.def(233, "invokehandle", "bJJ", null, VerificationSignature.BasicType.T_ILLEGAL, -1, 182);
        VerificationBytecodes.def(230, "fast_aldc", "bj", null, VerificationSignature.BasicType.T_OBJECT, 1, 18);
        VerificationBytecodes.def(231, "fast_aldc_w", "bJJ", null, VerificationSignature.BasicType.T_OBJECT, 1, 19);
        VerificationBytecodes.def(234, "nofast_getfield", "bJJ", null, VerificationSignature.BasicType.T_ILLEGAL, 0, 180);
        VerificationBytecodes.def(235, "nofast PUTFIELD", "bJJ", null, VerificationSignature.BasicType.T_ILLEGAL, -2, 181);
        VerificationBytecodes.def(236, "nofast_aload_0", "b", null, VerificationSignature.BasicType.T_ILLEGAL, 1, 42);
        VerificationBytecodes.def(237, "nofast_iload", "bi", null, VerificationSignature.BasicType.T_ILLEGAL, 1, 21);
        VerificationBytecodes.def(238, "_shouldnotreachhere", "b", null, VerificationSignature.BasicType.T_VOID, 0);
    }
}

