/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Annotation;
import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.AttributeMapper;
import io.smallrye.classfile.Attributes;
import io.smallrye.classfile.BufWriter;
import io.smallrye.classfile.ClassFile;
import io.smallrye.classfile.ClassModel;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.CustomAttribute;
import io.smallrye.classfile.FieldBuilder;
import io.smallrye.classfile.MethodBuilder;
import io.smallrye.classfile.Opcode;
import io.smallrye.classfile.PseudoInstruction;
import io.smallrye.classfile.attribute.CodeAttribute;
import io.smallrye.classfile.components.ClassPrinter;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.ModuleEntry;
import io.smallrye.classfile.constantpool.PoolEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.extras.constant.ExtraClassDesc;
import io.smallrye.classfile.extras.constant.ModuleDesc;
import io.smallrye.classfile.extras.reflect.AccessFlag;
import io.smallrye.classfile.impl.AbstractPoolEntry;
import io.smallrye.classfile.impl.BoundAttribute;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.ClassFileImpl;
import io.smallrye.classfile.impl.DirectMethodBuilder;
import io.smallrye.classfile.impl.RawBytecodeHelper;
import io.smallrye.classfile.impl.SplitConstantPool;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.UnboundAttribute;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public final class Util {
    private static final int ATTRIBUTE_STABILITY_COUNT = AttributeMapper.AttributeStability.values().length;
    static final int INVERSE_31 = -1108378657;
    static final int SIGNIFICANT_OCTAL_DIGITS = 6;
    static final int[] powers = new int[]{31, 961, 29791, 923521, 28629151, 887503681, 1742810335, -1807454463, 1353309697, -2077209343, 2111290369, -1935660287, -7759359, 630458625, 1304393729, -474025983, -1040291839, -394403839, 1463638017, 238866433, 226248705, 1425784833, -1174962175, 787693569, -1276182527, 1223344129, -303661055, -1562230783, 1742602241, -809762815, 932839425, -1619525631, 123076609, 1865678849, -686686207, 1055916033, 2111832065, -1127219199, -71303167, 984612865, 2040528897, -1198522367, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    private Util() {
    }

    public static <T> Consumer<Consumer<T>> writingAll(Iterable<T> container) {
        record ForEachConsumer<T>(Iterable<T> container) implements Consumer<Consumer<T>>
        {
            @Override
            public void accept(Consumer<T> consumer) {
                this.container.forEach(consumer);
            }
        }
        return new ForEachConsumer<T>(container);
    }

    public static Consumer<MethodBuilder> buildingCode(Consumer<? super CodeBuilder> codeHandler) {
        record WithCodeMethodHandler(Consumer<? super CodeBuilder> codeHandler) implements Consumer<MethodBuilder>
        {
            @Override
            public void accept(MethodBuilder builder) {
                builder.withCode(this.codeHandler);
            }
        }
        return new WithCodeMethodHandler(codeHandler);
    }

    public static Consumer<FieldBuilder> buildingFlags(int flags) {
        record WithFlagFieldHandler(int flags) implements Consumer<FieldBuilder>
        {
            @Override
            public void accept(FieldBuilder builder) {
                builder.withFlags(this.flags);
            }
        }
        return new WithFlagFieldHandler(flags);
    }

    public static boolean isAttributeAllowed(Attribute<?> attr, ClassFileImpl context) {
        return attr instanceof BoundAttribute ? ATTRIBUTE_STABILITY_COUNT - attr.attributeMapper().stability().ordinal() > context.attributesProcessingOption().ordinal() : true;
    }

    public static int parameterSlots(MethodTypeDesc mDesc) {
        int count = mDesc.parameterCount();
        for (int i = count - 1; i >= 0; --i) {
            if (!Util.isDoubleSlot(mDesc.parameterType(i))) continue;
            ++count;
        }
        return count;
    }

    public static int[] parseParameterSlots(int flags, MethodTypeDesc mDesc) {
        int[] result = new int[mDesc.parameterCount()];
        int count = (flags & 8) != 0 ? 0 : 1;
        for (int i = 0; i < result.length; ++i) {
            result[i] = count;
            count += Util.paramSlotSize(mDesc.parameterType(i));
        }
        return result;
    }

    public static int maxLocals(int flags, MethodTypeDesc mDesc) {
        return Util.parameterSlots(mDesc) + ((flags & 8) == 0 ? 1 : 0);
    }

    public static String toBinaryName(ClassDesc cd) {
        return Util.toInternalName(cd).replace('/', '.');
    }

    public static String toInternalName(ClassDesc cd) {
        if (cd.isClassOrInterface()) {
            String desc = cd.descriptorString();
            return desc.substring(1, desc.length() - 1);
        }
        throw new IllegalArgumentException(cd.descriptorString());
    }

    public static ClassDesc toClassDesc(String classInternalNameOrArrayDesc) {
        return classInternalNameOrArrayDesc.charAt(0) == '[' ? ClassDesc.ofDescriptor(classInternalNameOrArrayDesc) : ExtraClassDesc.ofInternalName(classInternalNameOrArrayDesc);
    }

    public static <T> List<T> sanitizeU1List(List<T> input) {
        List<T> copy = List.copyOf(input);
        Util.checkU1(copy.size(), "list size");
        return copy;
    }

    public static <T> List<T> sanitizeU2List(Collection<T> input) {
        List<T> copy = List.copyOf(input);
        Util.checkU2(copy.size(), "list size");
        return copy;
    }

    public static List<List<Annotation>> sanitizeParameterAnnotations(List<List<Annotation>> input) {
        List<List<Annotation>> output = input.stream().map(Util::sanitizeU2List).toList();
        Util.checkU1(output.size(), "parameter count");
        return output;
    }

    public static <T, U> List<U> mappedList(final List<? extends T> list, final Function<T, U> mapper) {
        return new AbstractList<U>(){

            @Override
            public U get(int index) {
                return mapper.apply(list.get(index));
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static List<ClassEntry> entryList(List<? extends ClassDesc> list) {
        return list.stream().map(TemporaryConstantPool.INSTANCE::classEntry).toList();
    }

    public static List<ModuleEntry> moduleEntryList(List<? extends ModuleDesc> list) {
        return list.stream().map(ModuleDesc::name).map(TemporaryConstantPool.INSTANCE::utf8Entry).map(TemporaryConstantPool.INSTANCE::moduleEntry).toList();
    }

    public static void checkKind(Opcode op, Opcode.Kind k) {
        if (op.kind() != k) {
            throw Util.badOpcodeKindException(op, k);
        }
    }

    public static IllegalArgumentException badOpcodeKindException(Opcode op, Opcode.Kind k) {
        return new IllegalArgumentException(String.format("Wrong opcode kind specified; found %s(%s), expected %s", new Object[]{op, op.kind(), k}));
    }

    public static int checkU1(int incoming, String valueName) {
        if ((incoming & 0xFFFFFF00) != 0) {
            throw Util.outOfRangeException(incoming, valueName, "u1");
        }
        return incoming;
    }

    public static char checkU2(int incoming, String valueName) {
        if ((incoming & 0xFFFF0000) != 0) {
            throw Util.outOfRangeException(incoming, valueName, "u2");
        }
        return (char)incoming;
    }

    public static IllegalArgumentException outOfRangeException(int value, String fieldName, String typeName) {
        return new IllegalArgumentException(String.format("%s out of range of %s: %d", fieldName, typeName, value));
    }

    public static char checkFlags(int mask) {
        return Util.checkU2(mask, "access flags");
    }

    public static int flagsToBits(AccessFlag.Location location, Collection<AccessFlag> flags) {
        int i = 0;
        for (AccessFlag f : flags) {
            if (!f.locations().contains((Object)location)) {
                throw new IllegalArgumentException("unexpected flag: " + String.valueOf((Object)f) + " use in target location: " + String.valueOf((Object)location));
            }
            i |= f.mask();
        }
        return i;
    }

    public static int flagsToBits(AccessFlag.Location location, AccessFlag ... flags) {
        int i = 0;
        for (AccessFlag f : flags) {
            if (!f.locations().contains((Object)location)) {
                throw new IllegalArgumentException("unexpected flag: " + String.valueOf((Object)f) + " use in target location: " + String.valueOf((Object)location));
            }
            i |= f.mask();
        }
        return i;
    }

    public static boolean has(AccessFlag.Location location, int flagsMask, AccessFlag flag) {
        return (flag.mask() & flagsMask) == flag.mask() && flag.locations().contains((Object)location);
    }

    public static ClassDesc fieldTypeSymbol(Utf8Entry utf8) {
        return ((AbstractPoolEntry.Utf8EntryImpl)utf8).fieldTypeSymbol();
    }

    public static MethodTypeDesc methodTypeSymbol(Utf8Entry utf8) {
        return ((AbstractPoolEntry.Utf8EntryImpl)utf8).methodTypeSymbol();
    }

    public static <T extends Attribute<T>> void writeAttribute(BufWriterImpl writer, Attribute<?> attr) {
        if (attr instanceof CustomAttribute) {
            CustomAttribute ca = (CustomAttribute)attr;
            AttributeMapper mapper = ca.attributeMapper();
            mapper.writeAttribute(writer, ca);
        } else {
            assert (attr instanceof BoundAttribute || attr instanceof UnboundAttribute);
            ((Writable)((Object)attr)).writeTo(writer);
        }
    }

    public static void writeAttributes(BufWriterImpl buf, List<? extends Attribute<?>> list) {
        int size = list.size();
        Util.checkU2(size, "attributes count");
        buf.writeU2(size);
        for (int i = 0; i < size; ++i) {
            Util.writeAttribute(buf, list.get(i));
        }
    }

    static void writeList(BufWriterImpl buf, Writable[] array, int size) {
        Util.checkU2(size, "member count");
        buf.writeU2(size);
        for (int i = 0; i < size; ++i) {
            array[i].writeTo(buf);
        }
    }

    public static int slotSize(ClassDesc desc) {
        return desc.equals(ConstantDescs.CD_void) ? 0 : (Util.isDoubleSlot(desc) ? 2 : 1);
    }

    public static int paramSlotSize(ClassDesc desc) {
        return Util.isDoubleSlot(desc) ? 2 : 1;
    }

    public static boolean isDoubleSlot(ClassDesc desc) {
        return desc.equals(ConstantDescs.CD_double) || desc.equals(ConstantDescs.CD_long);
    }

    public static void dumpMethod(final SplitConstantPool cp, ClassDesc cls, String methodName, MethodTypeDesc methodDesc, int acc, final RawBytecodeHelper.CodeRange bytecode, Consumer<String> dump) {
        try {
            ClassFile cc = ClassFile.of();
            ClassModel clm = cc.parse(cc.build(cp.classEntry(cls), cp, clb -> clb.withMethod(methodName, methodDesc, acc, mb -> ((DirectMethodBuilder)mb).writeAttribute(new UnboundAttribute.AdHocAttribute<CodeAttribute>(Attributes.code()){

                @Override
                public void writeBody(BufWriterImpl b) {
                    b.writeU2U2(-1, -1);
                    b.writeInt(bytecode.length());
                    b.writeBytes(bytecode.array(), 0, bytecode.length());
                    b.writeU2U2(0, 0);
                }

                @Override
                public Utf8Entry attributeName() {
                    return cp.utf8Entry("Code");
                }
            }))));
            ClassPrinter.toYaml(clm.methods().get(0).code().get(), ClassPrinter.Verbosity.TRACE_ALL, dump);
        }
        catch (Error | Exception __) {
            Util.dumpBytesHex(dump, bytecode.array(), bytecode.length());
        }
    }

    public static void dumpBytesHex(Consumer<String> dump, byte[] bytes, int length) {
        for (int i = 0; i < length; ++i) {
            if (i % 16 == 0) {
                dump.accept("%n%04x:".formatted(i));
            }
            dump.accept(" %02x".formatted(bytes[i]));
        }
    }

    public static void writeListIndices(BufWriter writer, List<? extends PoolEntry> list) {
        writer.writeU2(list.size());
        for (PoolEntry poolEntry : list) {
            writer.writeIndex(poolEntry);
        }
    }

    public static boolean writeLocalVariable(BufWriterImpl buf, PseudoInstruction lvOrLvt) {
        return ((WritableLocalVariable)((Object)lvOrLvt)).writeLocalTo(buf);
    }

    public static int descriptorStringHash(int length, int hash) {
        if (length > 65535) {
            throw new IllegalArgumentException("String too long: ".concat(Integer.toString(length)));
        }
        return 76 * Util.pow31(length + 1) + hash * 31 + 59;
    }

    public static int pow31(int k) {
        int r = 1;
        for (int i = 0; i < 6; ++i) {
            r *= Util.powerOctal(k & 7, i);
            k >>= 3;
        }
        return r;
    }

    static int powersIndex(int digit, int index) {
        return digit - 1 + index * 7;
    }

    private static int powerOctal(int digit, int index) {
        return digit == 0 ? 1 : powers[Util.powersIndex(digit, index) & 0x3F];
    }

    static interface Writable {
        public void writeTo(BufWriterImpl var1);
    }

    static interface WritableLocalVariable {
        public boolean writeLocalTo(BufWriterImpl var1);
    }
}

