/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Attributes;
import io.smallrye.classfile.TypeKind;
import io.smallrye.classfile.attribute.StackMapFrameInfo;
import io.smallrye.classfile.attribute.StackMapTableAttribute;
import io.smallrye.classfile.constantpool.ConstantDynamicEntry;
import io.smallrye.classfile.constantpool.DynamicConstantPoolEntry;
import io.smallrye.classfile.constantpool.MemberRefEntry;
import io.smallrye.classfile.constantpool.NameAndTypeEntry;
import io.smallrye.classfile.constantpool.PoolEntry;
import io.smallrye.classfile.impl.AbstractPseudoInstruction;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.DirectCodeBuilder;
import io.smallrye.classfile.impl.LabelContext;
import io.smallrye.classfile.impl.RawBytecodeHelper;
import io.smallrye.classfile.impl.SplitConstantPool;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;

public final class StackCounter {
    private int stack;
    private int maxStack;
    private int maxLocals;
    private int rets;
    private final RawBytecodeHelper bcs;
    private final ClassDesc thisClass;
    private final String methodName;
    private final MethodTypeDesc methodDesc;
    private final boolean isStatic;
    private final SplitConstantPool cp;
    private final Queue<Target> targets;
    private final BitSet visited;

    static StackCounter of(DirectCodeBuilder dcb, BufWriterImpl buf) {
        return new StackCounter(dcb, dcb.attributes.get(Attributes.stackMapTable()), buf.thisClass().asSymbol(), dcb.methodInfo.methodName().stringValue(), dcb.methodInfo.methodTypeSymbol(), (dcb.methodInfo.methodFlags() & 8) != 0, dcb.bytecodesBufWriter.bytecodeView(), dcb.constantPool, dcb.handlers);
    }

    private void jump(int targetBci) {
        if (!this.visited.get(targetBci)) {
            this.targets.add(new Target(targetBci, this.stack));
        }
    }

    private void addStackSlot(int delta) {
        this.stack += delta;
        if (this.stack > this.maxStack) {
            this.maxStack = this.stack;
        }
    }

    private void ensureLocalSlot(int index) {
        if (index >= this.maxLocals) {
            this.maxLocals = index + 1;
        }
    }

    private boolean next() {
        Target en;
        while ((en = this.targets.poll()) != null) {
            if (this.visited.get(en.bci)) continue;
            this.bcs.reset(en.bci);
            this.stack = en.stack;
            return true;
        }
        this.bcs.reset(this.bcs.endBci());
        return false;
    }

    public StackCounter(LabelContext labelContext, StackMapTableAttribute smta, ClassDesc thisClass, String methodName, MethodTypeDesc methodDesc, boolean isStatic, RawBytecodeHelper.CodeRange bytecode, SplitConstantPool cp, List<AbstractPseudoInstruction.ExceptionCatchImpl> handlers) {
        this.thisClass = thisClass;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.isStatic = isStatic;
        this.cp = cp;
        this.targets = new ArrayDeque<Target>();
        this.rets = 0;
        this.stack = 0;
        this.maxStack = handlers.isEmpty() ? 0 : 1;
        for (AbstractPseudoInstruction.ExceptionCatchImpl h : handlers) {
            this.targets.add(new Target(labelContext.labelToBci(h.handler), 1));
        }
        if (smta != null) {
            for (StackMapFrameInfo smfi : smta.entries()) {
                int frameStack = smfi.stack().size();
                for (StackMapFrameInfo.VerificationTypeInfo vti : smfi.stack()) {
                    if (vti != StackMapFrameInfo.SimpleVerificationTypeInfo.LONG && vti != StackMapFrameInfo.SimpleVerificationTypeInfo.DOUBLE) continue;
                    ++frameStack;
                }
                if (this.maxStack < frameStack) {
                    this.maxStack = frameStack;
                }
                this.targets.add(new Target(labelContext.labelToBci(smfi.target()), frameStack));
            }
        }
        this.maxLocals = isStatic ? 0 : 1;
        this.maxLocals += Util.parameterSlots(methodDesc);
        this.bcs = bytecode.start();
        this.visited = new BitSet(this.bcs.endBci());
        this.targets.add(new Target(0, 0));
        while (this.next()) {
            while (this.bcs.next()) {
                int opcode = this.bcs.opcode();
                int bci = this.bcs.bci();
                this.visited.set(bci);
                block0 : switch (opcode) {
                    case 0: 
                    case 47: 
                    case 49: 
                    case 95: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 134: 
                    case 138: 
                    case 139: 
                    case 143: 
                    case 145: 
                    case 146: 
                    case 147: 
                    case 188: 
                    case 189: 
                    case 190: 
                    case 192: 
                    case 193: {
                        break;
                    }
                    case 177: {
                        this.next();
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 16: 
                    case 17: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 133: 
                    case 135: 
                    case 140: 
                    case 141: 
                    case 187: {
                        this.addStackSlot(1);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 14: 
                    case 15: 
                    case 92: 
                    case 93: 
                    case 94: {
                        this.addStackSlot(2);
                        break;
                    }
                    case 87: 
                    case 96: 
                    case 98: 
                    case 100: 
                    case 102: 
                    case 104: 
                    case 106: 
                    case 108: 
                    case 110: 
                    case 112: 
                    case 114: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 128: 
                    case 130: 
                    case 136: 
                    case 137: 
                    case 142: 
                    case 144: 
                    case 149: 
                    case 150: 
                    case 194: 
                    case 195: {
                        this.addStackSlot(-1);
                        break;
                    }
                    case 88: 
                    case 97: 
                    case 99: 
                    case 101: 
                    case 103: 
                    case 105: 
                    case 107: 
                    case 109: 
                    case 111: 
                    case 113: 
                    case 115: 
                    case 127: 
                    case 129: 
                    case 131: {
                        this.addStackSlot(-2);
                        break;
                    }
                    case 79: 
                    case 81: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 148: 
                    case 151: 
                    case 152: {
                        this.addStackSlot(-3);
                        break;
                    }
                    case 80: 
                    case 82: {
                        this.addStackSlot(-4);
                        break;
                    }
                    case 18: {
                        this.processLdc(this.bcs.getIndexU1());
                        break;
                    }
                    case 19: 
                    case 20: {
                        this.processLdc(this.bcs.getIndexU2());
                        break;
                    }
                    case 21: 
                    case 23: 
                    case 25: {
                        this.ensureLocalSlot(this.bcs.getIndex());
                        this.addStackSlot(1);
                        break;
                    }
                    case 22: 
                    case 24: {
                        this.ensureLocalSlot(this.bcs.getIndex() + 1);
                        this.addStackSlot(2);
                        break;
                    }
                    case 26: 
                    case 34: 
                    case 42: {
                        this.ensureLocalSlot(0);
                        this.addStackSlot(1);
                        break;
                    }
                    case 27: 
                    case 35: 
                    case 43: {
                        this.ensureLocalSlot(1);
                        this.addStackSlot(1);
                        break;
                    }
                    case 28: 
                    case 36: 
                    case 44: {
                        this.ensureLocalSlot(2);
                        this.addStackSlot(1);
                        break;
                    }
                    case 29: 
                    case 37: 
                    case 45: {
                        this.ensureLocalSlot(3);
                        this.addStackSlot(1);
                        break;
                    }
                    case 30: 
                    case 38: {
                        this.ensureLocalSlot(1);
                        this.addStackSlot(2);
                        break;
                    }
                    case 31: 
                    case 39: {
                        this.ensureLocalSlot(2);
                        this.addStackSlot(2);
                        break;
                    }
                    case 32: 
                    case 40: {
                        this.ensureLocalSlot(3);
                        this.addStackSlot(2);
                        break;
                    }
                    case 33: 
                    case 41: {
                        this.ensureLocalSlot(4);
                        this.addStackSlot(2);
                        break;
                    }
                    case 46: 
                    case 48: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: {
                        this.addStackSlot(-1);
                        break;
                    }
                    case 54: 
                    case 56: 
                    case 58: {
                        this.ensureLocalSlot(this.bcs.getIndex());
                        this.addStackSlot(-1);
                        break;
                    }
                    case 55: 
                    case 57: {
                        this.ensureLocalSlot(this.bcs.getIndex() + 1);
                        this.addStackSlot(-2);
                        break;
                    }
                    case 59: 
                    case 67: 
                    case 75: {
                        this.ensureLocalSlot(0);
                        this.addStackSlot(-1);
                        break;
                    }
                    case 60: 
                    case 68: 
                    case 76: {
                        this.ensureLocalSlot(1);
                        this.addStackSlot(-1);
                        break;
                    }
                    case 61: 
                    case 69: 
                    case 77: {
                        this.ensureLocalSlot(2);
                        this.addStackSlot(-1);
                        break;
                    }
                    case 62: 
                    case 70: 
                    case 78: {
                        this.ensureLocalSlot(3);
                        this.addStackSlot(-1);
                        break;
                    }
                    case 63: 
                    case 71: {
                        this.ensureLocalSlot(1);
                        this.addStackSlot(-2);
                        break;
                    }
                    case 64: 
                    case 72: {
                        this.ensureLocalSlot(2);
                        this.addStackSlot(-2);
                        break;
                    }
                    case 65: 
                    case 73: {
                        this.ensureLocalSlot(3);
                        this.addStackSlot(-2);
                        break;
                    }
                    case 66: 
                    case 74: {
                        this.ensureLocalSlot(4);
                        this.addStackSlot(-2);
                        break;
                    }
                    case 132: {
                        this.ensureLocalSlot(this.bcs.getIndex());
                        break;
                    }
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: {
                        this.addStackSlot(-2);
                        this.jump(this.bcs.dest());
                        break;
                    }
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: 
                    case 198: 
                    case 199: {
                        this.addStackSlot(-1);
                        this.jump(this.bcs.dest());
                        break;
                    }
                    case 167: {
                        this.jump(this.bcs.dest());
                        this.next();
                        break;
                    }
                    case 200: {
                        this.jump(this.bcs.destW());
                        this.next();
                        break;
                    }
                    case 170: 
                    case 171: {
                        int delta;
                        int keys;
                        int alignedBci = RawBytecodeHelper.align(bci + 1);
                        int defaultOffset = this.bcs.getIntUnchecked(alignedBci);
                        this.addStackSlot(-1);
                        if (this.bcs.opcode() == 170) {
                            int high;
                            int low = this.bcs.getIntUnchecked(alignedBci + 4);
                            if (low > (high = this.bcs.getIntUnchecked(alignedBci + 8))) {
                                throw this.error("low must be less than or equal to high in tableswitch");
                            }
                            keys = high - low + 1;
                            if (keys < 0) {
                                throw this.error("too many keys in tableswitch");
                            }
                            delta = 1;
                        } else {
                            keys = this.bcs.getIntUnchecked(alignedBci + 4);
                            if (keys < 0) {
                                throw this.error("number of keys in lookupswitch less than 0");
                            }
                            delta = 2;
                            for (int i = 0; i < keys - 1; ++i) {
                                int next_key;
                                int this_key = this.bcs.getIntUnchecked(alignedBci + (2 + 2 * i) * 4);
                                if (this_key < (next_key = this.bcs.getIntUnchecked(alignedBci + (2 + 2 * i + 2) * 4))) continue;
                                throw this.error("Bad lookupswitch instruction");
                            }
                        }
                        int target = bci + defaultOffset;
                        this.jump(target);
                        for (int i = 0; i < keys; ++i) {
                            target = bci + this.bcs.getIntUnchecked(alignedBci + (3 + i * delta) * 4);
                            this.jump(target);
                        }
                        this.next();
                        break;
                    }
                    case 173: 
                    case 175: {
                        this.addStackSlot(-2);
                        this.next();
                        break;
                    }
                    case 172: 
                    case 174: 
                    case 176: 
                    case 191: {
                        this.addStackSlot(-1);
                        this.next();
                        break;
                    }
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: {
                        TypeKind tk = TypeKind.fromDescriptor(cp.entryByIndex(this.bcs.getIndexU2(), MemberRefEntry.class).nameAndType().type());
                        switch (this.bcs.opcode()) {
                            case 178: {
                                this.addStackSlot(tk.slotSize());
                                break block0;
                            }
                            case 179: {
                                this.addStackSlot(-tk.slotSize());
                                break block0;
                            }
                            case 180: {
                                this.addStackSlot(tk.slotSize() - 1);
                                break block0;
                            }
                            case 181: {
                                this.addStackSlot(-tk.slotSize() - 1);
                                break block0;
                            }
                        }
                        throw new AssertionError((Object)"Should not reach here");
                    }
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: 
                    case 186: {
                        PoolEntry cpe = cp.entryByIndex(this.bcs.getIndexU2());
                        NameAndTypeEntry nameAndType = opcode == 186 ? ((DynamicConstantPoolEntry)cpe).nameAndType() : ((MemberRefEntry)cpe).nameAndType();
                        MethodTypeDesc mtd = Util.methodTypeSymbol(nameAndType.type());
                        int delta = Util.slotSize(mtd.returnType()) - Util.parameterSlots(mtd);
                        if (opcode != 184 && opcode != 186) {
                            --delta;
                        }
                        this.addStackSlot(delta);
                        break;
                    }
                    case 197: {
                        this.addStackSlot(1 - this.bcs.getU1Unchecked(this.bcs.bci() + 3));
                        break;
                    }
                    case 168: {
                        this.addStackSlot(1);
                        this.jump(this.bcs.dest());
                        this.addStackSlot(-1);
                        break;
                    }
                    case 201: {
                        this.addStackSlot(1);
                        this.jump(this.bcs.destW());
                        this.addStackSlot(-1);
                        break;
                    }
                    case 169: {
                        this.ensureLocalSlot(this.bcs.getIndex());
                        ++this.rets;
                        this.next();
                        break;
                    }
                    default: {
                        throw this.error(String.format("Bad instruction: %02x", opcode));
                    }
                }
            }
        }
        this.maxStack += this.rets * this.maxStack;
    }

    public int maxLocals() {
        return this.maxLocals;
    }

    public int maxStack() {
        return this.maxStack;
    }

    private void processLdc(int index) {
        switch (this.cp.entryByIndex(index).tag()) {
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                this.addStackSlot(1);
                break;
            }
            case 5: 
            case 6: {
                this.addStackSlot(2);
                break;
            }
            case 17: {
                this.addStackSlot(this.cp.entryByIndex(index, ConstantDynamicEntry.class).typeKind().slotSize());
                break;
            }
            default: {
                throw this.error("CP entry #%d %s is not loadable constant".formatted(index, this.cp.entryByIndex(index).tag()));
            }
        }
    }

    private IllegalArgumentException error(String msg) {
        StringBuilder sb = new StringBuilder("%s at bytecode offset %d of method %s(%s)".formatted(msg, this.bcs.bci(), this.methodName, this.methodDesc.parameterList().stream().map(ClassDesc::displayName).collect(Collectors.joining(","))));
        Util.dumpMethod(this.cp, this.thisClass, this.methodName, this.methodDesc, this.isStatic ? 8 : 0, this.bcs.code, sb::append);
        return new IllegalArgumentException(sb.toString());
    }

    private record Target(int bci, int stack) {
    }
}

