/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.ClassBuilder;
import io.smallrye.classfile.ClassElement;
import io.smallrye.classfile.ClassFile;
import io.smallrye.classfile.ClassModel;
import io.smallrye.classfile.CustomAttribute;
import io.smallrye.classfile.FieldBuilder;
import io.smallrye.classfile.FieldModel;
import io.smallrye.classfile.FieldTransform;
import io.smallrye.classfile.MethodBuilder;
import io.smallrye.classfile.MethodModel;
import io.smallrye.classfile.MethodTransform;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.AbstractDirectBuilder;
import io.smallrye.classfile.impl.AbstractElement;
import io.smallrye.classfile.impl.AbstractPoolEntry;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.ClassFileImpl;
import io.smallrye.classfile.impl.DirectFieldBuilder;
import io.smallrye.classfile.impl.DirectMethodBuilder;
import io.smallrye.classfile.impl.SplitConstantPool;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ConstantDescs;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class DirectClassBuilder
extends AbstractDirectBuilder<ClassModel>
implements ClassBuilder {
    static final int DEFAULT_CLASS_FLAGS = 33;
    static final Util.Writable[] EMPTY_WRITABLE_ARRAY = new Util.Writable[0];
    static final ClassEntry[] EMPTY_CLASS_ENTRY_ARRAY = new ClassEntry[0];
    final ClassEntry thisClassEntry;
    private Util.Writable[] fields = EMPTY_WRITABLE_ARRAY;
    private Util.Writable[] methods = EMPTY_WRITABLE_ARRAY;
    private int fieldsCount = 0;
    private int methodsCount = 0;
    private ClassEntry superclassEntry;
    private List<ClassEntry> interfaceEntries;
    private int majorVersion;
    private int minorVersion;
    private int flags;
    private int sizeHint;

    public DirectClassBuilder(SplitConstantPool constantPool, ClassFileImpl context, ClassEntry thisClass) {
        super(constantPool, context);
        this.thisClassEntry = AbstractPoolEntry.maybeClone(constantPool, thisClass);
        this.flags = 33;
        this.superclassEntry = null;
        this.interfaceEntries = Collections.emptyList();
        this.majorVersion = ClassFile.latestMajorVersion();
        this.minorVersion = ClassFile.latestMinorVersion();
    }

    @Override
    public ClassBuilder with(ClassElement element) {
        if (element instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)((Object)element);
            ae.writeTo(this);
        } else {
            this.writeAttribute((CustomAttribute)Objects.requireNonNull(element));
        }
        return this;
    }

    @Override
    public ClassBuilder withFlags(int flags) {
        this.setFlags(Util.checkFlags(flags));
        return this;
    }

    @Override
    public ClassBuilder withField(Utf8Entry name, Utf8Entry descriptor, int flags) {
        return this.withField(new DirectFieldBuilder(this.constantPool, this.context, name, descriptor, flags, null));
    }

    @Override
    public ClassBuilder withField(Utf8Entry name, Utf8Entry descriptor, Consumer<? super FieldBuilder> handler) {
        return this.withField(new DirectFieldBuilder(this.constantPool, this.context, name, descriptor, 0, null).run(handler));
    }

    @Override
    public ClassBuilder transformField(FieldModel field, FieldTransform transform) {
        DirectFieldBuilder builder = new DirectFieldBuilder(this.constantPool, this.context, field.fieldName(), field.fieldType(), 0, field);
        builder.transform(field, transform);
        return this.withField(builder);
    }

    @Override
    public ClassBuilder withMethod(Utf8Entry name, Utf8Entry descriptor, int flags, Consumer<? super MethodBuilder> handler) {
        return this.withMethod(new DirectMethodBuilder(this.constantPool, this.context, name, descriptor, flags, null).run(handler));
    }

    @Override
    public ClassBuilder transformMethod(MethodModel method, MethodTransform transform) {
        DirectMethodBuilder builder = new DirectMethodBuilder(this.constantPool, this.context, method.methodName(), method.methodType(), method.flags().flagsMask(), method);
        builder.transform(method, transform);
        return this.withMethod(builder);
    }

    ClassBuilder withField(Util.Writable field) {
        if (this.fieldsCount >= this.fields.length) {
            int newCapacity = this.fieldsCount + 8;
            this.fields = Arrays.copyOf(this.fields, newCapacity);
        }
        this.fields[this.fieldsCount++] = field;
        return this;
    }

    ClassBuilder withMethod(Util.Writable method) {
        if (this.methodsCount >= this.methods.length) {
            int newCapacity = this.methodsCount + 8;
            this.methods = Arrays.copyOf(this.methods, newCapacity);
        }
        this.methods[this.methodsCount++] = method;
        return this;
    }

    void setSuperclass(ClassEntry superclassEntry) {
        this.superclassEntry = superclassEntry;
    }

    void setInterfaces(List<ClassEntry> interfaces) {
        this.interfaceEntries = interfaces;
    }

    void setVersion(int major, int minor) {
        this.majorVersion = major;
        this.minorVersion = minor;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }

    public void setSizeHint(int sizeHint) {
        this.sizeHint = sizeHint;
    }

    public byte[] build() {
        SplitConstantPool constantPool = this.constantPool;
        ClassEntry superclass = this.superclassEntry;
        if (superclass != null) {
            superclass = AbstractPoolEntry.maybeClone(constantPool, superclass);
        } else if ((this.flags & 0x8000) == 0 && !"java/lang/Object".equals(this.thisClassEntry.asInternalName())) {
            superclass = constantPool.classEntry(ConstantDescs.CD_Object);
        }
        int interfaceEntriesSize = this.interfaceEntries.size();
        ClassEntry[] ies = interfaceEntriesSize == 0 ? EMPTY_CLASS_ENTRY_ARRAY : this.buildInterfaceEnties(interfaceEntriesSize);
        int size = this.sizeHint == 0 ? 256 : this.sizeHint;
        BufWriterImpl head = new BufWriterImpl(constantPool, this.context, size);
        BufWriterImpl tail = new BufWriterImpl(constantPool, this.context, size, this.thisClassEntry, this.majorVersion);
        Util.writeList(tail, this.fields, this.fieldsCount);
        Util.writeList(tail, this.methods, this.methodsCount);
        int attributesOffset = tail.size();
        this.attributes.writeTo(tail);
        if (constantPool.writeBootstrapMethods(tail)) {
            tail.patchU2(attributesOffset, this.attributes.size() + 1);
        }
        head.writeInt(-889275714);
        head.writeU2U2(this.minorVersion, this.majorVersion);
        constantPool.writeTo(head);
        head.writeU2U2U2(this.flags, head.cpIndex(this.thisClassEntry), head.cpIndexOrZero(superclass));
        head.writeU2(interfaceEntriesSize);
        for (int i = 0; i < interfaceEntriesSize; ++i) {
            head.writeIndex(ies[i]);
        }
        return BufWriterImpl.join(head, tail);
    }

    private ClassEntry[] buildInterfaceEnties(int interfaceEntriesSize) {
        ClassEntry[] ies = new ClassEntry[interfaceEntriesSize];
        for (int i = 0; i < interfaceEntriesSize; ++i) {
            ies[i] = AbstractPoolEntry.maybeClone(this.constantPool, this.interfaceEntries.get(i));
        }
        return ies;
    }
}

