/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Annotation;
import io.smallrye.classfile.AnnotationElement;
import io.smallrye.classfile.AnnotationValue;
import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.ClassBuilder;
import io.smallrye.classfile.ClassElement;
import io.smallrye.classfile.ClassSignature;
import io.smallrye.classfile.CodeModel;
import io.smallrye.classfile.CodeTransform;
import io.smallrye.classfile.FieldModel;
import io.smallrye.classfile.FieldTransform;
import io.smallrye.classfile.Interfaces;
import io.smallrye.classfile.MethodModel;
import io.smallrye.classfile.MethodSignature;
import io.smallrye.classfile.MethodTransform;
import io.smallrye.classfile.Signature;
import io.smallrye.classfile.Superclass;
import io.smallrye.classfile.TypeAnnotation;
import io.smallrye.classfile.attribute.AnnotationDefaultAttribute;
import io.smallrye.classfile.attribute.EnclosingMethodAttribute;
import io.smallrye.classfile.attribute.ExceptionsAttribute;
import io.smallrye.classfile.attribute.InnerClassInfo;
import io.smallrye.classfile.attribute.InnerClassesAttribute;
import io.smallrye.classfile.attribute.ModuleAttribute;
import io.smallrye.classfile.attribute.ModuleProvideInfo;
import io.smallrye.classfile.attribute.NestHostAttribute;
import io.smallrye.classfile.attribute.NestMembersAttribute;
import io.smallrye.classfile.attribute.PermittedSubclassesAttribute;
import io.smallrye.classfile.attribute.RecordAttribute;
import io.smallrye.classfile.attribute.RecordComponentInfo;
import io.smallrye.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import io.smallrye.classfile.attribute.SignatureAttribute;
import io.smallrye.classfile.components.ClassRemapper;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.Util;
import io.smallrye.classfile.instruction.ConstantInstruction;
import io.smallrye.classfile.instruction.ExceptionCatch;
import io.smallrye.classfile.instruction.FieldInstruction;
import io.smallrye.classfile.instruction.InvokeDynamicInstruction;
import io.smallrye.classfile.instruction.InvokeInstruction;
import io.smallrye.classfile.instruction.LocalVariable;
import io.smallrye.classfile.instruction.LocalVariableType;
import io.smallrye.classfile.instruction.NewMultiArrayInstruction;
import io.smallrye.classfile.instruction.NewObjectInstruction;
import io.smallrye.classfile.instruction.NewReferenceArrayInstruction;
import io.smallrye.classfile.instruction.TypeCheckInstruction;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.function.Function;

public record ClassRemapperImpl(Function<ClassDesc, ClassDesc> mapFunction) implements ClassRemapper
{
    @Override
    public void accept(ClassBuilder clb, ClassElement cle) {
        if (cle instanceof FieldModel) {
            FieldModel fm = (FieldModel)cle;
            clb.withField(fm.fieldName().stringValue(), this.map(fm.fieldTypeSymbol()), fb -> fb.transform(fm, this.asFieldTransform()));
        } else if (cle instanceof MethodModel) {
            MethodModel mm = (MethodModel)cle;
            clb.withMethod(mm.methodName().stringValue(), this.mapMethodDesc(mm.methodTypeSymbol()), mm.flags().flagsMask(), mb -> mb.transform(mm, this.asMethodTransform()));
        } else if (cle instanceof Superclass) {
            Superclass sc = (Superclass)cle;
            clb.withSuperclass(this.map(sc.superclassEntry().asSymbol()));
        } else if (cle instanceof Interfaces) {
            Interfaces ins = (Interfaces)cle;
            clb.withInterfaceSymbols(Util.mappedList(ins.interfaces(), in -> this.map(in.asSymbol())));
        } else if (cle instanceof SignatureAttribute) {
            SignatureAttribute sa = (SignatureAttribute)cle;
            clb.with(SignatureAttribute.of(this.mapClassSignature(sa.asClassSignature())));
        } else if (cle instanceof InnerClassesAttribute) {
            InnerClassesAttribute ica = (InnerClassesAttribute)cle;
            clb.with(InnerClassesAttribute.of(ica.classes().stream().map((? super T ici) -> InnerClassInfo.of(this.map(ici.innerClass().asSymbol()), ici.outerClass().map((? super T oc) -> this.map(oc.asSymbol())), ici.innerName().map(Utf8Entry::stringValue), ici.flagsMask())).toList()));
        } else if (cle instanceof EnclosingMethodAttribute) {
            EnclosingMethodAttribute ema = (EnclosingMethodAttribute)cle;
            clb.with(EnclosingMethodAttribute.of(this.map(ema.enclosingClass().asSymbol()), ema.enclosingMethodName().map(Utf8Entry::stringValue), ema.enclosingMethodTypeSymbol().map(this::mapMethodDesc)));
        } else if (cle instanceof RecordAttribute) {
            RecordAttribute ra = (RecordAttribute)cle;
            clb.with(RecordAttribute.of(ra.components().stream().map(this::mapRecordComponent).toList()));
        } else if (cle instanceof ModuleAttribute) {
            ModuleAttribute ma = (ModuleAttribute)cle;
            clb.with(ModuleAttribute.of(ma.moduleName(), ma.moduleFlagsMask(), ma.moduleVersion().orElse(null), ma.requires(), ma.exports(), ma.opens(), ma.uses().stream().map((? super T ce) -> clb.constantPool().classEntry(this.map(ce.asSymbol()))).toList(), ma.provides().stream().map((? super T mp) -> ModuleProvideInfo.of(this.map(mp.provides().asSymbol()), mp.providesWith().stream().map((? super T pw) -> this.map(pw.asSymbol())).toList())).toList()));
        } else if (cle instanceof NestHostAttribute) {
            NestHostAttribute nha = (NestHostAttribute)cle;
            clb.with(NestHostAttribute.of(this.map(nha.nestHost().asSymbol())));
        } else if (cle instanceof NestMembersAttribute) {
            NestMembersAttribute nma = (NestMembersAttribute)cle;
            clb.with(NestMembersAttribute.ofSymbols(nma.nestMembers().stream().map((? super T nm) -> this.map(nm.asSymbol())).toList()));
        } else if (cle instanceof PermittedSubclassesAttribute) {
            PermittedSubclassesAttribute psa = (PermittedSubclassesAttribute)cle;
            clb.with(PermittedSubclassesAttribute.ofSymbols(psa.permittedSubclasses().stream().map((? super T ps) -> this.map(ps.asSymbol())).toList()));
        } else if (cle instanceof RuntimeVisibleAnnotationsAttribute) {
            RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)cle;
            clb.with(RuntimeVisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
        } else if (cle instanceof RuntimeInvisibleAnnotationsAttribute) {
            RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)cle;
            clb.with(RuntimeInvisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
        } else if (cle instanceof RuntimeVisibleTypeAnnotationsAttribute) {
            RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)cle;
            clb.with(RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
        } else if (cle instanceof RuntimeInvisibleTypeAnnotationsAttribute) {
            RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)cle;
            clb.with(RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
        } else {
            clb.with(cle);
        }
    }

    @Override
    public FieldTransform asFieldTransform() {
        return (fb, fe) -> {
            if (fe instanceof SignatureAttribute) {
                SignatureAttribute sa = (SignatureAttribute)fe;
                fb.with(SignatureAttribute.of(this.mapSignature(sa.asTypeSignature())));
            } else if (fe instanceof RuntimeVisibleAnnotationsAttribute) {
                RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)fe;
                fb.with(RuntimeVisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
            } else if (fe instanceof RuntimeInvisibleAnnotationsAttribute) {
                RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)fe;
                fb.with(RuntimeInvisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
            } else if (fe instanceof RuntimeVisibleTypeAnnotationsAttribute) {
                RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)fe;
                fb.with(RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
            } else if (fe instanceof RuntimeInvisibleTypeAnnotationsAttribute) {
                RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)fe;
                fb.with(RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
            } else {
                fb.with(fe);
            }
        };
    }

    @Override
    public MethodTransform asMethodTransform() {
        return (mb, me) -> {
            if (me instanceof AnnotationDefaultAttribute) {
                AnnotationDefaultAttribute ada = (AnnotationDefaultAttribute)me;
                mb.with(AnnotationDefaultAttribute.of(this.mapAnnotationValue(ada.defaultValue())));
            } else if (me instanceof CodeModel) {
                CodeModel com = (CodeModel)me;
                mb.transformCode(com, this.asCodeTransform());
            } else if (me instanceof ExceptionsAttribute) {
                ExceptionsAttribute ea = (ExceptionsAttribute)me;
                mb.with(ExceptionsAttribute.ofSymbols(ea.exceptions().stream().map((? super T ce) -> this.map(ce.asSymbol())).toList()));
            } else if (me instanceof SignatureAttribute) {
                SignatureAttribute sa = (SignatureAttribute)me;
                mb.with(SignatureAttribute.of(this.mapMethodSignature(sa.asMethodSignature())));
            } else if (me instanceof RuntimeVisibleAnnotationsAttribute) {
                RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)me;
                mb.with(RuntimeVisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
            } else if (me instanceof RuntimeInvisibleAnnotationsAttribute) {
                RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)me;
                mb.with(RuntimeInvisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations())));
            } else if (me instanceof RuntimeVisibleParameterAnnotationsAttribute) {
                RuntimeVisibleParameterAnnotationsAttribute paa = (RuntimeVisibleParameterAnnotationsAttribute)me;
                mb.with(RuntimeVisibleParameterAnnotationsAttribute.of(paa.parameterAnnotations().stream().map(this::mapAnnotations).toList()));
            } else if (me instanceof RuntimeInvisibleParameterAnnotationsAttribute) {
                RuntimeInvisibleParameterAnnotationsAttribute paa = (RuntimeInvisibleParameterAnnotationsAttribute)me;
                mb.with(RuntimeInvisibleParameterAnnotationsAttribute.of(paa.parameterAnnotations().stream().map(this::mapAnnotations).toList()));
            } else if (me instanceof RuntimeVisibleTypeAnnotationsAttribute) {
                RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)me;
                mb.with(RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
            } else if (me instanceof RuntimeInvisibleTypeAnnotationsAttribute) {
                RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)me;
                mb.with(RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
            } else {
                mb.with(me);
            }
        };
    }

    @Override
    public CodeTransform asCodeTransform() {
        return (cob, coe) -> {
            if (coe instanceof FieldInstruction) {
                FieldInstruction fai = (FieldInstruction)coe;
                cob.fieldAccess(fai.opcode(), this.map(fai.owner().asSymbol()), fai.name().stringValue(), this.map(fai.typeSymbol()));
            } else if (coe instanceof InvokeInstruction) {
                InvokeInstruction ii = (InvokeInstruction)coe;
                cob.invoke(ii.opcode(), this.map(ii.owner().asSymbol()), ii.name().stringValue(), this.mapMethodDesc(ii.typeSymbol()), ii.isInterface());
            } else if (coe instanceof InvokeDynamicInstruction) {
                InvokeDynamicInstruction idi = (InvokeDynamicInstruction)coe;
                cob.invokedynamic(DynamicCallSiteDesc.of(this.mapDirectMethodHandle(idi.bootstrapMethod()), idi.name().stringValue(), this.mapMethodDesc(idi.typeSymbol()), (ConstantDesc[])idi.bootstrapArgs().stream().map(this::mapConstantValue).toArray(ConstantDesc[]::new)));
            } else if (coe instanceof NewObjectInstruction) {
                NewObjectInstruction c = (NewObjectInstruction)coe;
                cob.new_(this.map(c.className().asSymbol()));
            } else if (coe instanceof NewReferenceArrayInstruction) {
                NewReferenceArrayInstruction c = (NewReferenceArrayInstruction)coe;
                cob.anewarray(this.map(c.componentType().asSymbol()));
            } else if (coe instanceof NewMultiArrayInstruction) {
                NewMultiArrayInstruction c = (NewMultiArrayInstruction)coe;
                cob.multianewarray(this.map(c.arrayType().asSymbol()), c.dimensions());
            } else if (coe instanceof TypeCheckInstruction) {
                TypeCheckInstruction c = (TypeCheckInstruction)coe;
                cob.with(TypeCheckInstruction.of(c.opcode(), this.map(c.type().asSymbol())));
            } else if (coe instanceof ExceptionCatch) {
                ExceptionCatch c = (ExceptionCatch)coe;
                cob.exceptionCatch(c.tryStart(), c.tryEnd(), c.handler(), c.catchType().map((? super T d) -> TemporaryConstantPool.INSTANCE.classEntry(this.map(d.asSymbol()))));
            } else if (coe instanceof LocalVariable) {
                LocalVariable c = (LocalVariable)coe;
                cob.localVariable(c.slot(), c.name().stringValue(), this.map(c.typeSymbol()), c.startScope(), c.endScope());
            } else if (coe instanceof LocalVariableType) {
                LocalVariableType c = (LocalVariableType)coe;
                cob.localVariableType(c.slot(), c.name().stringValue(), this.mapSignature(c.signatureSymbol()), c.startScope(), c.endScope());
            } else if (coe instanceof ConstantInstruction.LoadConstantInstruction) {
                ConstantInstruction.LoadConstantInstruction ldc = (ConstantInstruction.LoadConstantInstruction)coe;
                cob.ldc(this.mapConstantValue(ldc.constantValue()));
            } else if (coe instanceof RuntimeVisibleTypeAnnotationsAttribute) {
                RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)coe;
                cob.with(RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
            } else if (coe instanceof RuntimeInvisibleTypeAnnotationsAttribute) {
                RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)coe;
                cob.with(RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations())));
            } else {
                cob.with(coe);
            }
        };
    }

    @Override
    public ClassDesc map(ClassDesc desc) {
        if (desc == null) {
            return null;
        }
        if (desc.isArray()) {
            return this.map(desc.componentType()).arrayType();
        }
        if (desc.isPrimitive()) {
            return desc;
        }
        return this.mapFunction.apply(desc);
    }

    MethodTypeDesc mapMethodDesc(MethodTypeDesc desc) {
        return MethodTypeDesc.of(this.map(desc.returnType()), (ClassDesc[])desc.parameterList().stream().map(this::map).toArray(ClassDesc[]::new));
    }

    ClassSignature mapClassSignature(ClassSignature signature) {
        return ClassSignature.of(this.mapTypeParams(signature.typeParameters()), this.mapSignature(signature.superclassSignature()), (Signature.ClassTypeSig[])signature.superinterfaceSignatures().stream().map(this::mapSignature).toArray(Signature.ClassTypeSig[]::new));
    }

    MethodSignature mapMethodSignature(MethodSignature signature) {
        return MethodSignature.of(this.mapTypeParams(signature.typeParameters()), signature.throwableSignatures().stream().map(this::mapSignature).toList(), this.mapSignature(signature.result()), (Signature[])signature.arguments().stream().map(this::mapSignature).toArray(Signature[]::new));
    }

    RecordComponentInfo mapRecordComponent(RecordComponentInfo component) {
        return RecordComponentInfo.of(component.name().stringValue(), this.map(component.descriptorSymbol()), component.attributes().stream().map((? super T atr) -> {
            Attribute<SignatureAttribute> attribute;
            if (atr instanceof SignatureAttribute) {
                SignatureAttribute sa = (SignatureAttribute)atr;
                attribute = SignatureAttribute.of(this.mapSignature(sa.asTypeSignature()));
            } else if (atr instanceof RuntimeVisibleAnnotationsAttribute) {
                RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)atr;
                attribute = RuntimeVisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations()));
            } else if (atr instanceof RuntimeInvisibleAnnotationsAttribute) {
                RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)atr;
                attribute = RuntimeInvisibleAnnotationsAttribute.of(this.mapAnnotations(aa.annotations()));
            } else if (atr instanceof RuntimeVisibleTypeAnnotationsAttribute) {
                RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)atr;
                attribute = RuntimeVisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations()));
            } else if (atr instanceof RuntimeInvisibleTypeAnnotationsAttribute) {
                RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)atr;
                attribute = RuntimeInvisibleTypeAnnotationsAttribute.of(this.mapTypeAnnotations(aa.annotations()));
            } else {
                attribute = atr;
            }
            return attribute;
        }).toList());
    }

    DirectMethodHandleDesc mapDirectMethodHandle(DirectMethodHandleDesc dmhd) {
        return switch (dmhd.kind()) {
            case DirectMethodHandleDesc.Kind.GETTER, DirectMethodHandleDesc.Kind.SETTER, DirectMethodHandleDesc.Kind.STATIC_GETTER, DirectMethodHandleDesc.Kind.STATIC_SETTER -> MethodHandleDesc.ofField(dmhd.kind(), this.map(dmhd.owner()), dmhd.methodName(), this.map(ClassDesc.ofDescriptor(dmhd.lookupDescriptor())));
            default -> MethodHandleDesc.ofMethod(dmhd.kind(), this.map(dmhd.owner()), dmhd.methodName(), this.mapMethodDesc(MethodTypeDesc.ofDescriptor(dmhd.lookupDescriptor())));
        };
    }

    ConstantDesc mapConstantValue(ConstantDesc value) {
        ConstantDesc constantDesc;
        if (value instanceof ClassDesc) {
            ClassDesc cd = (ClassDesc)value;
            constantDesc = this.map(cd);
        } else if (value instanceof DynamicConstantDesc) {
            DynamicConstantDesc dcd = (DynamicConstantDesc)value;
            constantDesc = this.mapDynamicConstant(dcd);
        } else if (value instanceof DirectMethodHandleDesc) {
            DirectMethodHandleDesc dmhd = (DirectMethodHandleDesc)value;
            constantDesc = this.mapDirectMethodHandle(dmhd);
        } else if (value instanceof MethodTypeDesc) {
            MethodTypeDesc mtd = (MethodTypeDesc)value;
            constantDesc = this.mapMethodDesc(mtd);
        } else {
            constantDesc = value;
        }
        return constantDesc;
    }

    DynamicConstantDesc<?> mapDynamicConstant(DynamicConstantDesc<?> dcd) {
        return DynamicConstantDesc.ofNamed(this.mapDirectMethodHandle(dcd.bootstrapMethod()), dcd.constantName(), this.map(dcd.constantType()), (ConstantDesc[])dcd.bootstrapArgsList().stream().map(this::mapConstantValue).toArray(ConstantDesc[]::new));
    }

    <S extends Signature> S mapSignature(S signature) {
        if (signature instanceof Signature.ArrayTypeSig) {
            Signature.ArrayTypeSig ats = (Signature.ArrayTypeSig)signature;
            return (S)Signature.ArrayTypeSig.of(this.mapSignature(ats.componentSignature()));
        }
        if (signature instanceof Signature.ClassTypeSig) {
            Signature.ClassTypeSig cts = (Signature.ClassTypeSig)signature;
            return (S)Signature.ClassTypeSig.of((Signature.ClassTypeSig)cts.outerType().map(this::mapSignature).orElse(null), Util.toInternalName(this.map(cts.classDesc())), (Signature.TypeArg[])cts.typeArgs().stream().map((? super T ta) -> {
                Signature.TypeArg typeArg;
                if (ta instanceof Signature.TypeArg.Unbounded) {
                    Signature.TypeArg.Unbounded u;
                    typeArg = u = (Signature.TypeArg.Unbounded)ta;
                } else if (ta instanceof Signature.TypeArg.Bounded) {
                    Signature.TypeArg.Bounded bta = (Signature.TypeArg.Bounded)ta;
                    typeArg = Signature.TypeArg.bounded(bta.wildcardIndicator(), this.mapSignature(bta.boundType()));
                } else {
                    typeArg = null;
                }
                return typeArg;
            }).toArray(Signature.TypeArg[]::new));
        }
        return signature;
    }

    List<Annotation> mapAnnotations(List<Annotation> annotations) {
        return annotations.stream().map(this::mapAnnotation).toList();
    }

    Annotation mapAnnotation(Annotation a) {
        return Annotation.of(this.map(a.classSymbol()), a.elements().stream().map((? super T el) -> AnnotationElement.of(el.name(), this.mapAnnotationValue(el.value()))).toList());
    }

    AnnotationValue mapAnnotationValue(AnnotationValue val) {
        if (val instanceof AnnotationValue.OfAnnotation) {
            AnnotationValue.OfAnnotation oa = (AnnotationValue.OfAnnotation)val;
            return AnnotationValue.ofAnnotation(this.mapAnnotation(oa.annotation()));
        }
        if (val instanceof AnnotationValue.OfArray) {
            AnnotationValue.OfArray oa = (AnnotationValue.OfArray)val;
            return AnnotationValue.ofArray(oa.values().stream().map(this::mapAnnotationValue).toList());
        }
        if (val instanceof AnnotationValue.OfConstant) {
            AnnotationValue.OfConstant oc = (AnnotationValue.OfConstant)val;
            return oc;
        }
        if (val instanceof AnnotationValue.OfClass) {
            AnnotationValue.OfClass oc = (AnnotationValue.OfClass)val;
            return AnnotationValue.ofClass(this.map(oc.classSymbol()));
        }
        if (val instanceof AnnotationValue.OfEnum) {
            AnnotationValue.OfEnum oe = (AnnotationValue.OfEnum)val;
            return AnnotationValue.ofEnum(this.map(oe.classSymbol()), oe.constantName().stringValue());
        }
        throw new IllegalStateException();
    }

    List<TypeAnnotation> mapTypeAnnotations(List<TypeAnnotation> typeAnnotations) {
        return typeAnnotations.stream().map((? super T a) -> TypeAnnotation.of(a.targetInfo(), a.targetPath(), this.mapAnnotation(a.annotation()))).toList();
    }

    List<Signature.TypeParam> mapTypeParams(List<Signature.TypeParam> typeParams) {
        return typeParams.stream().map((? super T tp) -> Signature.TypeParam.of(tp.identifier(), tp.classBound().map(this::mapSignature), (Signature.RefTypeSig[])tp.interfaceBounds().stream().map(this::mapSignature).toArray(Signature.RefTypeSig[]::new))).toList();
    }
}

