/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.AttributeMapper;
import io.smallrye.classfile.Attributes;
import io.smallrye.classfile.BootstrapMethodEntry;
import io.smallrye.classfile.BufWriter;
import io.smallrye.classfile.ClassFile;
import io.smallrye.classfile.ClassModel;
import io.smallrye.classfile.ClassReader;
import io.smallrye.classfile.attribute.BootstrapMethodsAttribute;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.ConstantPool;
import io.smallrye.classfile.constantpool.ConstantPoolException;
import io.smallrye.classfile.constantpool.LoadableConstantEntry;
import io.smallrye.classfile.constantpool.PoolEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.AbstractPoolEntry;
import io.smallrye.classfile.impl.BootstrapMethodEntryImpl;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.ClassFileImpl;
import io.smallrye.classfile.impl.UnboundAttribute;
import io.smallrye.classfile.impl.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class ClassReaderImpl
implements ClassReader {
    static final int CP_ITEM_START = 10;
    private final byte[] buffer;
    private final int metadataStart;
    private final int classfileLength;
    private final Function<Utf8Entry, AttributeMapper<?>> attributeMapper;
    private final int flags;
    private final int thisClassPos;
    private ClassEntry thisClass;
    private Optional<ClassEntry> superclass;
    private final int constantPoolCount;
    private final int[] cpOffset;
    final ClassFileImpl context;
    final int interfacesPos;
    final PoolEntry[] cp;
    private ClassModel containedClass;
    private List<BootstrapMethodEntryImpl> bsmEntries;
    private BootstrapMethodsAttribute bootstrapMethodsAttribute;

    ClassReaderImpl(byte[] classfileBytes, ClassFileImpl context) {
        this.buffer = classfileBytes;
        this.classfileLength = classfileBytes.length;
        this.context = context;
        this.attributeMapper = this.context.attributeMapper();
        if (this.classfileLength < 4 || this.readInt(0) != -889275714) {
            throw new IllegalArgumentException("Bad magic number");
        }
        if (this.readU2(6) > ClassFile.latestMajorVersion()) {
            throw new IllegalArgumentException("Unsupported class file version: " + this.readU2(6));
        }
        int constantPoolCount = this.readU2(8);
        int[] cpOffset = new int[constantPoolCount];
        int p = 10;
        block7: for (int i = 1; i < cpOffset.length; ++i) {
            cpOffset[i] = p;
            int tag = this.readU1(p);
            ++p;
            switch (tag) {
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    p += 2;
                    continue block7;
                }
                case 15: {
                    p += 3;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    p += 4;
                    continue block7;
                }
                case 5: 
                case 6: {
                    p += 8;
                    ++i;
                    continue block7;
                }
                case 1: {
                    p += 2 + this.readU2(p);
                    continue block7;
                }
                default: {
                    throw new ConstantPoolException("Bad tag (" + tag + ") at index (" + i + ") position (" + p + ")");
                }
            }
        }
        this.metadataStart = p;
        this.cpOffset = cpOffset;
        this.constantPoolCount = constantPoolCount;
        this.cp = new PoolEntry[constantPoolCount];
        this.flags = this.readU2(p);
        this.thisClassPos = p + 2;
        this.interfacesPos = p += 6;
    }

    public ClassFileImpl context() {
        return this.context;
    }

    @Override
    public Function<Utf8Entry, AttributeMapper<?>> customAttributes() {
        return this.attributeMapper;
    }

    @Override
    public int size() {
        return this.constantPoolCount;
    }

    @Override
    public int flags() {
        return this.flags;
    }

    @Override
    public ClassEntry thisClassEntry() {
        if (this.thisClass == null) {
            this.thisClass = this.readEntry(this.thisClassPos, ClassEntry.class);
        }
        return this.thisClass;
    }

    @Override
    public Optional<ClassEntry> superclassEntry() {
        if (this.superclass == null) {
            this.superclass = Optional.ofNullable(this.readEntryOrNull(this.thisClassPos + 2, ClassEntry.class));
        }
        return this.superclass;
    }

    public int thisClassPos() {
        return this.thisClassPos;
    }

    @Override
    public int classfileLength() {
        return this.classfileLength;
    }

    @Override
    public int bootstrapMethodCount() {
        return this.bootstrapMethodsAttribute().bootstrapMethodsSize();
    }

    @Override
    public BootstrapMethodEntryImpl bootstrapMethodEntry(int index) {
        if (index < 0 || index >= this.bootstrapMethodCount()) {
            throw new ConstantPoolException("Bad BSM index: " + index);
        }
        return this.bsmEntries().get(index);
    }

    private static IllegalArgumentException outOfBoundsError(IndexOutOfBoundsException cause) {
        return new IllegalArgumentException("Reading beyond classfile bounds", cause);
    }

    @Override
    public int readU1(int p) {
        try {
            return this.buffer[p] & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw ClassReaderImpl.outOfBoundsError(e);
        }
    }

    @Override
    public int readU2(int p) {
        try {
            int b1 = this.buffer[p] & 0xFF;
            int b2 = this.buffer[p + 1] & 0xFF;
            return (b1 << 8) + b2;
        }
        catch (IndexOutOfBoundsException e) {
            throw ClassReaderImpl.outOfBoundsError(e);
        }
    }

    @Override
    public int readS1(int p) {
        try {
            return this.buffer[p];
        }
        catch (IndexOutOfBoundsException e) {
            throw ClassReaderImpl.outOfBoundsError(e);
        }
    }

    @Override
    public int readS2(int p) {
        try {
            byte b1 = this.buffer[p];
            int b2 = this.buffer[p + 1] & 0xFF;
            return (b1 << 8) + b2;
        }
        catch (IndexOutOfBoundsException e) {
            throw ClassReaderImpl.outOfBoundsError(e);
        }
    }

    @Override
    public int readInt(int p) {
        try {
            int ch1 = this.buffer[p] & 0xFF;
            int ch2 = this.buffer[p + 1] & 0xFF;
            int ch3 = this.buffer[p + 2] & 0xFF;
            int ch4 = this.buffer[p + 3] & 0xFF;
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        }
        catch (IndexOutOfBoundsException e) {
            throw ClassReaderImpl.outOfBoundsError(e);
        }
    }

    @Override
    public long readLong(int p) {
        try {
            return ((long)this.buffer[p + 0] << 56) + ((long)(this.buffer[p + 1] & 0xFF) << 48) + ((long)(this.buffer[p + 2] & 0xFF) << 40) + ((long)(this.buffer[p + 3] & 0xFF) << 32) + ((long)(this.buffer[p + 4] & 0xFF) << 24) + (long)((this.buffer[p + 5] & 0xFF) << 16) + (long)((this.buffer[p + 6] & 0xFF) << 8) + (long)(this.buffer[p + 7] & 0xFF);
        }
        catch (IndexOutOfBoundsException e) {
            throw ClassReaderImpl.outOfBoundsError(e);
        }
    }

    @Override
    public float readFloat(int p) {
        return Float.intBitsToFloat(this.readInt(p));
    }

    @Override
    public double readDouble(int p) {
        return Double.longBitsToDouble(this.readLong(p));
    }

    @Override
    public byte[] readBytes(int p, int len) {
        try {
            return Arrays.copyOfRange(this.buffer, p, p + len);
        }
        catch (IndexOutOfBoundsException e) {
            throw ClassReaderImpl.outOfBoundsError(e);
        }
    }

    @Override
    public void copyBytesTo(BufWriter buf, int p, int len) {
        try {
            buf.writeBytes(this.buffer, p, len);
        }
        catch (IndexOutOfBoundsException e) {
            throw ClassReaderImpl.outOfBoundsError(e);
        }
    }

    BootstrapMethodsAttribute bootstrapMethodsAttribute() {
        if (this.bootstrapMethodsAttribute == null) {
            this.bootstrapMethodsAttribute = this.containedClass.findAttribute(Attributes.bootstrapMethods()).orElse(new UnboundAttribute.EmptyBootstrapAttribute());
        }
        return this.bootstrapMethodsAttribute;
    }

    List<BootstrapMethodEntryImpl> bsmEntries() {
        if (this.bsmEntries == null) {
            this.bsmEntries = new ArrayList<BootstrapMethodEntryImpl>();
            BootstrapMethodsAttribute attr = this.bootstrapMethodsAttribute();
            List<BootstrapMethodEntry> list = attr.bootstrapMethods();
            if (!list.isEmpty()) {
                for (BootstrapMethodEntry bm : list) {
                    AbstractPoolEntry.MethodHandleEntryImpl handle = (AbstractPoolEntry.MethodHandleEntryImpl)bm.bootstrapMethod();
                    List<LoadableConstantEntry> args = bm.arguments();
                    int hash = BootstrapMethodEntryImpl.computeHashCode(handle, args);
                    this.bsmEntries.add(new BootstrapMethodEntryImpl(this, this.bsmEntries.size(), hash, handle, args));
                }
            }
        }
        return this.bsmEntries;
    }

    void setContainedClass(ClassModel containedClass) {
        this.containedClass = containedClass;
    }

    ClassModel getContainedClass() {
        return this.containedClass;
    }

    boolean writeBootstrapMethods(BufWriterImpl buf) {
        Optional<BootstrapMethodsAttribute> a = this.containedClass.findAttribute(Attributes.bootstrapMethods());
        if (a.isEmpty()) {
            return false;
        }
        ((Util.Writable)((Object)a.get())).writeTo(buf);
        return true;
    }

    void writeConstantPoolEntries(BufWriter buf) {
        this.copyBytesTo(buf, 10, this.metadataStart - 10);
    }

    @Override
    public PoolEntry entryByIndex(int index) {
        return this.entryByIndex(index, PoolEntry.class);
    }

    private static boolean checkTag(int tag, Class<?> cls) {
        Class type = switch (tag) {
            case 1 -> AbstractPoolEntry.Utf8EntryImpl.class;
            case 3 -> AbstractPoolEntry.IntegerEntryImpl.class;
            case 4 -> AbstractPoolEntry.FloatEntryImpl.class;
            case 5 -> AbstractPoolEntry.LongEntryImpl.class;
            case 6 -> AbstractPoolEntry.DoubleEntryImpl.class;
            case 7 -> AbstractPoolEntry.ClassEntryImpl.class;
            case 8 -> AbstractPoolEntry.StringEntryImpl.class;
            case 9 -> AbstractPoolEntry.FieldRefEntryImpl.class;
            case 10 -> AbstractPoolEntry.MethodRefEntryImpl.class;
            case 11 -> AbstractPoolEntry.InterfaceMethodRefEntryImpl.class;
            case 12 -> AbstractPoolEntry.NameAndTypeEntryImpl.class;
            case 15 -> AbstractPoolEntry.MethodHandleEntryImpl.class;
            case 16 -> AbstractPoolEntry.MethodTypeEntryImpl.class;
            case 17 -> AbstractPoolEntry.ConstantDynamicEntryImpl.class;
            case 18 -> AbstractPoolEntry.InvokeDynamicEntryImpl.class;
            case 19 -> AbstractPoolEntry.ModuleEntryImpl.class;
            case 20 -> AbstractPoolEntry.PackageEntryImpl.class;
            default -> null;
        };
        return type != null && cls.isAssignableFrom(type);
    }

    static <T extends PoolEntry> T checkType(PoolEntry e, int index, Class<T> cls) {
        if (cls.isInstance(e)) {
            return (T)((PoolEntry)cls.cast(e));
        }
        throw ClassReaderImpl.checkTypeError(index, cls);
    }

    private static ConstantPoolException checkTypeError(int index, Class<?> cls) {
        return new ConstantPoolException("Not a " + cls.getSimpleName() + " at index: " + index);
    }

    @Override
    public <T extends PoolEntry> T entryByIndex(int index, Class<T> cls) {
        Objects.requireNonNull(cls);
        if (index <= 0 || index >= this.constantPoolCount) {
            throw new ConstantPoolException("Bad CP index: " + index);
        }
        PoolEntry info = this.cp[index];
        if (info == null) {
            int offset = this.cpOffset[index];
            if (offset == 0) {
                throw new ConstantPoolException("Unusable CP index: " + index);
            }
            int tag = this.readU1(offset);
            if (!ClassReaderImpl.checkTag(tag, cls)) {
                throw new ConstantPoolException("Bad tag (" + tag + ") at index (" + index + ") position (" + offset + "), expected " + cls.getSimpleName());
            }
            int q = offset + 1;
            this.cp[index] = info = (switch (tag) {
                case 1 -> new AbstractPoolEntry.Utf8EntryImpl(this, index, this.buffer, q + 2, this.readU2(q));
                case 3 -> new AbstractPoolEntry.IntegerEntryImpl(this, index, this.readInt(q));
                case 4 -> new AbstractPoolEntry.FloatEntryImpl((ConstantPool)this, index, this.readFloat(q));
                case 5 -> new AbstractPoolEntry.LongEntryImpl((ConstantPool)this, index, this.readLong(q));
                case 6 -> new AbstractPoolEntry.DoubleEntryImpl((ConstantPool)this, index, this.readDouble(q));
                case 7 -> new AbstractPoolEntry.ClassEntryImpl((ConstantPool)this, index, this.readEntry(q, AbstractPoolEntry.Utf8EntryImpl.class));
                case 8 -> new AbstractPoolEntry.StringEntryImpl((ConstantPool)this, index, this.readEntry(q, AbstractPoolEntry.Utf8EntryImpl.class));
                case 9 -> new AbstractPoolEntry.FieldRefEntryImpl(this, index, this.readEntry(q, AbstractPoolEntry.ClassEntryImpl.class), this.readEntry(q + 2, AbstractPoolEntry.NameAndTypeEntryImpl.class));
                case 10 -> new AbstractPoolEntry.MethodRefEntryImpl(this, index, this.readEntry(q, AbstractPoolEntry.ClassEntryImpl.class), this.readEntry(q + 2, AbstractPoolEntry.NameAndTypeEntryImpl.class));
                case 11 -> new AbstractPoolEntry.InterfaceMethodRefEntryImpl(this, index, this.readEntry(q, AbstractPoolEntry.ClassEntryImpl.class), this.readEntry(q + 2, AbstractPoolEntry.NameAndTypeEntryImpl.class));
                case 12 -> new AbstractPoolEntry.NameAndTypeEntryImpl(this, index, this.readEntry(q, AbstractPoolEntry.Utf8EntryImpl.class), this.readEntry(q + 2, AbstractPoolEntry.Utf8EntryImpl.class));
                case 15 -> new AbstractPoolEntry.MethodHandleEntryImpl(this, index, this.readU1(q), this.readEntry(q + 1, AbstractPoolEntry.AbstractMemberRefEntry.class));
                case 16 -> new AbstractPoolEntry.MethodTypeEntryImpl((ConstantPool)this, index, this.readEntry(q, AbstractPoolEntry.Utf8EntryImpl.class));
                case 17 -> new AbstractPoolEntry.ConstantDynamicEntryImpl(this, index, this.readU2(q), this.readEntry(q + 2, AbstractPoolEntry.NameAndTypeEntryImpl.class));
                case 18 -> new AbstractPoolEntry.InvokeDynamicEntryImpl(this, index, this.readU2(q), this.readEntry(q + 2, AbstractPoolEntry.NameAndTypeEntryImpl.class));
                case 19 -> new AbstractPoolEntry.ModuleEntryImpl((ConstantPool)this, index, this.readEntry(q, AbstractPoolEntry.Utf8EntryImpl.class));
                case 20 -> new AbstractPoolEntry.PackageEntryImpl((ConstantPool)this, index, this.readEntry(q, AbstractPoolEntry.Utf8EntryImpl.class));
                default -> throw new ConstantPoolException("Bad tag (" + tag + ") at index (" + index + ") position (" + offset + ")");
            });
        }
        return ClassReaderImpl.checkType(info, index, cls);
    }

    public int skipAttributeHolder(int offset) {
        int p = offset;
        int cnt = this.readU2(p);
        p += 2;
        for (int i = 0; i < cnt; ++i) {
            int len = this.readInt(p + 2);
            if (len < 0 || len > this.classfileLength - (p += 6)) {
                throw new IllegalArgumentException("attribute " + this.readEntry(p - 6, Utf8Entry.class).stringValue() + " too big to handle");
            }
            p += len;
        }
        return p;
    }

    @Override
    public PoolEntry readEntry(int pos) {
        return this.entryByIndex(this.readU2(pos));
    }

    @Override
    public <T extends PoolEntry> T readEntry(int pos, Class<T> cls) {
        Objects.requireNonNull(cls);
        return this.entryByIndex(this.readU2(pos), cls);
    }

    @Override
    public PoolEntry readEntryOrNull(int pos) {
        int index = this.readU2(pos);
        if (index == 0) {
            return null;
        }
        return this.entryByIndex(index);
    }

    @Override
    public <T extends PoolEntry> T readEntryOrNull(int offset, Class<T> cls) {
        Objects.requireNonNull(cls);
        int index = this.readU2(offset);
        if (index == 0) {
            return null;
        }
        return this.entryByIndex(index, cls);
    }

    public boolean compare(BufWriterImpl bufWriter, int bufWriterOffset, int classReaderOffset, int length) {
        try {
            return Arrays.equals(bufWriter.elems, bufWriterOffset, bufWriterOffset + length, this.buffer, classReaderOffset, classReaderOffset + length);
        }
        catch (IndexOutOfBoundsException e) {
            throw ClassReaderImpl.outOfBoundsError(e);
        }
    }
}

