/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.ClassFileVersion;
import io.smallrye.classfile.impl.AbstractElement;
import io.smallrye.classfile.impl.DirectClassBuilder;
import io.smallrye.classfile.impl.Util;

public final class ClassFileVersionImpl
extends AbstractElement
implements ClassFileVersion {
    private final int majorVersion;
    private final int minorVersion;

    public ClassFileVersionImpl(int majorVersion, int minorVersion) {
        this.majorVersion = Util.checkU2(majorVersion, "major version");
        this.minorVersion = minorVersion == -1 ? 65535 : (int)Util.checkU2(minorVersion, "minor version");
    }

    @Override
    public int majorVersion() {
        return this.majorVersion;
    }

    @Override
    public int minorVersion() {
        return this.minorVersion;
    }

    @Override
    public void writeTo(DirectClassBuilder builder) {
        builder.setVersion(this.majorVersion, this.minorVersion);
    }

    public String toString() {
        return String.format("ClassFileVersion[majorVersion=%d, minorVersion=%d]", this.majorVersion, this.minorVersion);
    }
}

