/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.Label;
import io.smallrye.classfile.Opcode;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.impl.BlockCodeBuilderImpl;
import java.lang.constant.ClassDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class CatchBuilderImpl
implements CodeBuilder.CatchBuilder {
    final CodeBuilder b;
    final BlockCodeBuilderImpl tryBlock;
    final Label tryCatchEnd;
    BlockCodeBuilderImpl catchBlock;

    public CatchBuilderImpl(CodeBuilder b, BlockCodeBuilderImpl tryBlock, Label tryCatchEnd) {
        this.b = b;
        this.tryBlock = tryBlock;
        this.tryCatchEnd = tryCatchEnd;
    }

    @Override
    public CodeBuilder.CatchBuilder catching(ClassDesc exceptionType, Consumer<CodeBuilder.BlockCodeBuilder> catchHandler) {
        return this.catchingMulti(exceptionType == null ? List.of() : List.of(exceptionType), catchHandler);
    }

    @Override
    public CodeBuilder.CatchBuilder catchingMulti(List<ClassDesc> exceptionTypes, Consumer<CodeBuilder.BlockCodeBuilder> catchHandler) {
        Objects.requireNonNull(exceptionTypes);
        Objects.requireNonNull(catchHandler);
        ArrayList<ClassEntry> entries = new ArrayList<ClassEntry>(Math.max(1, exceptionTypes.size()));
        if (exceptionTypes.isEmpty()) {
            entries.add(null);
        } else {
            for (ClassDesc exceptionType : exceptionTypes) {
                ClassEntry entry = this.b.constantPool().classEntry(exceptionType);
                entries.add(entry);
            }
        }
        if (this.catchBlock == null && this.tryBlock.reachable()) {
            this.b.branch(Opcode.GOTO, this.tryCatchEnd);
        }
        if (this.catchBlock != null) {
            this.catchBlock.end();
            if (this.catchBlock.reachable()) {
                this.b.branch(Opcode.GOTO, this.tryCatchEnd);
            }
        }
        this.catchBlock = new BlockCodeBuilderImpl(this.b, this.tryCatchEnd);
        Label tryStart = this.tryBlock.startLabel();
        Label tryEnd = this.tryBlock.endLabel();
        for (ClassEntry entry : entries) {
            this.catchBlock.exceptionCatch(tryStart, tryEnd, this.catchBlock.startLabel(), entry);
        }
        this.catchBlock.start();
        catchHandler.accept(this.catchBlock);
        return this;
    }

    @Override
    public void catchingAll(Consumer<CodeBuilder.BlockCodeBuilder> catchAllHandler) {
        this.catchingMulti(List.of(), catchAllHandler);
    }

    public void finish() {
        if (this.catchBlock != null) {
            this.catchBlock.end();
        }
        this.b.labelBinding(this.tryCatchEnd);
    }
}

