/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.CodeElement;
import io.smallrye.classfile.CodeModel;
import io.smallrye.classfile.Label;
import io.smallrye.classfile.MethodModel;
import io.smallrye.classfile.TypeKind;
import io.smallrye.classfile.constantpool.ConstantPoolBuilder;
import io.smallrye.classfile.impl.AbstractUnboundModel;
import io.smallrye.classfile.impl.ClassFileImpl;
import io.smallrye.classfile.impl.DirectMethodBuilder;
import io.smallrye.classfile.impl.LabelImpl;
import io.smallrye.classfile.impl.MethodInfo;
import io.smallrye.classfile.impl.SplitConstantPool;
import io.smallrye.classfile.impl.TerminalCodeBuilder;
import io.smallrye.classfile.impl.Util;
import io.smallrye.classfile.instruction.ExceptionCatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public final class BufferedCodeBuilder
implements TerminalCodeBuilder {
    private final SplitConstantPool constantPool;
    private final ClassFileImpl context;
    private final List<CodeElement> elements = new ArrayList<CodeElement>();
    private final LabelImpl startLabel;
    private final LabelImpl endLabel;
    private final MethodInfo methodInfo;
    private boolean finished;
    private int maxLocals;

    public BufferedCodeBuilder(MethodInfo methodInfo, SplitConstantPool constantPool, ClassFileImpl context, CodeModel original) {
        this.constantPool = constantPool;
        this.context = context;
        this.startLabel = new LabelImpl(this, -1);
        this.endLabel = new LabelImpl(this, -1);
        this.methodInfo = methodInfo;
        this.maxLocals = TerminalCodeBuilder.setupTopLocal(methodInfo, original);
        this.elements.add(this.startLabel);
    }

    @Override
    public Label newLabel() {
        return new LabelImpl(this, -1);
    }

    @Override
    public Label startLabel() {
        return this.startLabel;
    }

    @Override
    public Label endLabel() {
        return this.endLabel;
    }

    @Override
    public int receiverSlot() {
        return this.methodInfo.receiverSlot();
    }

    @Override
    public int parameterSlot(int paramNo) {
        return this.methodInfo.parameterSlot(paramNo);
    }

    @Override
    public int curTopLocal() {
        return this.maxLocals;
    }

    @Override
    public int allocateLocal(TypeKind typeKind) {
        int retVal = this.maxLocals;
        this.maxLocals += typeKind.slotSize();
        return retVal;
    }

    @Override
    public Label getLabel(int bci) {
        throw new UnsupportedOperationException("Lookup by BCI not supported by BufferedCodeBuilder");
    }

    @Override
    public int labelToBci(Label label) {
        throw new UnsupportedOperationException("Label mapping not supported by BufferedCodeBuilder");
    }

    @Override
    public void setLabelTarget(Label label, int bci) {
        throw new UnsupportedOperationException("Label mapping not supported by BufferedCodeBuilder");
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.constantPool;
    }

    @Override
    public CodeBuilder with(CodeElement element) {
        if (this.finished) {
            throw new IllegalStateException("Can't add elements after traversal");
        }
        this.elements.add(Objects.requireNonNull(element));
        return this;
    }

    public String toString() {
        return String.format("CodeModel[id=%d]", System.identityHashCode(this));
    }

    public BufferedCodeBuilder run(Consumer<? super CodeBuilder> handler) {
        handler.accept(this);
        return this;
    }

    public CodeModel toModel() {
        if (!this.finished) {
            this.elements.add(this.endLabel);
            this.finished = true;
        }
        return new Model();
    }

    public final class Model
    extends AbstractUnboundModel<CodeElement>
    implements CodeModel {
        private Model() {
            super(BufferedCodeBuilder.this.elements);
        }

        @Override
        public List<ExceptionCatch> exceptionHandlers() {
            return this.elements.stream().mapMulti((x, sink) -> {
                if (x instanceof ExceptionCatch) {
                    ExceptionCatch ec = (ExceptionCatch)x;
                    sink.accept(ec);
                }
            }).toList();
        }

        int curTopLocal() {
            return BufferedCodeBuilder.this.curTopLocal();
        }

        @Override
        public Optional<MethodModel> parent() {
            return Optional.empty();
        }

        @Override
        public void writeTo(DirectMethodBuilder builder) {
            builder.withCode(Util.writingAll(this));
        }

        public String toString() {
            return String.format("CodeModel[id=%s]", Integer.toHexString(System.identityHashCode(this)));
        }
    }
}

