/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.CodeElement;
import io.smallrye.classfile.Instruction;
import io.smallrye.classfile.Label;
import io.smallrye.classfile.TypeKind;
import io.smallrye.classfile.impl.BytecodeHelpers;
import io.smallrye.classfile.impl.NonterminalCodeBuilder;
import io.smallrye.classfile.instruction.LabelTarget;
import java.util.Objects;

public final class BlockCodeBuilderImpl
extends NonterminalCodeBuilder
implements CodeBuilder.BlockCodeBuilder {
    private final Label startLabel;
    private final Label endLabel;
    private final Label breakLabel;
    private boolean reachable = true;
    private boolean hasInstructions = false;
    private int topLocal;
    private int terminalMaxLocals;

    public BlockCodeBuilderImpl(CodeBuilder parent, Label breakLabel) {
        super(parent);
        this.startLabel = parent.newLabel();
        this.endLabel = parent.newLabel();
        this.breakLabel = Objects.requireNonNull(breakLabel);
    }

    public void start() {
        this.topLocal = this.topLocal(this.parent);
        this.terminalMaxLocals = this.terminal.curTopLocal();
        this.parent.with((LabelTarget)((Object)this.startLabel));
    }

    public void end() {
        this.parent.with((LabelTarget)((Object)this.endLabel));
        if (this.terminalMaxLocals != this.terminal.curTopLocal()) {
            throw new IllegalStateException("Interference in local variable slot management");
        }
    }

    public boolean reachable() {
        return this.reachable;
    }

    public boolean isEmpty() {
        return !this.hasInstructions;
    }

    private int topLocal(CodeBuilder parent) {
        if (parent instanceof BlockCodeBuilderImpl) {
            BlockCodeBuilderImpl bcb = (BlockCodeBuilderImpl)parent;
            return bcb.topLocal;
        }
        return BlockCodeBuilderImpl.findTerminal(parent).curTopLocal();
    }

    @Override
    public CodeBuilder with(CodeElement element) {
        this.parent.with(Objects.requireNonNull(element));
        this.hasInstructions |= element instanceof Instruction;
        if (this.reachable) {
            Instruction i;
            if (element instanceof Instruction && BytecodeHelpers.isUnconditionalBranch((i = (Instruction)element).opcode())) {
                this.reachable = false;
            }
        } else if (element instanceof LabelTarget) {
            this.reachable = true;
        }
        return this;
    }

    @Override
    public Label startLabel() {
        return this.startLabel;
    }

    @Override
    public Label endLabel() {
        return this.endLabel;
    }

    @Override
    public int allocateLocal(TypeKind typeKind) {
        int retVal = this.topLocal;
        this.topLocal += typeKind.slotSize();
        return retVal;
    }

    @Override
    public Label breakLabel() {
        return this.breakLabel;
    }
}

