/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.AccessFlags;
import io.smallrye.classfile.extras.reflect.AccessFlag;
import io.smallrye.classfile.impl.AbstractElement;
import io.smallrye.classfile.impl.DirectClassBuilder;
import io.smallrye.classfile.impl.DirectFieldBuilder;
import io.smallrye.classfile.impl.DirectMethodBuilder;
import io.smallrye.classfile.impl.Util;
import java.util.Set;

public final class AccessFlagsImpl
extends AbstractElement
implements AccessFlags {
    private final AccessFlag.Location location;
    private final int flagsMask;
    private Set<AccessFlag> flags;

    public AccessFlagsImpl(AccessFlag.Location location, AccessFlag ... flags) {
        this.location = location;
        this.flagsMask = Util.flagsToBits(location, flags);
        this.flags = Set.of(flags);
    }

    public AccessFlagsImpl(AccessFlag.Location location, int mask) {
        this.location = location;
        this.flagsMask = Util.checkFlags(mask);
    }

    @Override
    public int flagsMask() {
        return this.flagsMask;
    }

    @Override
    public Set<AccessFlag> flags() {
        if (this.flags == null) {
            this.flags = AccessFlag.maskToAccessFlags(this.flagsMask, this.location);
        }
        return this.flags;
    }

    @Override
    public void writeTo(DirectClassBuilder builder) {
        builder.setFlags(this.flagsMask);
    }

    @Override
    public void writeTo(DirectMethodBuilder builder) {
        builder.setFlags(this.flagsMask);
    }

    @Override
    public void writeTo(DirectFieldBuilder builder) {
        builder.setFlags(this.flagsMask);
    }

    @Override
    public AccessFlag.Location location() {
        return this.location;
    }

    @Override
    public boolean has(AccessFlag flag) {
        return Util.has(this.location, this.flagsMask, flag);
    }

    public String toString() {
        return String.format("AccessFlags[flags=%d]", this.flagsMask);
    }
}

