/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.ConstantDynamicEntry;
import io.smallrye.classfile.constantpool.ConstantPool;
import io.smallrye.classfile.constantpool.ConstantPoolBuilder;
import io.smallrye.classfile.constantpool.ConstantPoolException;
import io.smallrye.classfile.constantpool.DoubleEntry;
import io.smallrye.classfile.constantpool.FieldRefEntry;
import io.smallrye.classfile.constantpool.FloatEntry;
import io.smallrye.classfile.constantpool.IntegerEntry;
import io.smallrye.classfile.constantpool.InterfaceMethodRefEntry;
import io.smallrye.classfile.constantpool.InvokeDynamicEntry;
import io.smallrye.classfile.constantpool.LongEntry;
import io.smallrye.classfile.constantpool.MemberRefEntry;
import io.smallrye.classfile.constantpool.MethodHandleEntry;
import io.smallrye.classfile.constantpool.MethodRefEntry;
import io.smallrye.classfile.constantpool.MethodTypeEntry;
import io.smallrye.classfile.constantpool.ModuleEntry;
import io.smallrye.classfile.constantpool.NameAndTypeEntry;
import io.smallrye.classfile.constantpool.PackageEntry;
import io.smallrye.classfile.constantpool.PoolEntry;
import io.smallrye.classfile.constantpool.StringEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.extras.constant.ExtraClassDesc;
import io.smallrye.classfile.extras.constant.ModuleDesc;
import io.smallrye.classfile.extras.constant.PackageDesc;
import io.smallrye.classfile.impl.BackportUtil;
import io.smallrye.classfile.impl.BootstrapMethodEntryImpl;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.SplitConstantPool;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.TypeDescriptor;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AbstractPoolEntry {
    private static final int TAG_SMEAR = 331657937;
    static final int NON_ZERO = 0x40000000;
    final ConstantPool constantPool;
    private final int index;
    private final int hash;

    public static int hash1(int tag, int x1) {
        return tag * 331657937 + x1 | 0x40000000;
    }

    public static int hash2(int tag, int x1, int x2) {
        return tag * 331657937 + x1 + 31 * x2 | 0x40000000;
    }

    public static int hashString(int stringHash) {
        return stringHash | 0x40000000;
    }

    static int hashClassFromUtf8(boolean isArray, Utf8EntryImpl content) {
        int hash = content.contentHash();
        return AbstractPoolEntry.hashClassFromDescriptor(isArray ? hash : Util.descriptorStringHash(content.length(), hash));
    }

    static int hashClassFromDescriptor(int descriptorHash) {
        return AbstractPoolEntry.hash1(7, descriptorHash);
    }

    public static <T extends PoolEntry> T maybeClone(ConstantPoolBuilder cp, T entry) {
        if (cp.canWriteDirect(entry.constantPool())) {
            return entry;
        }
        return (T)((AbstractPoolEntry)((Object)entry)).clone(cp);
    }

    private AbstractPoolEntry(ConstantPool constantPool, int index, int hash) {
        this.index = index;
        this.hash = hash;
        this.constantPool = constantPool;
    }

    public ConstantPool constantPool() {
        return this.constantPool;
    }

    public int index() {
        return this.index;
    }

    public int hashCode() {
        return this.hash;
    }

    public abstract int tag();

    public int width() {
        return 1;
    }

    abstract void writeTo(BufWriterImpl var1);

    abstract PoolEntry clone(ConstantPoolBuilder var1);

    public static final class Utf8EntryImpl
    extends AbstractPoolEntry
    implements Utf8Entry {
        private State state;
        private final byte[] rawBytes;
        private final int offset;
        private final int rawLen;
        private int contentHash;
        private int charLen;
        private char[] chars;
        private String stringValue;
        TypeDescriptor typeSym;

        Utf8EntryImpl(ConstantPool cpm, int index, byte[] rawBytes, int offset, int rawLen) {
            super(cpm, index, 0);
            this.rawBytes = rawBytes;
            this.offset = offset;
            this.rawLen = rawLen;
            this.state = State.RAW;
        }

        Utf8EntryImpl(ConstantPool cpm, int index, String s) {
            this(cpm, index, s, s.hashCode());
        }

        Utf8EntryImpl(ConstantPool cpm, int index, String s, int contentHash) {
            super(cpm, index, 0);
            this.rawBytes = null;
            this.offset = 0;
            this.rawLen = 0;
            this.state = State.STRING;
            this.stringValue = s;
            this.charLen = s.length();
            this.contentHash = contentHash;
        }

        Utf8EntryImpl(ConstantPool cpm, int index, Utf8EntryImpl u) {
            super(cpm, index, 0);
            this.rawBytes = u.rawBytes;
            this.offset = u.offset;
            this.rawLen = u.rawLen;
            this.state = u.state;
            this.contentHash = u.contentHash;
            this.charLen = u.charLen;
            this.chars = u.chars;
            this.stringValue = u.stringValue;
            this.typeSym = u.typeSym;
        }

        @Override
        public int tag() {
            return 1;
        }

        private void inflate() {
            int singleBytes = BackportUtil.JLA.countPositives(this.rawBytes, this.offset, this.rawLen);
            int hash = BackportUtil.ArraysSupport.hashCodeOfUnsigned(this.rawBytes, this.offset, singleBytes, 0);
            if (singleBytes == this.rawLen) {
                this.contentHash = hash;
                this.charLen = this.rawLen;
                this.state = State.BYTE;
            } else {
                this.inflateNonAscii(singleBytes, hash);
            }
        }

        private void inflateNonAscii(int singleBytes, int hash) {
            char[] chararr = new char[this.rawLen];
            int chararr_count = singleBytes;
            BackportUtil.JLA.inflateBytesToChars(this.rawBytes, this.offset, chararr, 0, singleBytes);
            int px = this.offset + singleBytes;
            int utfend = this.offset + this.rawLen;
            block5: while (px < utfend) {
                int c = this.rawBytes[px] & 0xFF;
                switch (c >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        ++px;
                        chararr[chararr_count++] = (char)c;
                        hash = 31 * hash + c;
                        continue block5;
                    }
                    case 12: 
                    case 13: {
                        if ((px += 2) > utfend) {
                            throw this.malformedInput(utfend);
                        }
                        byte char2 = this.rawBytes[px - 1];
                        if ((char2 & 0xC0) != 128) {
                            throw this.malformedInput(px);
                        }
                        char v = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                        chararr[chararr_count++] = v;
                        hash = 31 * hash + v;
                        continue block5;
                    }
                    case 14: {
                        if ((px += 3) > utfend) {
                            throw this.malformedInput(utfend);
                        }
                        byte char2 = this.rawBytes[px - 2];
                        byte char3 = this.rawBytes[px - 1];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw this.malformedInput(px - 1);
                        }
                        char v = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                        chararr[chararr_count++] = v;
                        hash = 31 * hash + v;
                        continue block5;
                    }
                }
                throw this.malformedInput(px);
            }
            this.contentHash = hash;
            this.charLen = chararr_count;
            this.chars = chararr;
            this.state = State.CHAR;
        }

        private ConstantPoolException malformedInput(int px) {
            return new ConstantPoolException("#%d: malformed modified UTF8 around byte %d".formatted(this.index(), px));
        }

        @Override
        public Utf8EntryImpl clone(ConstantPoolBuilder cp) {
            Utf8EntryImpl ret = this.state == State.STRING && this.rawBytes == null ? (Utf8EntryImpl)cp.utf8Entry(this.stringValue) : ((SplitConstantPool)cp).maybeCloneUtf8Entry(this);
            TypeDescriptor mySym = this.typeSym;
            if (ret.typeSym == null && mySym != null) {
                ret.typeSym = mySym;
            }
            return ret;
        }

        @Override
        public int hashCode() {
            return Utf8EntryImpl.hashString(this.contentHash());
        }

        int contentHash() {
            if (this.state == State.RAW) {
                this.inflate();
            }
            return this.contentHash;
        }

        @Override
        public String toString() {
            if (this.state == State.RAW) {
                this.inflate();
            }
            if (this.state != State.STRING) {
                this.stringValue = this.chars != null ? new String(this.chars, 0, this.charLen) : new String(this.rawBytes, this.offset, this.charLen, StandardCharsets.ISO_8859_1);
                this.state = State.STRING;
            }
            return this.stringValue;
        }

        @Override
        public String stringValue() {
            return this.toString();
        }

        @Override
        public ConstantDesc constantValue() {
            return this.stringValue();
        }

        @Override
        public int length() {
            if (this.state == State.RAW) {
                this.inflate();
            }
            return this.charLen;
        }

        @Override
        public char charAt(int index) {
            if (this.state == State.STRING) {
                return this.stringValue.charAt(index);
            }
            if (this.state == State.RAW) {
                this.inflate();
            }
            return this.chars != null ? this.chars[index] : (char)this.rawBytes[index + this.offset];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Utf8EntryImpl) {
                Utf8EntryImpl u = (Utf8EntryImpl)o;
                return this.equalsUtf8(u);
            }
            return false;
        }

        public boolean equalsUtf8(Utf8EntryImpl u) {
            if (this.hashCode() != u.hashCode() || this.length() != u.length()) {
                return false;
            }
            if (this.rawBytes != null && u.rawBytes != null) {
                return Arrays.equals(this.rawBytes, this.offset, this.offset + this.rawLen, u.rawBytes, u.offset, u.offset + u.rawLen);
            }
            if (this.state == State.STRING && u.state == State.STRING) {
                return this.stringValue.equals(u.stringValue);
            }
            return this.stringValue().equals(u.stringValue());
        }

        @Override
        public boolean equalsString(String s) {
            if (this.state == State.RAW) {
                this.inflate();
            }
            switch (this.state.ordinal()) {
                case 3: {
                    return this.stringValue.equals(Objects.requireNonNull(s));
                }
                case 2: {
                    if (this.charLen != s.length() || this.contentHash != s.hashCode()) {
                        return false;
                    }
                    for (int i = 0; i < this.charLen; ++i) {
                        if (this.chars[i] == s.charAt(i)) continue;
                        return false;
                    }
                    this.stringValue = s;
                    this.state = State.STRING;
                    return true;
                }
                case 1: {
                    if (this.rawLen != s.length() || this.contentHash != s.hashCode()) {
                        return false;
                    }
                    for (int i = 0; i < this.rawLen; ++i) {
                        if (this.rawBytes[this.offset + i] == s.charAt(i)) continue;
                        return false;
                    }
                    this.stringValue = s;
                    this.state = State.STRING;
                    return true;
                }
            }
            throw new IllegalStateException("cannot reach here");
        }

        @Override
        void writeTo(BufWriterImpl pool) {
            if (this.rawBytes != null) {
                pool.writeU1U2(1, this.rawLen);
                pool.writeBytes(this.rawBytes, this.offset, this.rawLen);
            } else {
                pool.writeUtfEntry(this.stringValue);
            }
        }

        public ClassDesc fieldTypeSymbol() {
            TypeDescriptor typeDescriptor = this.typeSym;
            if (typeDescriptor instanceof ClassDesc) {
                ClassDesc cd = (ClassDesc)typeDescriptor;
                return cd;
            }
            ClassDesc ret = ClassDesc.ofDescriptor(this.stringValue());
            this.typeSym = ret;
            return ret;
        }

        public MethodTypeDesc methodTypeSymbol() {
            TypeDescriptor typeDescriptor = this.typeSym;
            if (typeDescriptor instanceof MethodTypeDesc) {
                MethodTypeDesc mtd = (MethodTypeDesc)typeDescriptor;
                return mtd;
            }
            MethodTypeDesc ret = MethodTypeDesc.ofDescriptor(this.stringValue());
            this.typeSym = ret;
            return ret;
        }

        @Override
        public boolean isFieldType(ClassDesc desc) {
            boolean ret;
            TypeDescriptor sym = this.typeSym;
            if (sym != null) {
                ClassDesc cd;
                return sym instanceof ClassDesc && (cd = (ClassDesc)sym).equals(desc);
            }
            boolean bl = ret = this.state == State.RAW ? this.rawEqualsSym(desc) : this.equalsString(desc.descriptorString());
            if (ret) {
                this.typeSym = desc;
            }
            return ret;
        }

        private boolean rawEqualsSym(ClassDesc desc) {
            int len = this.rawLen;
            if (len < 1) {
                return false;
            }
            byte c = this.rawBytes[this.offset];
            if (len == 1) {
                return desc.isPrimitive() && desc.descriptorString().charAt(0) == c;
            }
            if (c == 76) {
                return desc.isClassOrInterface() && this.equalsString(desc.descriptorString());
            }
            if (c == 91) {
                return desc.isArray() && this.equalsString(desc.descriptorString());
            }
            return false;
        }

        boolean mayBeArrayDescriptor() {
            if (this.state == State.RAW) {
                return this.rawLen > 0 && this.rawBytes[this.offset] == 91;
            }
            return this.charLen > 0 && this.charAt(0) == '[';
        }

        @Override
        public boolean isMethodType(MethodTypeDesc desc) {
            boolean ret;
            TypeDescriptor sym = this.typeSym;
            if (sym != null) {
                MethodTypeDesc mtd;
                return sym instanceof MethodTypeDesc && (mtd = (MethodTypeDesc)sym).equals(desc);
            }
            boolean bl = ret = this.state == State.RAW ? this.rawEqualsSym(desc) : this.equalsString(desc.descriptorString());
            if (ret) {
                this.typeSym = desc;
            }
            return ret;
        }

        private boolean rawEqualsSym(MethodTypeDesc desc) {
            if (this.rawLen < 3) {
                return false;
            }
            byte[] bytes = this.rawBytes;
            int index = this.offset;
            int c = bytes[index] | bytes[index + 1] << 8;
            if (desc.parameterCount() == 0 != (c == 10536)) {
                return false;
            }
            return (c & 0xFF) == 40 && this.equalsString(desc.descriptorString());
        }

        static enum State {
            RAW,
            BYTE,
            CHAR,
            STRING;

        }
    }

    public static final class DoubleEntryImpl
    extends AbstractPoolEntry
    implements DoubleEntry {
        private final double val;

        DoubleEntryImpl(ConstantPool cpm, int index, double d) {
            super(cpm, index, DoubleEntryImpl.hash1(6, Double.hashCode(d)));
            this.val = d;
        }

        @Override
        public int tag() {
            return 6;
        }

        @Override
        public int width() {
            return 2;
        }

        @Override
        void writeTo(BufWriterImpl pool) {
            pool.writeU1(6);
            pool.writeDouble(this.val);
        }

        @Override
        public DoubleEntry clone(ConstantPoolBuilder cp) {
            return cp.doubleEntry(this.val);
        }

        @Override
        public double doubleValue() {
            return this.val;
        }

        @Override
        public ConstantDesc constantValue() {
            return Double.valueOf(this.val);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof DoubleEntryImpl) {
                DoubleEntryImpl e = (DoubleEntryImpl)o;
                return this.doubleValue() == e.doubleValue();
            }
            return false;
        }
    }

    public static final class LongEntryImpl
    extends AbstractPoolEntry
    implements LongEntry {
        private final long val;

        LongEntryImpl(ConstantPool cpm, int index, long l) {
            super(cpm, index, LongEntryImpl.hash1(5, Long.hashCode(l)));
            this.val = l;
        }

        @Override
        public int tag() {
            return 5;
        }

        @Override
        public int width() {
            return 2;
        }

        @Override
        void writeTo(BufWriterImpl pool) {
            pool.writeU1(5);
            pool.writeLong(this.val);
        }

        @Override
        public LongEntry clone(ConstantPoolBuilder cp) {
            return cp.longEntry(this.val);
        }

        @Override
        public long longValue() {
            return this.val;
        }

        @Override
        public ConstantDesc constantValue() {
            return Long.valueOf(this.val);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof LongEntryImpl) {
                LongEntryImpl e = (LongEntryImpl)o;
                return this.longValue() == e.longValue();
            }
            return false;
        }
    }

    public static final class FloatEntryImpl
    extends AbstractPoolEntry
    implements FloatEntry {
        private final float val;

        FloatEntryImpl(ConstantPool cpm, int index, float f) {
            super(cpm, index, FloatEntryImpl.hash1(4, Float.hashCode(f)));
            this.val = f;
        }

        @Override
        public int tag() {
            return 4;
        }

        @Override
        void writeTo(BufWriterImpl pool) {
            pool.writeU1(4);
            pool.writeFloat(this.val);
        }

        @Override
        public FloatEntry clone(ConstantPoolBuilder cp) {
            return cp.floatEntry(this.val);
        }

        @Override
        public float floatValue() {
            return this.val;
        }

        @Override
        public ConstantDesc constantValue() {
            return Float.valueOf(this.val);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof FloatEntryImpl) {
                FloatEntryImpl e = (FloatEntryImpl)o;
                return this.floatValue() == e.floatValue();
            }
            return false;
        }
    }

    public static final class IntegerEntryImpl
    extends AbstractPoolEntry
    implements IntegerEntry {
        private final int val;

        IntegerEntryImpl(ConstantPool cpm, int index, int i) {
            super(cpm, index, IntegerEntryImpl.hash1(3, Integer.hashCode(i)));
            this.val = i;
        }

        @Override
        public int tag() {
            return 3;
        }

        @Override
        void writeTo(BufWriterImpl pool) {
            pool.writeU1(3);
            pool.writeInt(this.val);
        }

        @Override
        public IntegerEntry clone(ConstantPoolBuilder cp) {
            return cp.intEntry(this.val);
        }

        @Override
        public int intValue() {
            return this.val;
        }

        @Override
        public ConstantDesc constantValue() {
            return Integer.valueOf(this.val);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof IntegerEntryImpl) {
                IntegerEntryImpl e = (IntegerEntryImpl)o;
                return this.intValue() == e.intValue();
            }
            return false;
        }
    }

    public static final class StringEntryImpl
    extends AbstractRefEntry<Utf8EntryImpl>
    implements StringEntry {
        StringEntryImpl(ConstantPool cpm, int index, Utf8EntryImpl utf8) {
            super(cpm, 8, index, utf8);
        }

        @Override
        public int tag() {
            return 8;
        }

        @Override
        public Utf8EntryImpl utf8() {
            return (Utf8EntryImpl)this.ref1;
        }

        @Override
        public String stringValue() {
            return ((Utf8EntryImpl)this.ref1).toString();
        }

        @Override
        public boolean equalsString(String value) {
            return ((Utf8EntryImpl)this.ref1).equalsString(value);
        }

        @Override
        public ConstantDesc constantValue() {
            return this.stringValue();
        }

        @Override
        public StringEntry clone(ConstantPoolBuilder cp) {
            return cp.stringEntry((Utf8Entry)this.ref1);
        }

        @Override
        public String toString() {
            return this.tag() + " \"" + this.stringValue() + "\"";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof StringEntryImpl) {
                StringEntryImpl s = (StringEntryImpl)o;
                return this.utf8().equals(s.utf8());
            }
            return false;
        }
    }

    public static final class MethodTypeEntryImpl
    extends AbstractRefEntry<Utf8EntryImpl>
    implements MethodTypeEntry {
        MethodTypeEntryImpl(ConstantPool cpm, int index, Utf8EntryImpl descriptor) {
            super(cpm, 16, index, descriptor);
        }

        @Override
        public int tag() {
            return 16;
        }

        @Override
        public Utf8Entry descriptor() {
            return (Utf8Entry)this.ref1;
        }

        @Override
        public MethodTypeEntry clone(ConstantPoolBuilder cp) {
            return cp.methodTypeEntry((Utf8Entry)this.ref1);
        }

        @Override
        public MethodTypeDesc asSymbol() {
            return ((Utf8EntryImpl)this.ref1).methodTypeSymbol();
        }

        @Override
        public boolean matches(MethodTypeDesc desc) {
            return ((Utf8EntryImpl)this.ref1).isMethodType(desc);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof MethodTypeEntryImpl) {
                MethodTypeEntryImpl m = (MethodTypeEntryImpl)o;
                return this.descriptor().equals(m.descriptor());
            }
            return false;
        }
    }

    public static final class MethodHandleEntryImpl
    extends AbstractPoolEntry
    implements MethodHandleEntry {
        private final int refKind;
        private final AbstractMemberRefEntry reference;
        public DirectMethodHandleDesc sym;

        MethodHandleEntryImpl(ConstantPool cpm, int index, int hash, int refKind, AbstractMemberRefEntry reference) {
            super(cpm, index, hash);
            this.refKind = refKind;
            this.reference = reference;
        }

        MethodHandleEntryImpl(ConstantPool cpm, int index, int refKind, AbstractMemberRefEntry reference) {
            super(cpm, index, MethodHandleEntryImpl.hash2(15, refKind, reference.index()));
            this.refKind = refKind;
            this.reference = reference;
        }

        @Override
        public int tag() {
            return 15;
        }

        @Override
        public int kind() {
            return this.refKind;
        }

        @Override
        public AbstractMemberRefEntry reference() {
            return this.reference;
        }

        @Override
        public DirectMethodHandleDesc asSymbol() {
            DirectMethodHandleDesc cache = this.sym;
            if (cache != null) {
                return cache;
            }
            return this.computeSymbol();
        }

        private DirectMethodHandleDesc computeSymbol() {
            this.sym = MethodHandleDesc.of(DirectMethodHandleDesc.Kind.valueOf(this.kind(), this.reference() instanceof InterfaceMethodRefEntry), this.reference().owner().asSymbol(), this.reference().nameAndType().name().stringValue(), this.reference().nameAndType().type().stringValue());
            return this.sym;
        }

        @Override
        void writeTo(BufWriterImpl pool) {
            pool.writeU1U1U2(15, this.refKind, this.reference.index());
        }

        @Override
        public MethodHandleEntry clone(ConstantPoolBuilder cp) {
            MethodHandleEntryImpl ret = (MethodHandleEntryImpl)cp.methodHandleEntry(this.refKind, this.reference);
            DirectMethodHandleDesc mySym = this.sym;
            if (ret.sym == null && mySym != null) {
                ret.sym = mySym;
            }
            return ret;
        }

        public String toString() {
            return this.tag() + " " + this.kind() + ":" + this.reference().owner().asInternalName() + "." + this.reference().nameAndType().name().stringValue() + "-" + this.reference().nameAndType().type().stringValue();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof MethodHandleEntryImpl) {
                MethodHandleEntryImpl m = (MethodHandleEntryImpl)o;
                return this.kind() == m.kind() && this.reference.equals(m.reference());
            }
            return false;
        }
    }

    public static final class ConstantDynamicEntryImpl
    extends AbstractDynamicConstantPoolEntry
    implements ConstantDynamicEntry {
        public DynamicConstantDesc<?> sym;

        ConstantDynamicEntryImpl(ConstantPool cpm, int index, int hash, BootstrapMethodEntryImpl bootstrapMethod, NameAndTypeEntryImpl nameAndType) {
            super(cpm, index, hash, bootstrapMethod, nameAndType);
        }

        ConstantDynamicEntryImpl(ConstantPool cpm, int index, int bsmIndex, NameAndTypeEntryImpl nameAndType) {
            super(cpm, index, ConstantDynamicEntryImpl.hash2(17, bsmIndex, nameAndType.index()), bsmIndex, nameAndType);
        }

        @Override
        public int tag() {
            return 17;
        }

        @Override
        public ConstantDynamicEntry clone(ConstantPoolBuilder cp) {
            ConstantDynamicEntryImpl ret = (ConstantDynamicEntryImpl)cp.constantDynamicEntry(this.bootstrap(), this.nameAndType());
            DynamicConstantDesc<?> mySym = this.sym;
            if (ret.sym == null && mySym != null) {
                ret.sym = mySym;
            }
            return ret;
        }

        @Override
        public DynamicConstantDesc<?> asSymbol() {
            DynamicConstantDesc<?> cache = this.sym;
            if (cache != null) {
                return cache;
            }
            this.sym = ConstantDynamicEntry.super.asSymbol();
            return this.sym;
        }
    }

    public static final class InvokeDynamicEntryImpl
    extends AbstractDynamicConstantPoolEntry
    implements InvokeDynamicEntry {
        public DynamicCallSiteDesc sym;

        InvokeDynamicEntryImpl(ConstantPool cpm, int index, int hash, BootstrapMethodEntryImpl bootstrapMethod, NameAndTypeEntryImpl nameAndType) {
            super(cpm, index, hash, bootstrapMethod, nameAndType);
        }

        InvokeDynamicEntryImpl(ConstantPool cpm, int index, int bsmIndex, NameAndTypeEntryImpl nameAndType) {
            super(cpm, index, InvokeDynamicEntryImpl.hash2(18, bsmIndex, nameAndType.index()), bsmIndex, nameAndType);
        }

        @Override
        public int tag() {
            return 18;
        }

        @Override
        public InvokeDynamicEntry clone(ConstantPoolBuilder cp) {
            InvokeDynamicEntryImpl ret = (InvokeDynamicEntryImpl)cp.invokeDynamicEntry(this.bootstrap(), this.nameAndType());
            DynamicCallSiteDesc mySym = this.sym;
            if (ret.sym == null && mySym != null) {
                ret.sym = mySym;
            }
            return ret;
        }

        @Override
        public DynamicCallSiteDesc asSymbol() {
            DynamicCallSiteDesc cache = this.sym;
            if (cache != null) {
                return cache;
            }
            this.sym = InvokeDynamicEntry.super.asSymbol();
            return this.sym;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class AbstractDynamicConstantPoolEntry
    extends AbstractPoolEntry {
        private final int bsmIndex;
        private BootstrapMethodEntryImpl bootstrapMethod;
        private final NameAndTypeEntryImpl nameAndType;

        AbstractDynamicConstantPoolEntry(ConstantPool cpm, int index, int hash, BootstrapMethodEntryImpl bootstrapMethod, NameAndTypeEntryImpl nameAndType) {
            super(cpm, index, hash);
            this.bsmIndex = bootstrapMethod.bsmIndex();
            this.bootstrapMethod = bootstrapMethod;
            this.nameAndType = nameAndType;
        }

        AbstractDynamicConstantPoolEntry(ConstantPool cpm, int index, int hash, int bsmIndex, NameAndTypeEntryImpl nameAndType) {
            super(cpm, index, hash);
            this.bsmIndex = bsmIndex;
            this.bootstrapMethod = null;
            this.nameAndType = nameAndType;
        }

        public BootstrapMethodEntryImpl bootstrap() {
            if (this.bootstrapMethod == null) {
                this.bootstrapMethod = (BootstrapMethodEntryImpl)this.constantPool.bootstrapMethodEntry(this.bsmIndex);
            }
            return this.bootstrapMethod;
        }

        public int bootstrapMethodIndex() {
            return this.bsmIndex;
        }

        public NameAndTypeEntryImpl nameAndType() {
            return this.nameAndType;
        }

        @Override
        void writeTo(BufWriterImpl pool) {
            pool.writeU1U2U2(this.tag(), this.bsmIndex, this.nameAndType.index());
        }

        public String toString() {
            return this.tag() + " " + String.valueOf(this.bootstrap()) + "." + this.nameAndType().name().stringValue() + "-" + this.nameAndType().type().stringValue();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof AbstractDynamicConstantPoolEntry) {
                AbstractDynamicConstantPoolEntry d = (AbstractDynamicConstantPoolEntry)o;
                return this.tag() == d.tag() && this.bootstrap().equals(d.bootstrap()) && this.nameAndType.equals(d.nameAndType());
            }
            return false;
        }
    }

    public static final class InterfaceMethodRefEntryImpl
    extends AbstractMemberRefEntry
    implements InterfaceMethodRefEntry {
        InterfaceMethodRefEntryImpl(ConstantPool cpm, int index, ClassEntryImpl owner, NameAndTypeEntryImpl nameAndType) {
            super(cpm, 11, index, owner, nameAndType);
        }

        @Override
        public int tag() {
            return 11;
        }

        @Override
        public InterfaceMethodRefEntry clone(ConstantPoolBuilder cp) {
            return cp.interfaceMethodRefEntry((ClassEntry)this.ref1, (NameAndTypeEntry)this.ref2);
        }
    }

    public static final class MethodRefEntryImpl
    extends AbstractMemberRefEntry
    implements MethodRefEntry {
        MethodRefEntryImpl(ConstantPool cpm, int index, ClassEntryImpl owner, NameAndTypeEntryImpl nameAndType) {
            super(cpm, 10, index, owner, nameAndType);
        }

        @Override
        public int tag() {
            return 10;
        }

        @Override
        public MethodRefEntry clone(ConstantPoolBuilder cp) {
            return cp.methodRefEntry((ClassEntry)this.ref1, (NameAndTypeEntry)this.ref2);
        }
    }

    public static final class FieldRefEntryImpl
    extends AbstractMemberRefEntry
    implements FieldRefEntry {
        FieldRefEntryImpl(ConstantPool cpm, int index, ClassEntryImpl owner, NameAndTypeEntryImpl nameAndType) {
            super(cpm, 9, index, owner, nameAndType);
        }

        @Override
        public int tag() {
            return 9;
        }

        @Override
        public FieldRefEntry clone(ConstantPoolBuilder cp) {
            return cp.fieldRefEntry((ClassEntry)this.ref1, (NameAndTypeEntry)this.ref2);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class AbstractMemberRefEntry
    extends AbstractRefsEntry<ClassEntryImpl, NameAndTypeEntryImpl>
    implements MemberRefEntry {
        AbstractMemberRefEntry(ConstantPool cpm, int tag, int index, ClassEntryImpl owner, NameAndTypeEntryImpl nameAndType) {
            super(cpm, tag, index, owner, nameAndType);
        }

        @Override
        public ClassEntryImpl owner() {
            return (ClassEntryImpl)this.ref1;
        }

        @Override
        public NameAndTypeEntryImpl nameAndType() {
            return (NameAndTypeEntryImpl)this.ref2;
        }

        @Override
        public String toString() {
            return this.tag() + " " + this.owner().asInternalName() + "." + this.nameAndType().name().stringValue() + "-" + this.nameAndType().type().stringValue();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof AbstractMemberRefEntry) {
                AbstractMemberRefEntry m = (AbstractMemberRefEntry)o;
                return this.tag() == m.tag() && this.owner().equals(m.owner()) && this.nameAndType().equals(m.nameAndType());
            }
            return false;
        }
    }

    public static final class NameAndTypeEntryImpl
    extends AbstractRefsEntry<Utf8EntryImpl, Utf8EntryImpl>
    implements NameAndTypeEntry {
        NameAndTypeEntryImpl(ConstantPool cpm, int index, Utf8EntryImpl name, Utf8EntryImpl type) {
            super(cpm, 12, index, name, type);
        }

        @Override
        public int tag() {
            return 12;
        }

        @Override
        public Utf8Entry name() {
            return (Utf8Entry)this.ref1;
        }

        @Override
        public Utf8Entry type() {
            return (Utf8Entry)this.ref2;
        }

        @Override
        public NameAndTypeEntry clone(ConstantPoolBuilder cp) {
            return cp.nameAndTypeEntry((Utf8Entry)this.ref1, (Utf8Entry)this.ref2);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof NameAndTypeEntryImpl) {
                NameAndTypeEntryImpl nat = (NameAndTypeEntryImpl)o;
                return this.name().equals(nat.name()) && this.type().equals(nat.type());
            }
            return false;
        }
    }

    public static final class ModuleEntryImpl
    extends AbstractNamedEntry
    implements ModuleEntry {
        ModuleEntryImpl(ConstantPool cpm, int index, Utf8EntryImpl name) {
            super(cpm, 19, index, name);
        }

        @Override
        public int tag() {
            return 19;
        }

        @Override
        public ModuleEntry clone(ConstantPoolBuilder cp) {
            return cp.moduleEntry((Utf8Entry)this.ref1);
        }

        @Override
        public ModuleDesc asSymbol() {
            return ModuleDesc.of(this.asInternalName());
        }

        @Override
        public boolean matches(ModuleDesc desc) {
            return ((Utf8EntryImpl)this.ref1).equalsString(desc.name());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ModuleEntryImpl) {
                ModuleEntryImpl m = (ModuleEntryImpl)o;
                return this.name().equals(m.name());
            }
            return false;
        }
    }

    public static final class PackageEntryImpl
    extends AbstractNamedEntry
    implements PackageEntry {
        PackageEntryImpl(ConstantPool cpm, int index, Utf8EntryImpl name) {
            super(cpm, 20, index, name);
        }

        @Override
        public int tag() {
            return 20;
        }

        @Override
        public PackageEntry clone(ConstantPoolBuilder cp) {
            return cp.packageEntry((Utf8Entry)this.ref1);
        }

        @Override
        public PackageDesc asSymbol() {
            return PackageDesc.ofInternalName(this.asInternalName());
        }

        @Override
        public boolean matches(PackageDesc desc) {
            return ((Utf8EntryImpl)this.ref1).equalsString(desc.internalName());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PackageEntry) {
                PackageEntry p = (PackageEntry)o;
                return this.name().equals(p.name());
            }
            return false;
        }
    }

    public static final class ClassEntryImpl
    extends AbstractNamedEntry
    implements ClassEntry {
        public ClassDesc sym;
        private int hash;

        ClassEntryImpl(ConstantPool cpm, int index, Utf8EntryImpl name) {
            super(cpm, 7, index, name);
        }

        ClassEntryImpl(ConstantPool cpm, int index, Utf8EntryImpl name, int hash, ClassDesc sym) {
            super(cpm, 7, index, name);
            this.hash = hash;
            this.sym = sym;
        }

        @Override
        public int tag() {
            return 7;
        }

        @Override
        public ClassEntry clone(ConstantPoolBuilder cp) {
            return ((SplitConstantPool)cp).cloneClassEntry(this);
        }

        @Override
        public ClassDesc asSymbol() {
            ClassDesc sym = this.sym;
            if (sym != null) {
                return sym;
            }
            sym = ((Utf8EntryImpl)this.ref1).mayBeArrayDescriptor() ? ((Utf8EntryImpl)this.ref1).fieldTypeSymbol() : ExtraClassDesc.ofInternalName(this.asInternalName());
            this.sym = sym;
            return this.sym;
        }

        @Override
        public boolean matches(ClassDesc desc) {
            ClassDesc sym = this.sym;
            if (sym != null) {
                return sym.equals(desc);
            }
            boolean ret = this.rawEqualsSymbol(desc);
            if (ret) {
                this.sym = desc;
            }
            return ret;
        }

        private boolean rawEqualsSymbol(ClassDesc desc) {
            if (((Utf8EntryImpl)this.ref1).mayBeArrayDescriptor()) {
                return desc.isArray() && ((Utf8EntryImpl)this.ref1).isFieldType(desc);
            }
            return desc.isClassOrInterface() && ((Utf8EntryImpl)this.ref1).equalsString(Util.toInternalName(desc));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ClassEntryImpl) {
                ClassEntryImpl other = (ClassEntryImpl)o;
                return this.equalsEntry(other);
            }
            return false;
        }

        boolean equalsEntry(ClassEntryImpl other) {
            ClassDesc tsym = this.sym;
            ClassDesc osym = other.sym;
            if (tsym != null && osym != null) {
                return tsym.equals(osym);
            }
            return ((Utf8EntryImpl)this.ref1).equalsUtf8((Utf8EntryImpl)other.ref1);
        }

        @Override
        public int hashCode() {
            int hash = this.hash;
            if (hash != 0) {
                return hash;
            }
            this.hash = ClassEntryImpl.hashClassFromUtf8(((Utf8EntryImpl)this.ref1).mayBeArrayDescriptor(), (Utf8EntryImpl)this.ref1);
            return this.hash;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class AbstractNamedEntry
    extends AbstractRefEntry<Utf8EntryImpl> {
        public AbstractNamedEntry(ConstantPool constantPool, int tag, int index, Utf8EntryImpl ref1) {
            super(constantPool, tag, index, ref1);
        }

        public Utf8Entry name() {
            return (Utf8Entry)this.ref1;
        }

        public String asInternalName() {
            return ((Utf8EntryImpl)this.ref1).stringValue();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class AbstractRefsEntry<T extends PoolEntry, U extends PoolEntry>
    extends AbstractPoolEntry {
        protected final T ref1;
        protected final U ref2;

        public AbstractRefsEntry(ConstantPool constantPool, int tag, int index, T ref1, U ref2) {
            super(constantPool, index, AbstractRefsEntry.hash2(tag, ref1.index(), ref2.index()));
            this.ref1 = ref1;
            this.ref2 = ref2;
        }

        public T ref1() {
            return this.ref1;
        }

        public U ref2() {
            return this.ref2;
        }

        @Override
        void writeTo(BufWriterImpl pool) {
            pool.writeU1U2U2(this.tag(), this.ref1.index(), this.ref2.index());
        }

        public String toString() {
            return this.tag() + " " + String.valueOf(this.ref1) + "-" + String.valueOf(this.ref2);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class AbstractRefEntry<T extends PoolEntry>
    extends AbstractPoolEntry {
        protected final T ref1;

        public AbstractRefEntry(ConstantPool constantPool, int tag, int index, T ref1) {
            super(constantPool, index, AbstractRefEntry.hash1(tag, ref1.index()));
            this.ref1 = ref1;
        }

        public T ref1() {
            return this.ref1;
        }

        @Override
        void writeTo(BufWriterImpl pool) {
            pool.writeU1U2(this.tag(), this.ref1.index());
        }

        public String toString() {
            return this.tag() + " " + String.valueOf(this.ref1());
        }
    }
}

