/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.attribute;

import io.smallrye.classfile.Label;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.impl.StackMapDecoder;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import java.lang.constant.ClassDesc;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface StackMapFrameInfo {
    public int frameType();

    public Label target();

    public List<VerificationTypeInfo> locals();

    public List<VerificationTypeInfo> stack();

    public static StackMapFrameInfo of(Label target, List<VerificationTypeInfo> locals, List<VerificationTypeInfo> stack) {
        return new StackMapDecoder.StackMapFrameImpl(255, target, locals, stack);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface UninitializedVerificationTypeInfo
    extends VerificationTypeInfo {
        public Label newTarget();

        public static UninitializedVerificationTypeInfo of(Label newTarget) {
            return new StackMapDecoder.UninitializedVerificationTypeInfoImpl(newTarget);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ObjectVerificationTypeInfo
    extends VerificationTypeInfo {
        public static ObjectVerificationTypeInfo of(ClassEntry className) {
            return new StackMapDecoder.ObjectVerificationTypeInfoImpl(className);
        }

        public static ObjectVerificationTypeInfo of(ClassDesc classDesc) {
            return ObjectVerificationTypeInfo.of(TemporaryConstantPool.INSTANCE.classEntry(classDesc));
        }

        public ClassEntry className();

        default public ClassDesc classSymbol() {
            return this.className().asSymbol();
        }
    }

    public static enum SimpleVerificationTypeInfo implements VerificationTypeInfo
    {
        TOP(0),
        INTEGER(1),
        FLOAT(2),
        DOUBLE(3),
        LONG(4),
        NULL(5),
        UNINITIALIZED_THIS(6);

        private final int tag;

        private SimpleVerificationTypeInfo(int tag) {
            this.tag = tag;
        }

        @Override
        public int tag() {
            return this.tag;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface VerificationTypeInfo {
        public static final int ITEM_TOP = 0;
        public static final int ITEM_INTEGER = 1;
        public static final int ITEM_FLOAT = 2;
        public static final int ITEM_DOUBLE = 3;
        public static final int ITEM_LONG = 4;
        public static final int ITEM_NULL = 5;
        public static final int ITEM_UNINITIALIZED_THIS = 6;
        public static final int ITEM_OBJECT = 7;
        public static final int ITEM_UNINITIALIZED = 8;

        public int tag();
    }
}

