/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.attribute;

import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.ClassElement;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.impl.UnboundAttribute;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.util.Arrays;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface NestMembersAttribute
extends Attribute<NestMembersAttribute>,
ClassElement {
    public List<ClassEntry> nestMembers();

    public static NestMembersAttribute of(List<ClassEntry> nestMembers) {
        return new UnboundAttribute.UnboundNestMembersAttribute(nestMembers);
    }

    public static NestMembersAttribute of(ClassEntry ... nestMembers) {
        return NestMembersAttribute.of(List.of(nestMembers));
    }

    public static NestMembersAttribute ofSymbols(List<ClassDesc> nestMembers) {
        return NestMembersAttribute.of(Util.entryList(nestMembers));
    }

    public static NestMembersAttribute ofSymbols(ClassDesc ... nestMembers) {
        return NestMembersAttribute.ofSymbols(Arrays.asList(nestMembers));
    }
}

