/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.attribute;

import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.extras.reflect.AccessFlag;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.UnboundAttribute;
import io.smallrye.classfile.impl.Util;
import java.util.Optional;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface MethodParameterInfo {
    public Optional<Utf8Entry> name();

    public int flagsMask();

    default public Set<AccessFlag> flags() {
        return AccessFlag.maskToAccessFlags(this.flagsMask(), AccessFlag.Location.METHOD_PARAMETER);
    }

    default public boolean has(AccessFlag flag) {
        return Util.has(AccessFlag.Location.METHOD_PARAMETER, this.flagsMask(), flag);
    }

    public static MethodParameterInfo of(Optional<Utf8Entry> name, int flags) {
        return new UnboundAttribute.UnboundMethodParameterInfo(name, flags);
    }

    public static MethodParameterInfo of(Optional<String> name, AccessFlag ... flags) {
        return MethodParameterInfo.of(name.map(TemporaryConstantPool.INSTANCE::utf8Entry), Util.flagsToBits(AccessFlag.Location.METHOD_PARAMETER, flags));
    }

    public static MethodParameterInfo ofParameter(Optional<String> name, int flags) {
        return MethodParameterInfo.of(name.map(TemporaryConstantPool.INSTANCE::utf8Entry), flags);
    }
}

