/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.attribute;

import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.MethodElement;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.impl.UnboundAttribute;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.util.Arrays;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ExceptionsAttribute
extends Attribute<ExceptionsAttribute>,
MethodElement {
    public List<ClassEntry> exceptions();

    public static ExceptionsAttribute of(List<ClassEntry> exceptions) {
        return new UnboundAttribute.UnboundExceptionsAttribute(exceptions);
    }

    public static ExceptionsAttribute of(ClassEntry ... exceptions) {
        return ExceptionsAttribute.of(List.of(exceptions));
    }

    public static ExceptionsAttribute ofSymbols(List<ClassDesc> exceptions) {
        return ExceptionsAttribute.of(Util.entryList(exceptions));
    }

    public static ExceptionsAttribute ofSymbols(ClassDesc ... exceptions) {
        return ExceptionsAttribute.ofSymbols(Arrays.asList(exceptions));
    }
}

