/*
 * Copyright (c) 2022, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.ClassFileVersion;

import static io.smallrye.classfile.ClassFile.PREVIEW_MINOR_VERSION;

public final class ClassFileVersionImpl
        extends AbstractElement
        implements ClassFileVersion {
    private final int majorVersion, minorVersion;

    public ClassFileVersionImpl(int majorVersion, int minorVersion) {
        this.majorVersion = Util.checkU2(majorVersion, "major version");
        this.minorVersion = minorVersion == -1 ? PREVIEW_MINOR_VERSION
                : Util.checkU2(minorVersion, "minor version");
    }

    @Override
    public int majorVersion() {
        return majorVersion;
    }

    @Override
    public int minorVersion() {
        return minorVersion;
    }

    @Override
    public void writeTo(DirectClassBuilder builder) {
        builder.setVersion(majorVersion, minorVersion);
    }

    @Override
    public String toString() {
        return String.format("ClassFileVersion[majorVersion=%d, minorVersion=%d]", majorVersion, minorVersion);
    }
}
