/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag.sisu;

import io.smallrye.beanbag.sisu.BeanLoadingTask;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Phaser;
import org.jboss.logging.Logger;

class BeanLoadingTaskRunner {
    private static final Logger log = Logger.getLogger(BeanLoadingTaskRunner.class);
    private final Phaser phaser = new Phaser(1);
    private final Collection<Exception> errors = new ConcurrentLinkedDeque<Exception>();

    BeanLoadingTaskRunner() {
    }

    void run(BeanLoadingTask task) {
        this.phaser.register();
        CompletableFuture.runAsync(() -> {
            try {
                task.run();
            }
            catch (Exception e) {
                this.errors.add(e);
            }
            finally {
                this.phaser.arriveAndDeregister();
            }
        });
    }

    void waitForCompletion() {
        this.phaser.arriveAndAwaitAdvance();
        if (!this.errors.isEmpty()) {
            log.error((Object)"The following errors where caught while loading beans:");
            int i = 0;
            for (Exception e : this.errors) {
                log.error((Object)(++i + ") " + e.getMessage()), (Throwable)e);
            }
            throw new RuntimeException("Failed to load beans, please see the errors logged above");
        }
    }
}

