/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.indices.aliases;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class AliasMapping {
    protected List<String> indices = new LinkedList<String>();
    protected String alias;
    protected String filter;
    protected List<String> searchRouting = new LinkedList<String>();
    protected List<String> indexRouting = new LinkedList<String>();

    public abstract String getType();

    public List<Map<String, Object>> getData() {
        LinkedList<Map<String, Object>> retList = new LinkedList<Map<String, Object>>();
        for (String index : this.indices) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("index", index);
            paramsMap.put("alias", this.alias);
            if (StringUtils.isNotEmpty((String)this.filter)) {
                paramsMap.put("filter", this.filter);
            }
            if (this.searchRouting.size() > 0) {
                paramsMap.put("search_routing", StringUtils.join(this.searchRouting, (String)","));
            }
            if (this.indexRouting.size() > 0) {
                paramsMap.put("index_routing", StringUtils.join(this.indexRouting, (String)","));
            }
            HashMap<String, HashMap<String, String>> actionMap = new HashMap<String, HashMap<String, String>>();
            actionMap.put(this.getType(), paramsMap);
            retList.add(actionMap);
        }
        return retList;
    }
}

