/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.facet;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.facet.Facet;
import java.util.ArrayList;
import java.util.List;

public class DateHistogramFacet
extends Facet {
    public static final String TYPE = "date_histogram";
    private List<DateHistogram> dateHistograms;

    public DateHistogramFacet(String name, JsonObject dateHistogramFacet) {
        this.name = name;
        this.dateHistograms = new ArrayList<DateHistogram>();
        for (JsonElement term : dateHistogramFacet.get("entries").getAsJsonArray()) {
            JsonElement time = term.getAsJsonObject().get("time");
            JsonElement count = term.getAsJsonObject().get("count");
            DateHistogram histogram = new DateHistogram(time.getAsLong(), count.getAsLong());
            this.dateHistograms.add(histogram);
        }
    }

    public List<DateHistogram> getDateHistograms() {
        return this.dateHistograms;
    }

    public class DateHistogram {
        private Long time;
        private Long count;

        DateHistogram(Long time, Long count) {
            this.time = time;
            this.count = count;
        }

        public Long getTime() {
            return this.time;
        }

        public Long getCount() {
            return this.count;
        }
    }
}

