/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import io.searchbox.AbstractAction;
import io.searchbox.core.Search;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MultiSearch
extends AbstractAction {
    public MultiSearch(Builder builder) {
        super(builder);
        this.setURI(this.buildURI());
        this.setData(MultiSearch.generateData(builder.searchList));
    }

    protected static Object generateData(Collection<? extends Search> searches) {
        StringBuilder sb = new StringBuilder();
        for (Search search : searches) {
            sb.append("{\"index\" : \"").append(search.getIndex());
            if (StringUtils.isNotBlank((String)search.getType())) {
                sb.append("\", \"type\" : \"").append(search.getType());
            }
            sb.append("\"}\n{\"query\" : ").append(search.getData()).append("}\n");
        }
        return sb.toString();
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    protected String buildURI() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.buildURI()).append("/_msearch");
        return sb.toString();
    }

    public static class Builder
    extends AbstractAction.Builder<MultiSearch, Builder> {
        private List<Search> searchList = new LinkedList<Search>();

        public Builder(Search search) {
            this.searchList.add(search);
        }

        public Builder(Collection<? extends Search> searches) {
            this.searchList.addAll(searches);
        }

        public Builder addSearch(Search search) {
            this.searchList.add(search);
            return this;
        }

        public Builder addSearch(Collection<? extends Search> searches) {
            this.searchList.addAll(searches);
            return this;
        }

        @Override
        public MultiSearch build() {
            return new MultiSearch(this);
        }
    }
}

