/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.client;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.searchbox.annotations.JestId;
import io.searchbox.core.search.facet.Facet;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JestResult {
    static final Logger log = LoggerFactory.getLogger(JestResult.class);
    public static final String ES_METADATA_ID = "es_metadata_id";
    private JsonObject jsonObject;
    private String jsonString;
    private String pathToResult;
    private boolean isSucceeded;
    private String errorMessage;

    public String getPathToResult() {
        return this.pathToResult;
    }

    public void setPathToResult(String pathToResult) {
        this.pathToResult = pathToResult;
    }

    public Object getValue(String key) {
        return this.getJsonMap().get(key);
    }

    public boolean isSucceeded() {
        return this.isSucceeded;
    }

    public void setSucceeded(boolean succeeded) {
        this.isSucceeded = succeeded;
    }

    public String getJsonString() {
        return this.jsonString;
    }

    public void setJsonString(String jsonString) {
        this.jsonString = jsonString;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    @Deprecated
    public Map getJsonMap() {
        Gson gson = new Gson();
        return (Map)gson.fromJson((JsonElement)this.jsonObject, Map.class);
    }

    public <T> T getSourceAsObject(Class<T> clazz) {
        JsonArray sourceList = this.extractSource();
        if (sourceList.size() > 0) {
            return this.createSourceObject(sourceList.get(0), clazz);
        }
        return null;
    }

    private <T> T createSourceObject(JsonElement source, Class<T> type) {
        Object obj = null;
        try {
            Field[] fields;
            Gson gson = new Gson();
            String json = source.toString();
            obj = gson.fromJson(json, type);
            for (Field field : fields = type.getDeclaredFields()) {
                if (!field.isAnnotationPresent(JestId.class)) continue;
                try {
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    if (value == null) {
                        Class<?> fieldType = field.getType();
                        JsonElement id = ((JsonObject)source).get(ES_METADATA_ID);
                        field.set(obj, this.getAs(id, fieldType));
                    }
                }
                catch (IllegalAccessException e) {
                    log.error("Unhandled exception occurred while getting annotated id from source");
                }
                break;
            }
        }
        catch (Exception e) {
            log.error("Unhandled exception occurred while converting source to the object ." + type.getCanonicalName(), (Throwable)e);
        }
        return (T)obj;
    }

    private <T> T getAs(JsonElement id, Class<T> fieldType) throws IllegalAccessException {
        if (id.isJsonNull()) {
            return null;
        }
        if (fieldType.isAssignableFrom(String.class)) {
            return (T)id.getAsString();
        }
        if (fieldType.isAssignableFrom(Number.class)) {
            return (T)id.getAsNumber();
        }
        if (fieldType.isAssignableFrom(BigDecimal.class)) {
            return (T)id.getAsBigDecimal();
        }
        if (fieldType.isAssignableFrom(Double.class)) {
            Double o = id.getAsDouble();
            return (T)o;
        }
        if (fieldType.isAssignableFrom(Float.class)) {
            Float o = Float.valueOf(id.getAsFloat());
            return (T)o;
        }
        if (fieldType.isAssignableFrom(BigInteger.class)) {
            return (T)id.getAsBigInteger();
        }
        if (fieldType.isAssignableFrom(Long.class)) {
            Long o = id.getAsLong();
            return (T)o;
        }
        if (fieldType.isAssignableFrom(Integer.class)) {
            Integer o = id.getAsInt();
            return (T)o;
        }
        if (fieldType.isAssignableFrom(Short.class)) {
            Short o = id.getAsShort();
            return (T)o;
        }
        if (fieldType.isAssignableFrom(Character.class)) {
            return (T)Character.valueOf(id.getAsCharacter());
        }
        if (fieldType.isAssignableFrom(Byte.class)) {
            return (T)Byte.valueOf(id.getAsByte());
        }
        if (fieldType.isAssignableFrom(Boolean.class)) {
            return (T)Boolean.valueOf(id.getAsBoolean());
        }
        throw new RuntimeException("cannot assign " + id + " to " + fieldType);
    }

    public <T> List<T> getSourceAsObjectList(Class<T> type) {
        ArrayList<T> objectList = new ArrayList<T>();
        if (!this.isSucceeded) {
            return objectList;
        }
        JsonArray sourceList = this.extractSource();
        for (JsonElement source : sourceList) {
            T obj = this.createSourceObject(source, type);
            if (obj == null) continue;
            objectList.add(obj);
        }
        return objectList;
    }

    protected JsonArray extractSource() {
        JsonArray sourceList = new JsonArray();
        if (this.jsonObject == null) {
            return sourceList;
        }
        String[] keys = this.getKeys();
        if (keys == null) {
            sourceList.add((JsonElement)this.jsonObject);
            return sourceList;
        }
        String sourceKey = keys[keys.length - 1];
        JsonElement obj = this.jsonObject.get(keys[0]);
        if (keys.length > 1) {
            for (int i = 1; i < keys.length - 1; ++i) {
                obj = ((JsonObject)obj).get(keys[i]);
            }
            if (obj.isJsonObject()) {
                JsonElement source = ((JsonObject)obj).get(sourceKey);
                if (source != null) {
                    sourceList.add(source);
                }
            } else if (obj.isJsonArray()) {
                for (JsonElement newObj : (JsonArray)obj) {
                    JsonObject source;
                    if (!(newObj instanceof JsonObject) || (source = (JsonObject)((JsonObject)newObj).get(sourceKey)) == null) continue;
                    source.add(ES_METADATA_ID, ((JsonObject)newObj).get("_id"));
                    sourceList.add((JsonElement)source);
                }
            }
        } else if (obj != null) {
            sourceList.add(obj);
        }
        return sourceList;
    }

    protected String[] getKeys() {
        return this.pathToResult == null ? null : (this.pathToResult + "").split("/");
    }

    public <T extends Facet> List<T> getFacets(Class<T> type) {
        ArrayList<Facet> facets = new ArrayList<Facet>();
        if (this.jsonObject != null) {
            try {
                JsonObject facetsMap = (JsonObject)this.jsonObject.get("facets");
                if (facetsMap == null) {
                    return facets;
                }
                for (Map.Entry facetEntry : facetsMap.entrySet()) {
                    JsonObject facet = ((JsonElement)facetEntry.getValue()).getAsJsonObject();
                    if (!facet.get("_type").getAsString().equalsIgnoreCase(type.getField("TYPE").get(null).toString())) continue;
                    Constructor<T> c = type.getConstructor(String.class, JsonObject.class);
                    facets.add((Facet)c.newInstance(facetEntry.getKey(), facetEntry.getValue()));
                }
                return facets;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return facets;
    }

    public void setJsonMap(Map<String, Object> resultMap) {
        Gson gson = new Gson();
        String json = gson.toJson(resultMap, Map.class);
        this.setJsonObject(new JsonParser().parse(json).getAsJsonObject());
    }

    public void setJsonObject(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
        if (jsonObject.get("error") != null) {
            this.errorMessage = jsonObject.get("error").getAsString();
        }
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

