/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox;

import io.searchbox.AbstractAction;
import io.searchbox.DocumentTargetedAction;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractDocumentTargetedAction
extends AbstractAction
implements DocumentTargetedAction {
    protected String id;

    public AbstractDocumentTargetedAction(Builder builder) {
        super(builder);
        this.indexName = builder.index;
        this.typeName = builder.type;
        this.id = builder.id;
    }

    @Override
    public String getIndex() {
        return this.indexName;
    }

    @Override
    public String getType() {
        return this.typeName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    protected String buildURI() {
        StringBuilder sb = new StringBuilder(super.buildURI());
        if (StringUtils.isNotBlank((String)this.id)) {
            sb.append("/").append(this.id);
        }
        String uri = sb.toString();
        return uri;
    }

    protected static abstract class Builder<T extends AbstractDocumentTargetedAction, K>
    extends AbstractAction.Builder<T, K> {
        private String index;
        private String type;
        private String id;

        protected Builder() {
        }

        public K index(String index) {
            this.index = index;
            return (K)this;
        }

        public K type(String type) {
            this.type = type;
            return (K)this;
        }

        public K id(String id) {
            this.id = id;
            return (K)this;
        }
    }
}

