/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.searchbox.AbstractMultiIndexActionBuilder;
import io.searchbox.AbstractMultiTypeActionBuilder;
import io.searchbox.Action;
import io.searchbox.annotations.JestId;
import io.searchbox.core.Doc;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAction
implements Action {
    static final Logger log = LoggerFactory.getLogger(AbstractAction.class);
    private final ConcurrentMap<String, Object> headerMap = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<String, Object> parameterMap = new ConcurrentHashMap<String, Object>();
    protected String indexName;
    protected String typeName;
    private Object data;
    private String URI;
    private boolean isBulkOperation;
    private String pathToResult;

    public AbstractAction() {
    }

    public AbstractAction(Builder builder) {
        this.parameterMap.putAll(builder.parameters);
        this.headerMap.putAll(builder.headers);
        if (builder instanceof AbstractMultiIndexActionBuilder) {
            this.indexName = ((AbstractMultiIndexActionBuilder)builder).getJoinedIndices();
            if (builder instanceof AbstractMultiTypeActionBuilder) {
                this.indexName = ((AbstractMultiTypeActionBuilder)builder).getJoinedIndices();
                this.typeName = ((AbstractMultiTypeActionBuilder)builder).getJoinedTypes();
            }
        }
    }

    public Object getParameter(String parameter) {
        return this.parameterMap.get(parameter);
    }

    public Object getHeader(String header) {
        return this.headerMap.get(header);
    }

    @Override
    public Map<String, Object> getHeaders() {
        return this.headerMap;
    }

    @Override
    public String getURI() {
        String finalUri = this.URI;
        if (this.parameterMap.size() > 0) {
            finalUri = finalUri + this.buildQueryString();
        }
        return finalUri;
    }

    protected void setURI(String URI) {
        this.URI = URI;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    protected void setData(Object data) {
        this.data = data;
    }

    @Override
    public String getPathToResult() {
        return this.pathToResult;
    }

    protected void setPathToResult(String pathToResult) {
        this.pathToResult = pathToResult;
    }

    public static String getIdFromSource(Object source) {
        Field[] fields;
        if (source == null) {
            return null;
        }
        for (Field field : fields = source.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(JestId.class)) continue;
            try {
                field.setAccessible(true);
                Object name = field.get(source);
                return name == null ? null : name.toString();
            }
            catch (IllegalAccessException e) {
                log.error("Unhandled exception occurred while getting annotated id from source");
            }
        }
        return null;
    }

    public String createCommaSeparatedItemList(LinkedHashSet<String> set) {
        StringBuilder sb = new StringBuilder();
        String tmp = "";
        for (String index : set) {
            sb.append(tmp);
            sb.append(index);
            tmp = ",";
        }
        return sb.toString();
    }

    protected String buildURI() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)this.indexName)) {
            sb.append(this.indexName);
            if (StringUtils.isNotBlank((String)this.typeName)) {
                sb.append("/").append(this.typeName);
            }
        }
        String uri = sb.toString();
        return uri;
    }

    protected String buildQueryString() {
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry entry : this.parameterMap.entrySet()) {
            if (queryString.length() == 0) {
                queryString.append("?");
            } else {
                queryString.append("&");
            }
            queryString.append(entry.getKey().toString()).append("=").append(entry.getValue().toString());
        }
        return queryString.toString();
    }

    protected boolean isValid(String index, String type, String id) {
        return StringUtils.isNotBlank((String)index) && StringUtils.isNotBlank((String)type) && StringUtils.isNotBlank((String)id);
    }

    protected boolean isValid(Doc doc) {
        return this.isValid(doc.getIndex(), doc.getType(), doc.getId());
    }

    public boolean isBulkOperation() {
        return this.isBulkOperation;
    }

    protected void setBulkOperation(boolean bulkOperation) {
        this.isBulkOperation = bulkOperation;
    }

    @Deprecated
    public final Boolean isOperationSucceed(Map result) {
        return this.isOperationSucceed(new JsonParser().parse(new Gson().toJson((Object)result, Map.class)).getAsJsonObject());
    }

    @Override
    public Boolean isOperationSucceed(JsonObject result) {
        return true;
    }

    @Override
    public abstract String getRestMethodName();

    protected static abstract class Builder<T extends Action, K> {
        protected Map<String, Object> parameters = new HashMap<String, Object>();
        protected Map<String, Object> headers = new HashMap<String, Object>();

        protected Builder() {
        }

        public K setParameter(String key, Object value) {
            this.parameters.put(key, value);
            return (K)this;
        }

        public K setParameter(Map<String, Object> parameters) {
            this.parameters.putAll(parameters);
            return (K)this;
        }

        public K setHeader(String key, Object value) {
            this.headers.put(key, value);
            return (K)this;
        }

        public K setHeader(Map<String, Object> headers) {
            this.headers.putAll(headers);
            return (K)this;
        }

        public K refresh(boolean refresh) {
            return this.setParameter("refresh", refresh);
        }

        public abstract T build();
    }
}

