/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Expression;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.TemplateException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;

public final class Futures {
    private Futures() {
    }

    static <T> Supplier<T> toSupplier(final CompletableFuture<T> fu) {
        return new Supplier<T>(){

            @Override
            public T get() {
                try {
                    return fu.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new TemplateException(e);
                }
            }
        };
    }

    static CompletionStage<Map<String, Object>> evaluateParams(Map<String, Expression> parameters, ResolutionContext resolutionContext) {
        CompletableFuture<Map<String, Object>> result = new CompletableFuture<Map<String, Object>>();
        CompletableFuture[] results = new CompletableFuture[parameters.size()];
        int idx = 0;
        for (Map.Entry<String, Expression> entry : parameters.entrySet()) {
            results[idx++] = resolutionContext.evaluate(entry.getValue()).toCompletableFuture();
        }
        CompletableFuture.allOf(results).whenComplete((v, t1) -> {
            if (t1 != null) {
                result.completeExceptionally((Throwable)t1);
            } else {
                HashMap paramValues = new HashMap();
                int j = 0;
                try {
                    for (Map.Entry entry : parameters.entrySet()) {
                        paramValues.put((String)entry.getKey(), results[j++].get());
                    }
                    result.complete(paramValues);
                }
                catch (Throwable e) {
                    result.completeExceptionally(e);
                }
            }
        });
        return result;
    }
}

