/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.TemplateNode;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public interface Expression {
    public String getNamespace();

    default public boolean hasNamespace() {
        return this.getNamespace() != null;
    }

    public List<Part> getParts();

    public boolean isLiteral();

    public CompletableFuture<Object> getLiteralValue();

    public TemplateNode.Origin getOrigin();

    public String toOriginalString();

    default public String collectTypeInfo() {
        if (!this.hasTypeInfo()) {
            return null;
        }
        return this.getParts().stream().map(Part::getTypeInfo).collect(Collectors.joining("."));
    }

    default public boolean hasTypeInfo() {
        return this.getParts().get(0).getTypeInfo() != null;
    }

    public int getGeneratedId();

    public static interface VirtualMethodPart
    extends Part {
        public List<Expression> getParameters();
    }

    public static interface Part {
        public String getName();

        public String getTypeInfo();

        default public boolean isVirtualMethod() {
            return false;
        }

        default public VirtualMethodPart asVirtualMethod() {
            throw new IllegalStateException("Not a virtual method: " + this.toString() + " [typeInfo: " + this.getTypeInfo() + "]");
        }
    }
}

