/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Booleans;
import io.quarkus.qute.EvalContext;
import io.quarkus.qute.Mapper;
import io.quarkus.qute.RawString;
import io.quarkus.qute.Results;
import io.quarkus.qute.ValueResolver;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;

public final class ValueResolvers {
    static final String THIS = "this";

    public static ValueResolver rawResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && (context.getName().equals("raw") || context.getName().equals("safe"));
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return CompletableFuture.completedFuture(new RawString(context.getBase().toString()));
            }
        };
    }

    public static ValueResolver listResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return ValueResolver.matchClass(context, List.class);
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return ValueResolvers.listResolveAsync(context);
            }
        };
    }

    public static ValueResolver collectionResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return ValueResolver.matchClass(context, Collection.class);
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return ValueResolvers.collectionResolveAsync(context);
            }
        };
    }

    public static ValueResolver thisResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && ValueResolvers.THIS.equals(context.getName());
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return CompletableFuture.completedFuture(context.getBase());
            }
        };
    }

    public static ValueResolver orResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                if (context.getParams().size() != 1) {
                    return false;
                }
                switch (context.getName()) {
                    case "?:": 
                    case "or": 
                    case ":": {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                if (context.getBase() == null || Results.Result.NOT_FOUND.equals(context.getBase())) {
                    return context.evaluate(context.getParams().get(0));
                }
                return CompletableFuture.completedFuture(context.getBase());
            }
        };
    }

    public static ValueResolver trueResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getParams().size() == 1 && "?".equals(context.getName());
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                if (Booleans.isFalsy(context.getBase())) {
                    return Results.NOT_FOUND;
                }
                return context.evaluate(context.getParams().get(0));
            }
        };
    }

    public static ValueResolver mapEntryResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return ValueResolver.matchClass(context, Map.Entry.class);
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                Map.Entry entry = (Map.Entry)context.getBase();
                return CompletableFuture.completedFuture(ValueResolvers.entryResolve(entry, context.getName()));
            }
        };
    }

    public static ValueResolver mapResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return ValueResolver.matchClass(context, Map.class);
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                return ValueResolvers.mapResolveAsync(context);
            }
        };
    }

    public static ValueResolver mapperResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() instanceof Mapper;
            }

            @Override
            public int getPriority() {
                return 5;
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                Mapper mapper = (Mapper)context.getBase();
                return CompletableFuture.completedFuture(mapper.get(context.getName()));
            }
        };
    }

    public static ValueResolver logicalAndResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && context.getParams().size() == 1 && "&&".equals(context.getName());
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                boolean baseIsFalsy = Booleans.isFalsy(context.getBase());
                return baseIsFalsy ? CompletableFuture.completedFuture(false) : context.evaluate(context.getParams().get(0)).thenApply(new Function<Object, Object>(){

                    @Override
                    public Object apply(Object booleanParam) {
                        return !Booleans.isFalsy(booleanParam);
                    }
                });
            }
        };
    }

    public static ValueResolver logicalOrResolver() {
        return new ValueResolver(){

            @Override
            public boolean appliesTo(EvalContext context) {
                return context.getBase() != null && context.getParams().size() == 1 && "||".equals(context.getName());
            }

            @Override
            public CompletionStage<Object> resolve(EvalContext context) {
                boolean baseIsFalsy = Booleans.isFalsy(context.getBase());
                return !baseIsFalsy ? CompletableFuture.completedFuture(true) : context.evaluate(context.getParams().get(0)).thenApply(new Function<Object, Object>(){

                    @Override
                    public Object apply(Object booleanParam) {
                        return !Booleans.isFalsy(booleanParam);
                    }
                });
            }
        };
    }

    private static CompletionStage<Object> collectionResolveAsync(EvalContext context) {
        Collection collection = (Collection)context.getBase();
        switch (context.getName()) {
            case "size": {
                return CompletableFuture.completedFuture(collection.size());
            }
            case "isEmpty": 
            case "empty": {
                return CompletableFuture.completedFuture(collection.isEmpty());
            }
            case "contains": {
                if (context.getParams().size() != 1) break;
                return context.evaluate(context.getParams().get(0)).thenCompose(e -> CompletableFuture.completedFuture(collection.contains(e)));
            }
        }
        return Results.NOT_FOUND;
    }

    private static CompletionStage<Object> listResolveAsync(EvalContext context) {
        List list = (List)context.getBase();
        switch (context.getName()) {
            case "get": {
                if (context.getParams().size() != 1) break;
                return context.evaluate(context.getParams().get(0)).thenApply(r -> {
                    try {
                        int idx = r instanceof Integer ? (Integer)r : Integer.valueOf(r.toString());
                        if (idx >= list.size()) {
                            return Results.Result.NOT_FOUND;
                        }
                        return list.get(idx);
                    }
                    catch (NumberFormatException e) {
                        return Results.Result.NOT_FOUND;
                    }
                });
            }
        }
        return Results.NOT_FOUND;
    }

    private static Object entryResolve(Map.Entry<?, ?> entry, String name) {
        switch (name) {
            case "key": 
            case "getKey": {
                return entry.getKey();
            }
            case "value": 
            case "getValue": {
                return entry.getValue();
            }
        }
        return Results.Result.NOT_FOUND;
    }

    private static CompletionStage<Object> mapResolveAsync(EvalContext context) {
        Map map = (Map)context.getBase();
        switch (context.getName()) {
            case "keys": 
            case "keySet": {
                return CompletableFuture.completedFuture(map.keySet());
            }
            case "values": {
                return CompletableFuture.completedFuture(map.values());
            }
            case "entrySet": {
                return CompletableFuture.completedFuture(map.entrySet());
            }
            case "size": {
                return CompletableFuture.completedFuture(map.size());
            }
            case "empty": 
            case "isEmpty": {
                return CompletableFuture.completedFuture(map.isEmpty());
            }
            case "get": {
                if (context.getParams().size() == 1) {
                    return context.evaluate(context.getParams().get(0)).thenCompose(k -> CompletableFuture.completedFuture(map.get(k)));
                }
            }
            case "containsKey": {
                if (context.getParams().size() != 1) break;
                return context.evaluate(context.getParams().get(0)).thenCompose(k -> CompletableFuture.completedFuture(map.containsKey(k)));
            }
        }
        return map.containsKey(context.getName()) ? CompletableFuture.completedFuture(map.get(context.getName())) : Results.NOT_FOUND;
    }
}

