/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.BasicAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@ApplicationScoped
public class HttpAuthenticator {
    @Inject
    IdentityProviderManager identityProviderManager;
    final HttpAuthenticationMechanism mechanism;

    public HttpAuthenticator() {
        this.mechanism = null;
    }

    @Inject
    public HttpAuthenticator(Instance<HttpAuthenticationMechanism> instance, Instance<IdentityProvider<UsernamePasswordAuthenticationRequest>> usernamePassword) {
        if (instance.isResolvable()) {
            if (instance.isAmbiguous()) {
                throw new IllegalStateException("Multiple HTTP authentication mechanisms are not implemented yet, discovered " + instance.stream().collect(Collectors.toList()));
            }
            this.mechanism = (HttpAuthenticationMechanism)instance.get();
        } else {
            this.mechanism = !usernamePassword.isUnsatisfied() ? new BasicAuthenticationMechanism("Quarkus") : new NoAuthenticationMechanism();
        }
    }

    public HttpAuthenticator(HttpAuthenticationMechanism mechanism) {
        this.mechanism = mechanism == null ? new NoAuthenticationMechanism() : mechanism;
    }

    public CompletionStage<SecurityIdentity> attemptAuthentication(RoutingContext routingContext) {
        return this.mechanism.authenticate(routingContext, this.identityProviderManager);
    }

    public CompletionStage<Void> sendChallenge(RoutingContext routingContext, Runnable closeTask) {
        if (closeTask == null) {
            closeTask = NoopCloseTask.INSTANCE;
        }
        return this.mechanism.sendChallenge(routingContext).thenRun(closeTask);
    }

    public CompletionStage<ChallengeData> getChallenge(RoutingContext context) {
        return this.mechanism.getChallenge(context);
    }

    static class NoopCloseTask
    implements Runnable {
        static final NoopCloseTask INSTANCE = new NoopCloseTask();

        NoopCloseTask() {
        }

        @Override
        public void run() {
        }
    }

    static class NoAuthenticationMechanism
    implements HttpAuthenticationMechanism {
        NoAuthenticationMechanism() {
        }

        @Override
        public CompletionStage<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletionStage<ChallengeData> getChallenge(RoutingContext context) {
            ChallengeData challengeData = new ChallengeData(HttpResponseStatus.FORBIDDEN.code(), null, null);
            return CompletableFuture.completedFuture(challengeData);
        }
    }
}

