/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.builder.Version;
import io.quarkus.devconsole.runtime.spi.FlashScopeUtil;
import io.quarkus.qute.Engine;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import io.smallrye.common.classloader.ClassPathUtils;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.function.BiFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.yaml.snakeyaml.Yaml;

public class DevConsole
implements Handler<RoutingContext> {
    static final ThreadLocal<String> currentExtension = new ThreadLocal();
    private static final Comparator<Map<String, Object>> EXTENSION_COMPARATOR = Comparator.comparing(m -> (String)m.get("name"));
    final Engine engine;
    final Map<String, Map<String, Object>> extensions = new HashMap<String, Map<String, Object>>();
    final Map<String, Object> globalData = new HashMap<String, Object>();
    final Config config = ConfigProvider.getConfig();
    final String devRootAppend;

    DevConsole(Engine engine, String httpRootPath, String frameworkRootPath) {
        this.engine = engine;
        this.globalData.put("httpRootPath", httpRootPath);
        this.globalData.put("frameworkRootPath", frameworkRootPath);
        this.devRootAppend = frameworkRootPath + "dev";
        this.globalData.put("devRootAppend", this.devRootAppend);
        this.globalData.put("quarkusVersion", Version.getVersion());
        this.globalData.put("applicationName", this.config.getOptionalValue("quarkus.application.name", String.class).orElse(""));
        this.globalData.put("applicationVersion", this.config.getOptionalValue("quarkus.application.version", String.class).orElse(""));
        try {
            Yaml yaml = new Yaml();
            ClassPathUtils.consumeAsPaths((String)"/META-INF/quarkus-extension.yaml", p -> {
                String desc;
                try (Scanner scanner = new Scanner(Files.newBufferedReader(p, StandardCharsets.UTF_8));){
                    scanner.useDelimiter("\\A");
                    desc = scanner.hasNext() ? scanner.next() : null;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read " + p, e);
                }
                if (desc == null) {
                    return;
                }
                Map metadata = (Map)yaml.load(desc);
                this.extensions.put(DevConsole.getExtensionNamespace(metadata), metadata);
            });
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        this.globalData.put("configKeyMap", this.getConfigKeyMap());
    }

    public void handle(RoutingContext ctx) {
        if (ctx.normalizedPath().length() == this.devRootAppend.length()) {
            ctx.response().setStatusCode(302);
            ctx.response().headers().set(HttpHeaders.LOCATION, (CharSequence)(this.devRootAppend + "/"));
            ctx.response().end();
            return;
        }
        String path = ctx.normalizedPath().substring(ctx.mountPoint().length() + 1);
        if (path.isEmpty() || path.equals("/")) {
            this.sendMainPage(ctx);
        } else {
            int nsIndex = path.indexOf("/");
            if (nsIndex == -1) {
                ctx.response().setStatusCode(404).end();
                return;
            }
            String namespace = path.substring(0, nsIndex);
            currentExtension.set(namespace);
            Template devTemplate = this.engine.getTemplate(path);
            if (devTemplate != null) {
                String extName = this.getExtensionName(namespace);
                ctx.response().setStatusCode(200).headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"text/html; charset=UTF-8");
                TemplateInstance devTemplateInstance = devTemplate.data("currentExtensionName", (Object)extName).data("flash", FlashScopeUtil.getFlash((RoutingContext)ctx)).data("currentRequest", (Object)ctx.request());
                this.renderTemplate(ctx, devTemplateInstance);
            } else {
                ctx.next();
            }
        }
    }

    private Map<String, List<String>> getConfigKeyMap() {
        TreeMap<String, List<String>> ckm = new TreeMap<String, List<String>>();
        Collection<Map<String, Object>> values = this.extensions.values();
        for (Map<String, Object> extension : values) {
            Map metadata;
            if (!extension.containsKey("metadata") || !(metadata = (Map)extension.get("metadata")).containsKey("config")) continue;
            List configKeys = (List)metadata.get("config");
            String name = (String)extension.get("name");
            ckm.put(name, configKeys);
        }
        return ckm;
    }

    private String getExtensionName(String namespace) {
        Map<String, Object> map = this.extensions.get(namespace);
        if (map == null) {
            return null;
        }
        return (String)map.get("name");
    }

    protected void renderTemplate(final RoutingContext event, TemplateInstance template) {
        for (Map.Entry<String, Object> global : this.globalData.entrySet()) {
            template.data(global.getKey(), global.getValue());
        }
        template.renderAsync().handle(new BiFunction<String, Throwable, Object>(){

            @Override
            public Object apply(String s, Throwable throwable) {
                if (throwable != null) {
                    event.fail(throwable);
                } else {
                    event.response().end(s);
                }
                return null;
            }
        });
    }

    public void sendMainPage(RoutingContext event) {
        Template devTemplate = this.engine.getTemplate("index");
        ArrayList<Map<String, Object>> actionableExtensions = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> nonActionableExtensions = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> loaded : this.extensions.values()) {
            Map metadata = (Map)loaded.get("metadata");
            String namespace = DevConsole.getExtensionNamespace(loaded);
            currentExtension.set(namespace);
            Template simpleTemplate = this.engine.getTemplate(namespace + "/embedded.html");
            boolean hasConsoleEntry = simpleTemplate != null;
            boolean hasGuide = metadata.containsKey("guide");
            boolean hasConfig = metadata.containsKey("config");
            boolean isUnlisted = metadata.containsKey("unlisted") && (metadata.get("unlisted").equals(true) || metadata.get("unlisted").equals("true"));
            loaded.put("hasConsoleEntry", hasConsoleEntry);
            loaded.put("hasGuide", hasGuide);
            if (isUnlisted && !hasConsoleEntry && !hasGuide && !hasConfig) continue;
            if (hasConsoleEntry) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.putAll(this.globalData);
                data.put("urlbase", namespace);
                String result = simpleTemplate.render(data);
                loaded.put("_dev", result);
                actionableExtensions.add(loaded);
                continue;
            }
            nonActionableExtensions.add(loaded);
        }
        actionableExtensions.sort(EXTENSION_COMPARATOR);
        nonActionableExtensions.sort(EXTENSION_COMPARATOR);
        TemplateInstance instance = devTemplate.data("actionableExtensions", actionableExtensions).data("nonActionableExtensions", nonActionableExtensions).data("flash", FlashScopeUtil.getFlash((RoutingContext)event));
        this.renderTemplate(event, instance);
    }

    private static String getExtensionNamespace(Map<String, Object> metadata) {
        String artifactId;
        String groupId;
        String artifact = (String)metadata.get("artifact");
        if (artifact == null) {
            groupId = (String)metadata.get("group-id");
            artifactId = (String)metadata.get("artifact-id");
            if (artifactId == null || groupId == null) {
                throw new RuntimeException("Failed to locate 'artifact' or 'group-id' and 'artifact-id' among metadata keys " + metadata.keySet());
            }
        } else {
            AppArtifactCoords coords = AppArtifactCoords.fromString((String)artifact);
            groupId = coords.getGroupId();
            artifactId = coords.getArtifactId();
        }
        return groupId + "." + artifactId;
    }
}

