/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.tls.runtime;

import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.runtime.CertificateRecorder;
import io.quarkus.tls.runtime.KeyStoreAndKeyCertOptions;
import io.quarkus.tls.runtime.TrustAllOptions;
import io.quarkus.tls.runtime.TrustStoreAndTrustOptions;
import io.quarkus.tls.runtime.config.TlsBucketConfig;
import io.quarkus.tls.runtime.config.TlsConfigUtils;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrustOptions;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jboss.logging.Logger;

public class VertxCertificateHolder
implements TlsConfiguration {
    private static final Logger LOGGER = Logger.getLogger((String)VertxCertificateHolder.class.getName());
    private final TlsBucketConfig config;
    private final List<Buffer> crls;
    private TrustOptions trustOptions;
    private KeyStore trustStore;
    private KeyCertOptions keyStoreOptions;
    private KeyStore keyStore;
    private final Vertx vertx;
    private final String name;

    VertxCertificateHolder(Vertx vertx, String name, TlsBucketConfig config, KeyStoreAndKeyCertOptions ks, TrustStoreAndTrustOptions ts) {
        this.config = config;
        this.vertx = vertx;
        this.name = name;
        if (ks != null) {
            this.keyStoreOptions = ks.options;
            this.keyStore = ks.keyStore;
        } else {
            this.keyStoreOptions = null;
            this.keyStore = null;
        }
        if (ts != null) {
            this.trustOptions = ts.options;
            this.trustStore = ts.trustStore;
        } else {
            this.trustOptions = null;
            this.trustStore = null;
        }
        this.crls = new ArrayList<Buffer>();
        if (this.config().certificateRevocationList().isPresent()) {
            for (Path path : this.config().certificateRevocationList().get()) {
                byte[] bytes = TlsConfigUtils.read(path);
                this.crls.add(Buffer.buffer((byte[])bytes));
            }
        }
    }

    public synchronized KeyCertOptions getKeyStoreOptions() {
        return this.keyStoreOptions;
    }

    public synchronized KeyStore getKeyStore() {
        return this.keyStore;
    }

    public synchronized TrustOptions getTrustStoreOptions() {
        return this.trustOptions;
    }

    public synchronized KeyStore getTrustStore() {
        return this.trustStore;
    }

    public synchronized SSLContext createSSLContext() throws Exception {
        KeyManager[] keyManagers = null;
        if (this.keyStoreOptions != null) {
            KeyManagerFactory keyManagerFactory = this.keyStoreOptions.getKeyManagerFactory(this.vertx);
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        TrustManager[] trustManagers = null;
        if (this.trustOptions != null) {
            TrustManagerFactory trustManagerFactory = this.trustOptions.getTrustManagerFactory(this.vertx);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, new SecureRandom());
        return sslContext;
    }

    public synchronized SSLOptions getSSLOptions() {
        SSLOptions options = new SSLOptions();
        options.setKeyCertOptions(this.getKeyStoreOptions());
        options.setTrustOptions(this.getTrustStoreOptions());
        options.setUseAlpn(this.config().alpn());
        options.setSslHandshakeTimeoutUnit(TimeUnit.SECONDS);
        options.setSslHandshakeTimeout(this.config().handshakeTimeout().toSeconds());
        options.setEnabledSecureTransportProtocols(this.config().protocols());
        this.warnIfOldProtocols(options.getEnabledSecureTransportProtocols(), this.name);
        for (Buffer buffer : this.crls) {
            options.addCrlValue(buffer);
        }
        for (String cipher : this.config().cipherSuites().orElse(Collections.emptyList())) {
            options.addEnabledCipherSuite(cipher);
        }
        return options;
    }

    boolean warnIfOldProtocols(Set<String> protocols, String name) {
        List<String> list = protocols.stream().map(String::toLowerCase).map(String::trim).toList();
        if (list.size() == 1 && list.get(0).equalsIgnoreCase("TLSv1.3")) {
            return false;
        }
        boolean warned = false;
        if (list.stream().anyMatch(p -> p.startsWith("ssl"))) {
            LOGGER.warnf("Insecure SSL protocol is enabled in TLS bucket '%s'. It is strongly recommended to disable SSL protocols (SSLv2, SSLv3), and use at least TLSv1.3.", (Object)name);
            warned = true;
        }
        if (list.contains("tlsv1") || list.contains("tlsv1.1")) {
            LOGGER.warnf("Insecure TLS protocol TLSv1.0 or TLSv1.1 is enabled in TLS bucket '%s'. It is strongly recommended to disable TLSv1.0 and TLSv1.1, and use at least TLSv1.3.", (Object)name);
            warned = true;
        }
        boolean isUsingModernTlsVersion = false;
        for (String p2 : list) {
            if (!this.isRecentOrFutureTLSVersion(p2)) continue;
            isUsingModernTlsVersion = true;
            break;
        }
        if (!isUsingModernTlsVersion) {
            LOGGER.warnf("TLSv1.3 or higher protocol is not enabled in TLS bucket '%s'. It is *strongly* recommended to enable TLSv1.3 or higher.", (Object)name);
            warned = true;
        }
        return warned;
    }

    private boolean isRecentOrFutureTLSVersion(String protocol) {
        if (!protocol.startsWith("tlsv")) {
            return false;
        }
        String afterTlsv = protocol.substring(4);
        if (afterTlsv.isEmpty()) {
            return false;
        }
        char majorChar = afterTlsv.charAt(0);
        if (afterTlsv.startsWith("1.")) {
            String minorVersion = afterTlsv.substring(2);
            if (minorVersion.isEmpty()) {
                return false;
            }
            if (minorVersion.length() == 1) {
                char minorChar = minorVersion.charAt(0);
                return minorChar >= '3' && minorChar <= '9';
            }
            return true;
        }
        return majorChar >= '2' && majorChar <= '9';
    }

    public boolean isTrustAll() {
        return this.config().trustAll() || this.getTrustStoreOptions() == TrustAllOptions.INSTANCE;
    }

    public Optional<String> getHostnameVerificationAlgorithm() {
        return this.config.hostnameVerificationAlgorithm();
    }

    public boolean usesSni() {
        if (this.config.keyStore().isPresent()) {
            return this.config.keyStore().get().sni();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reload() {
        if (this.keyStore == null && this.trustStore == null) {
            return false;
        }
        KeyStoreAndKeyCertOptions keyStoreUpdateResult = null;
        TrustStoreAndTrustOptions trustStoreUpdateResult = null;
        if (this.keyStore != null) {
            try {
                keyStoreUpdateResult = CertificateRecorder.getKeyStore(this.config, this.vertx, this.name);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.trustStore != null) {
            try {
                trustStoreUpdateResult = CertificateRecorder.getTrustStore(this.config, this.vertx, this.name);
            }
            catch (Exception e) {
                return false;
            }
        } else if (this.config.trustAll()) {
            trustStoreUpdateResult = new TrustStoreAndTrustOptions(null, TrustAllOptions.INSTANCE);
        }
        if (keyStoreUpdateResult == null && trustStoreUpdateResult == null) {
            return false;
        }
        ArrayList<Buffer> newCRLs = new ArrayList<Buffer>();
        if (this.config().certificateRevocationList().isPresent()) {
            for (Path path : this.config().certificateRevocationList().get()) {
                byte[] bytes = TlsConfigUtils.read(path);
                newCRLs.add(Buffer.buffer((byte[])bytes));
            }
        }
        VertxCertificateHolder vertxCertificateHolder = this;
        synchronized (vertxCertificateHolder) {
            this.keyStoreOptions = keyStoreUpdateResult != null ? keyStoreUpdateResult.options : null;
            this.keyStore = keyStoreUpdateResult != null ? keyStoreUpdateResult.keyStore : null;
            this.trustOptions = trustStoreUpdateResult != null ? trustStoreUpdateResult.options : null;
            this.trustStore = trustStoreUpdateResult != null ? trustStoreUpdateResult.trustStore : null;
            this.crls.clear();
            this.crls.addAll(newCRLs);
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public TlsBucketConfig config() {
        return this.config;
    }
}

