/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.deployment;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Capability;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.util.HashUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.deployment.ScheduledBusinessMethodItem;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import io.quarkus.scheduler.runtime.ScheduledMethodMetadata;
import io.quarkus.scheduler.runtime.SchedulerConfig;
import io.quarkus.scheduler.runtime.SchedulerContext;
import io.quarkus.scheduler.runtime.SchedulerRecorder;
import io.quarkus.scheduler.runtime.SimpleScheduler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SchedulerProcessor {
    private static final Logger LOGGER = Logger.getLogger(SchedulerProcessor.class);
    static final DotName SCHEDULED_NAME = DotName.createSimple((String)Scheduled.class.getName());
    static final DotName SCHEDULES_NAME = DotName.createSimple((String)Scheduled.Schedules.class.getName());
    static final Type SCHEDULED_EXECUTION_TYPE = Type.create((DotName)DotName.createSimple((String)ScheduledExecution.class.getName()), (Type.Kind)Type.Kind.CLASS);
    static final String INVOKER_SUFFIX = "_ScheduledInvoker";

    @BuildStep
    void beans(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (capabilities.isMissing(Capability.QUARTZ)) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SimpleScheduler.class}));
        }
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationTransformer(final CustomScopeAnnotationsBuildItem scopes) {
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                ClassInfo target = context.getTarget().asClass();
                if (!scopes.isScopeIn(context.getAnnotations()) && (target.annotations().containsKey(SCHEDULED_NAME) || target.annotations().containsKey(SCHEDULES_NAME))) {
                    LOGGER.debugf("Found scheduled business methods on a class %s with no scope defined - adding @Singleton", (Object)context.getTarget());
                    ((Transformation)context.transform().add(Singleton.class, new AnnotationValue[0])).done();
                }
            }
        });
    }

    @BuildStep
    void collectScheduledMethods(BeanArchiveIndexBuildItem beanArchives, BeanRegistrationPhaseBuildItem beanRegistrationPhase, BuildProducer<ScheduledBusinessMethodItem> scheduledBusinessMethods, BuildProducer<BeanRegistrationPhaseBuildItem.BeanConfiguratorBuildItem> beans) {
        AnnotationStore annotationStore = (AnnotationStore)beanRegistrationPhase.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : beanRegistrationPhase.getContext().beans().classBeans()) {
            this.collectScheduledMethods(beanArchives.getIndex(), annotationStore, bean, ((AnnotationTarget)bean.getTarget().get()).asClass(), scheduledBusinessMethods);
        }
    }

    private void collectScheduledMethods(IndexView index, AnnotationStore annotationStore, BeanInfo bean, ClassInfo beanClass, BuildProducer<ScheduledBusinessMethodItem> scheduledBusinessMethods) {
        ClassInfo superClass;
        for (MethodInfo method : beanClass.methods()) {
            List<AnnotationInstance> schedules = null;
            AnnotationInstance scheduledAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, SCHEDULED_NAME);
            if (scheduledAnnotation != null) {
                schedules = Collections.singletonList(scheduledAnnotation);
            } else {
                AnnotationInstance scheduledsAnnotation = annotationStore.getAnnotation((AnnotationTarget)method, SCHEDULES_NAME);
                if (scheduledsAnnotation != null) {
                    schedules = new ArrayList<AnnotationInstance>();
                    for (AnnotationInstance scheduledInstance : scheduledsAnnotation.value().asNestedArray()) {
                        schedules.add(scheduledInstance);
                    }
                }
            }
            if (schedules == null) continue;
            scheduledBusinessMethods.produce((BuildItem)new ScheduledBusinessMethodItem(bean, method, schedules));
            LOGGER.debugf("Found scheduled business method %s declared on %s", (Object)method, (Object)bean);
        }
        DotName superClassName = beanClass.superName();
        if (superClassName != null && (superClass = index.getClassByName(superClassName)) != null) {
            this.collectScheduledMethods(index, annotationStore, bean, superClass, scheduledBusinessMethods);
        }
    }

    @BuildStep
    void validateScheduledBusinessMethods(SchedulerConfig config, List<ScheduledBusinessMethodItem> scheduledMethods, ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        HashMap<String, AnnotationInstance> encounteredIdentities = new HashMap<String, AnnotationInstance>();
        for (ScheduledBusinessMethodItem scheduledMethod : scheduledMethods) {
            MethodInfo method = scheduledMethod.getMethod();
            List params = method.parameters();
            if (params.size() > 1 || params.size() == 1 && !((Type)params.get(0)).equals((Object)SCHEDULED_EXECUTION_TYPE)) {
                errors.add(new IllegalStateException(String.format("Invalid scheduled business method parameters %s [method: %s, bean: %s]", params, method, scheduledMethod.getBean())));
            }
            if (!method.returnType().kind().equals((Object)Type.Kind.VOID)) {
                errors.add(new IllegalStateException(String.format("Scheduled business method must return void [method: %s, bean: %s]", method, scheduledMethod.getBean())));
            }
            CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)config.cronType));
            for (AnnotationInstance scheduled : scheduledMethod.getSchedules()) {
                Throwable error = this.validateScheduled(parser, scheduled, encounteredIdentities);
                if (error == null) continue;
                errors.add(error);
            }
        }
        if (!errors.isEmpty()) {
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(errors));
        }
    }

    @BuildStep
    public List<UnremovableBeanBuildItem> unremovableBeans() {
        return Arrays.asList(new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SCHEDULED_NAME)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SCHEDULES_NAME)));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public FeatureBuildItem build(SchedulerConfig config, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, SchedulerRecorder recorder, List<ScheduledBusinessMethodItem> scheduledMethods, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, AnnotationProxyBuildItem annotationProxy, ExecutorBuildItem executor) {
        ArrayList<ScheduledMethodMetadata> scheduledMetadata = new ArrayList<ScheduledMethodMetadata>();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClass, true);
        for (ScheduledBusinessMethodItem businessMethod : scheduledMethods) {
            ScheduledMethodMetadata scheduledMethod = new ScheduledMethodMetadata();
            String invokerClass = this.generateInvoker(businessMethod.getBean(), businessMethod.getMethod(), (ClassOutput)classOutput);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{invokerClass}));
            scheduledMethod.setInvokerClassName(invokerClass);
            ArrayList<Object> schedules = new ArrayList<Object>();
            for (AnnotationInstance scheduled : businessMethod.getSchedules()) {
                schedules.add(annotationProxy.builder(scheduled, Scheduled.class).build((ClassOutput)classOutput));
            }
            scheduledMethod.setSchedules(schedules);
            scheduledMethod.setMethodDescription(businessMethod.getMethod().declaringClass() + "#" + businessMethod.getMethod().name());
            scheduledMetadata.add(scheduledMethod);
        }
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(SchedulerContext.class).setRuntimeInit().supplier(recorder.createContext(config, executor.getExecutorProxy(), scheduledMetadata)).done());
        return new FeatureBuildItem(Feature.SCHEDULER);
    }

    private String generateInvoker(BeanInfo bean, MethodInfo method, ClassOutput classOutput) {
        String baseName = bean.getImplClazz().enclosingClass() != null ? DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + "_" + DotNames.simpleName((DotName)bean.getImplClazz().name()) : DotNames.simpleName((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String targetPackage = DotNames.packageName((DotName)bean.getImplClazz().name());
        String generatedName = targetPackage.replace('.', '/') + "/" + baseName + INVOKER_SUFFIX + "_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        ClassCreator invokerCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new Class[]{ScheduledInvoker.class}).build();
        MethodCreator invoke = invokerCreator.getMethodCreator("invokeBean", Void.TYPE, new Class[]{Object.class});
        ResultHandle containerHandle = invoke.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle beanHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class}), containerHandle, new ResultHandle[]{invoke.load(bean.getIdentifier())});
        ResultHandle instanceHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class}), containerHandle, new ResultHandle[]{beanHandle});
        ResultHandle beanInstanceHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        if (method.parameters().isEmpty()) {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[0]), beanInstanceHandle, new ResultHandle[0]);
        } else {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{ScheduledExecution.class}), beanInstanceHandle, new ResultHandle[]{invoke.getMethodParam(0)});
        }
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"destroy", Void.TYPE, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        }
        invoke.returnValue(null);
        invokerCreator.close();
        return generatedName.replace('/', '.');
    }

    private Throwable validateScheduled(CronParser parser, AnnotationInstance schedule, Map<String, AnnotationInstance> encounteredIdentities) {
        AnnotationValue identityValue;
        AnnotationValue delayedValue;
        AnnotationValue cronValue = schedule.value("cron");
        if (cronValue != null && !cronValue.asString().trim().isEmpty()) {
            String cron = cronValue.asString().trim();
            if (SchedulerContext.isConfigValue((String)cron)) {
                return null;
            }
            try {
                parser.parse(cron).validate();
            }
            catch (IllegalArgumentException e) {
                return new IllegalStateException("Invalid cron() expression on: " + schedule, e);
            }
        } else {
            AnnotationValue everyValue = schedule.value("every");
            if (everyValue != null && !everyValue.asString().trim().isEmpty()) {
                String every = everyValue.asString().trim();
                if (SchedulerContext.isConfigValue((String)every)) {
                    return null;
                }
                if (Character.isDigit(every.charAt(0))) {
                    every = "PT" + every;
                }
                try {
                    Duration.parse(every);
                }
                catch (Exception e) {
                    return new IllegalStateException("Invalid every() expression on: " + schedule, e);
                }
            } else {
                return new IllegalStateException("@Scheduled must declare either cron() or every(): " + schedule);
            }
        }
        if (schedule.value("delay") == null && (delayedValue = schedule.value("delayed")) != null && !delayedValue.asString().trim().isEmpty()) {
            String delayed = delayedValue.asString().trim();
            if (SchedulerContext.isConfigValue((String)delayed)) {
                return null;
            }
            if (Character.isDigit(delayed.charAt(0))) {
                delayed = "PT" + delayed;
            }
            try {
                Duration.parse(delayed);
            }
            catch (Exception e) {
                return new IllegalStateException("Invalid delayed() expression on: " + schedule, e);
            }
        }
        if ((identityValue = schedule.value("identity")) != null) {
            String identity = identityValue.asString().trim();
            AnnotationInstance previousInstanceWithSameIdentity = encounteredIdentities.get(identity);
            if (previousInstanceWithSameIdentity != null) {
                String message = String.format("The identity: \"%s\" on: %s is not unique and it has already bean used by : %s", identity, schedule, previousInstanceWithSameIdentity);
                return new IllegalStateException(message);
            }
            encounteredIdentities.put(identity, schedule);
        }
        return null;
    }
}

