/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.restclient.config;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.FallbackConfigSourceInterceptor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

public class RestClientFallbackConfigSourceInterceptor
extends FallbackConfigSourceInterceptor {
    private static final String QUARKUS_CONFIG_PREFIX = "quarkus.rest-client.";
    private static final String MP_REST = "/mp-rest/";
    private static final String MAX_REDIRECTS = "max-redirects";
    private static final String MAX_REDIRECTS_LEGACY_PROPERTY = "quarkus.rest.client.max-redirects";
    private static final Map<String, String> CLIENT_PROPERTIES;
    private static final Map<String, String> CLIENT_PROPERTIES_INVERSE;
    private static final Map<String, String> GLOBAL_PROPERTIES;
    private static final Map<String, String> GLOBAL_PROPERTIES_INVERSE;
    private static final Function<String, String> MAPPING_FUNCTION;

    public RestClientFallbackConfigSourceInterceptor() {
        super(MAPPING_FUNCTION);
    }

    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<Object> names = new HashSet<Object>();
        Iterator namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            String name = (String)namesIterator.next();
            names.add(name);
            if (name.startsWith("%")) continue;
            String[] prefixAndProperty = RestClientFallbackConfigSourceInterceptor.extractMPClientPrefixAndProperty(name);
            if (prefixAndProperty != null) {
                String clientPrefix = prefixAndProperty[0];
                String mpPropertyName = prefixAndProperty[1];
                String quarkusPropertyName = CLIENT_PROPERTIES_INVERSE.get(mpPropertyName);
                if (quarkusPropertyName == null) continue;
                names.add(QUARKUS_CONFIG_PREFIX + clientPrefix + "." + quarkusPropertyName);
                continue;
            }
            if (!GLOBAL_PROPERTIES_INVERSE.containsKey(name)) continue;
            names.add(GLOBAL_PROPERTIES_INVERSE.get(name));
        }
        return names.iterator();
    }

    static String[] extractQuarkusClientPrefixAndProperty(String key) {
        for (int i = 0; i < key.length(); ++i) {
            if (key.charAt(i) == '\"') {
                while (++i < key.length() && key.charAt(i) != '\"') {
                }
            }
            if (i >= key.length() || key.charAt(i) != '.') continue;
            return new String[]{key.substring(0, i), key.substring(i + 1)};
        }
        return new String[]{null, key};
    }

    static String[] extractMPClientPrefixAndProperty(String key) {
        int delimiterIdx = key.indexOf(MP_REST);
        if (delimiterIdx > 0) {
            Object prefix = key.substring(0, delimiterIdx);
            if (((String)prefix).contains(".")) {
                prefix = "\"" + (String)prefix + "\"";
            }
            String property = key.substring(delimiterIdx + MP_REST.length());
            return new String[]{prefix, property};
        }
        return null;
    }

    private static Map<String, String> inverseMap(Map<String, String> map) {
        HashMap<String, String> inverse = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            inverse.put(entry.getValue(), entry.getKey());
        }
        return inverse;
    }

    static {
        MAPPING_FUNCTION = new MappingFunction();
        CLIENT_PROPERTIES = new HashMap<String, String>();
        CLIENT_PROPERTIES.put("url", "url");
        CLIENT_PROPERTIES.put("uri", "uri");
        CLIENT_PROPERTIES.put("scope", "scope");
        CLIENT_PROPERTIES.put("providers", "providers");
        CLIENT_PROPERTIES.put("connect-timeout", "connectTimeout");
        CLIENT_PROPERTIES.put("read-timeout", "readTimeout");
        CLIENT_PROPERTIES.put("hostname-verifier", "hostnameVerifier");
        CLIENT_PROPERTIES.put("verify-host", "verifyHost");
        CLIENT_PROPERTIES.put("trust-store", "trustStore");
        CLIENT_PROPERTIES.put("trust-store-password", "trustStorePassword");
        CLIENT_PROPERTIES.put("trust-store-type", "trustStoreType");
        CLIENT_PROPERTIES.put("key-store", "keyStore");
        CLIENT_PROPERTIES.put("key-store-password", "keyStorePassword");
        CLIENT_PROPERTIES.put("key-store-type", "keyStoreType");
        CLIENT_PROPERTIES.put("tls-configuration-name", "tlsConfigurationName");
        CLIENT_PROPERTIES.put("follow-redirects", "followRedirects");
        CLIENT_PROPERTIES.put("proxy-address", "proxyAddress");
        CLIENT_PROPERTIES.put("query-param-style", "queryParamStyle");
        CLIENT_PROPERTIES_INVERSE = RestClientFallbackConfigSourceInterceptor.inverseMap(CLIENT_PROPERTIES);
        GLOBAL_PROPERTIES = new HashMap<String, String>();
        GLOBAL_PROPERTIES.put("quarkus.rest-client.multipart-post-encoder-mode", "quarkus.rest.client.multipart-post-encoder-mode");
        GLOBAL_PROPERTIES_INVERSE = RestClientFallbackConfigSourceInterceptor.inverseMap(GLOBAL_PROPERTIES);
    }

    private static class MappingFunction
    implements Function<String, String> {
        private MappingFunction() {
        }

        @Override
        public String apply(String key) {
            if (key.startsWith(RestClientFallbackConfigSourceInterceptor.QUARKUS_CONFIG_PREFIX)) {
                String remainder = key.substring(RestClientFallbackConfigSourceInterceptor.QUARKUS_CONFIG_PREFIX.length());
                String[] prefixAndProperty = RestClientFallbackConfigSourceInterceptor.extractQuarkusClientPrefixAndProperty(remainder);
                if (prefixAndProperty[0] != null && CLIENT_PROPERTIES.containsKey(prefixAndProperty[1])) {
                    String clientPrefix = prefixAndProperty[0];
                    if (clientPrefix.startsWith("\"") && clientPrefix.endsWith("\"")) {
                        clientPrefix = clientPrefix.substring(1, clientPrefix.length() - 1);
                    }
                    return clientPrefix + RestClientFallbackConfigSourceInterceptor.MP_REST + CLIENT_PROPERTIES.get(prefixAndProperty[1]);
                }
                if (prefixAndProperty[0] == null && GLOBAL_PROPERTIES.containsKey(key)) {
                    return GLOBAL_PROPERTIES.get(key);
                }
                if (prefixAndProperty[0] != null && RestClientFallbackConfigSourceInterceptor.MAX_REDIRECTS.equals(prefixAndProperty[1])) {
                    return RestClientFallbackConfigSourceInterceptor.MAX_REDIRECTS_LEGACY_PROPERTY;
                }
            }
            return key;
        }
    }
}

