/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.deployment;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.qute.Namespaces;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public final class TemplateGlobalBuildItem
extends MultiBuildItem {
    private final String name;
    private final AnnotationTarget target;
    private final Type variableType;

    public TemplateGlobalBuildItem(String name, AnnotationTarget target, Type matchType) {
        if (!Namespaces.isValidNamespace((String)name)) {
            throw new IllegalArgumentException(String.format("Invalid global variable name found: %s\n\t- supplied by %s \n\t- a name may only consist of alphanumeric characters and underscores: ", name, target.kind() == AnnotationTarget.Kind.FIELD ? target.asField().declaringClass().name() + "." + target.asField().name() : target.asMethod().declaringClass().name() + "." + target.asMethod().name() + "()"));
        }
        this.name = name;
        this.target = target;
        this.variableType = matchType;
    }

    public AnnotationTarget getTarget() {
        return this.target;
    }

    public Type getVariableType() {
        return this.variableType;
    }

    public boolean isField() {
        return this.target.kind() == AnnotationTarget.Kind.FIELD;
    }

    public boolean isMethod() {
        return this.target.kind() == AnnotationTarget.Kind.METHOD;
    }

    public String getName() {
        return this.name;
    }

    public DotName getDeclaringClass() {
        return this.isField() ? this.target.asField().declaringClass().name() : this.target.asMethod().declaringClass().name();
    }

    public String toString() {
        return "Variable [" + this.name + "] supplied by " + this.getDeclaringClass() + "." + (String)(this.isField() ? this.target.asField().name() : this.target.asMethod().name() + "()");
    }
}

