/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.instrumentation;

import io.opentelemetry.api.OpenTelemetry;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.opentelemetry.runtime.config.build.OTelBuildConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.vertx.EventBusInstrumenterVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.vertx.HttpInstrumenterVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.vertx.OpenTelemetryVertxHttpMetricsFactory;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.vertx.OpenTelemetryVertxMetricsFactory;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.vertx.OpenTelemetryVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.vertx.OpenTelemetryVertxTracingFactory;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.vertx.RedisClientInstrumenterVertxTracer;
import io.quarkus.opentelemetry.runtime.tracing.instrumentation.vertx.SqlClientInstrumenterVertxTracer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.core.VertxOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.VertxTracerFactory;
import io.vertx.core.tracing.TracingOptions;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.function.Consumer;

@Recorder
public class InstrumentationRecorder {
    public static final OpenTelemetryVertxTracingFactory FACTORY = new OpenTelemetryVertxTracingFactory();
    private final OTelBuildConfig buildConfig;
    private final RuntimeValue<OTelRuntimeConfig> runtimeConfig;

    public InstrumentationRecorder(OTelBuildConfig buildConfig, RuntimeValue<OTelRuntimeConfig> runtimeConfig) {
        this.buildConfig = buildConfig;
        this.runtimeConfig = runtimeConfig;
    }

    public Consumer<VertxOptions> getVertxTracingOptions() {
        if (((OTelRuntimeConfig)this.runtimeConfig.getValue()).sdkDisabled()) {
            return vertxOptions -> {};
        }
        TracingOptions tracingOptions = new TracingOptions().setFactory((VertxTracerFactory)FACTORY);
        return vertxOptions -> vertxOptions.setTracingOptions(tracingOptions);
    }

    public void setupVertxTracer(BeanContainer beanContainer, boolean sqlClientAvailable, boolean redisClientAvailable) {
        OpenTelemetry openTelemetry = (OpenTelemetry)beanContainer.beanInstance(OpenTelemetry.class, new Annotation[0]);
        if (((OTelRuntimeConfig)this.runtimeConfig.getValue()).sdkDisabled()) {
            return;
        }
        ArrayList tracers = new ArrayList(4);
        if (((OTelRuntimeConfig)this.runtimeConfig.getValue()).instrument().vertxHttp()) {
            tracers.add(new HttpInstrumenterVertxTracer(openTelemetry, (OTelRuntimeConfig)this.runtimeConfig.getValue(), this.buildConfig));
        }
        if (((OTelRuntimeConfig)this.runtimeConfig.getValue()).instrument().vertxEventBus()) {
            tracers.add(new EventBusInstrumenterVertxTracer(openTelemetry, (OTelRuntimeConfig)this.runtimeConfig.getValue()));
        }
        if (sqlClientAvailable && ((OTelRuntimeConfig)this.runtimeConfig.getValue()).instrument().vertxSqlClient()) {
            tracers.add(new SqlClientInstrumenterVertxTracer(openTelemetry, (OTelRuntimeConfig)this.runtimeConfig.getValue()));
        }
        if (redisClientAvailable && ((OTelRuntimeConfig)this.runtimeConfig.getValue()).instrument().vertxRedisClient()) {
            tracers.add(new RedisClientInstrumenterVertxTracer(openTelemetry, (OTelRuntimeConfig)this.runtimeConfig.getValue()));
        }
        OpenTelemetryVertxTracer openTelemetryVertxTracer = new OpenTelemetryVertxTracer(tracers);
        FACTORY.getVertxTracerDelegator().setDelegate(openTelemetryVertxTracer);
    }

    public Consumer<VertxOptions> getVertxHttpMetricsOptions() {
        MetricsOptions metricsOptions = new MetricsOptions().setEnabled(true).setFactory((VertxMetricsFactory)new OpenTelemetryVertxHttpMetricsFactory());
        return vertxOptions -> vertxOptions.setMetricsOptions(metricsOptions);
    }

    public Consumer<VertxOptions> getVertxMetricsOptions() {
        MetricsOptions metricsOptions = new MetricsOptions().setEnabled(true).setFactory((VertxMetricsFactory)new OpenTelemetryVertxMetricsFactory());
        return vertxOptions -> vertxOptions.setMetricsOptions(metricsOptions);
    }
}

