/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.junit.DisableIfBuiltWithGraalVMOlderThan;
import io.quarkus.test.junit.IntegrationTestUtil;
import io.quarkus.test.junit.NativeImageTest;
import io.quarkus.test.junit.QuarkusIntegrationTest;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class DisableIfBuiltWithGraalVMOlderThanCondition
implements ExecutionCondition {
    private static final String QUARKUS_INTEGRATION_TEST_NAME = QuarkusIntegrationTest.class.getName();
    private static final String NATIVE_IMAGE_TEST_NAME = NativeImageTest.class.getName();
    private static final Set<String> SUPPORTED_INTEGRATION_TESTS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(QUARKUS_INTEGRATION_TEST_NAME, NATIVE_IMAGE_TEST_NAME)));

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        Optional optional = AnnotationUtils.findAnnotation((Optional)element, DisableIfBuiltWithGraalVMOlderThan.class);
        if (!optional.isPresent()) {
            return ConditionEvaluationResult.enabled((String)"@DisableIfBuiltWithGraalVMOlderThan was not found");
        }
        if (!this.isIntegrationTest(context.getRequiredTestClass())) {
            return ConditionEvaluationResult.enabled((String)"@DisableIfBuiltWithGraalVMOlderThan was added to an unsupported test");
        }
        DisableIfBuiltWithGraalVMOlderThan.GraalVMVersion annotationValue = ((DisableIfBuiltWithGraalVMOlderThan)optional.get()).value();
        Properties quarkusArtifactProperties = IntegrationTestUtil.readQuarkusArtifactProperties(context);
        try {
            int major = Integer.parseInt(quarkusArtifactProperties.getProperty("metadata.graalvm.version.major"));
            int minor = Integer.parseInt(quarkusArtifactProperties.getProperty("metadata.graalvm.version.minor"));
            int comparison = annotationValue.compareTo(major, minor);
            if (comparison > 0) {
                return ConditionEvaluationResult.disabled((String)("Native binary was built with GraalVM{major=" + major + ", minor= " + minor + "} but the test is disabled for GraalVM versions older than " + annotationValue));
            }
            return ConditionEvaluationResult.enabled((String)"Native binary was built with a GraalVM version compatible with the required version by the test");
        }
        catch (NumberFormatException e) {
            return ConditionEvaluationResult.disabled((String)"Unable to determine the GraalVM version with which the native binary was built");
        }
    }

    private boolean isIntegrationTest(Class<?> testClass) {
        do {
            Annotation[] annotations;
            for (Annotation annotation : annotations = testClass.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                String annotationTypeName = annotationType.getName();
                if (!SUPPORTED_INTEGRATION_TESTS.contains(annotationTypeName)) continue;
                return true;
            }
        } while ((testClass = testClass.getSuperclass()) != Object.class);
        return false;
    }
}

