/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.junit.DisabledOnNativeImage;
import io.quarkus.test.junit.NativeImageTest;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.StringUtils;

public class DisabledOnNativeImageCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"@DisabledOnNativeImage is not present");

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        boolean nativeImage;
        Optional element = context.getElement();
        Optional disabled = AnnotationUtils.findAnnotation((Optional)element, DisabledOnNativeImage.class);
        if (disabled.isPresent() && (nativeImage = AnnotationUtils.findAnnotation((Optional)context.getTestClass(), NativeImageTest.class).isPresent())) {
            String reason = disabled.map(DisabledOnNativeImage::value).filter(StringUtils::isNotBlank).orElseGet(() -> element.get() + " is @DisabledOnNativeImage");
            return ConditionEvaluationResult.disabled((String)reason);
        }
        return ENABLED;
    }
}

