/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.flyway.runtime.FlywayDataSourceBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayDataSourceRuntimeConfig;
import io.quarkus.flyway.runtime.QuarkusFlywayClassProvider;
import io.quarkus.flyway.runtime.QuarkusFlywayResourceProvider;
import io.quarkus.flyway.runtime.QuarkusPathLocationScanner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.FluentConfiguration;

class FlywayCreator {
    private static final String[] EMPTY_ARRAY = new String[0];
    private final FlywayDataSourceRuntimeConfig flywayRuntimeConfig;
    private final FlywayDataSourceBuildTimeConfig flywayBuildTimeConfig;
    private Collection<Callback> callbacks = Collections.emptyList();

    public FlywayCreator(FlywayDataSourceRuntimeConfig flywayRuntimeConfig, FlywayDataSourceBuildTimeConfig flywayBuildTimeConfig) {
        this.flywayRuntimeConfig = flywayRuntimeConfig;
        this.flywayBuildTimeConfig = flywayBuildTimeConfig;
    }

    public FlywayCreator withCallbacks(Collection<Callback> callbacks) {
        this.callbacks = callbacks;
        return this;
    }

    public Flyway createFlyway(DataSource dataSource) {
        FluentConfiguration configure = Flyway.configure();
        configure.dataSource(dataSource);
        if (this.flywayRuntimeConfig.initSql.isPresent()) {
            configure.initSql(this.flywayRuntimeConfig.initSql.get());
        }
        if (this.flywayRuntimeConfig.connectRetries.isPresent()) {
            configure.connectRetries(this.flywayRuntimeConfig.connectRetries.getAsInt());
        }
        if (this.flywayRuntimeConfig.schemas.isPresent()) {
            configure.schemas(this.flywayRuntimeConfig.schemas.get().toArray(EMPTY_ARRAY));
        }
        if (this.flywayRuntimeConfig.table.isPresent()) {
            configure.table(this.flywayRuntimeConfig.table.get());
        }
        configure.locations(this.flywayBuildTimeConfig.locations.toArray(EMPTY_ARRAY));
        if (this.flywayRuntimeConfig.sqlMigrationPrefix.isPresent()) {
            configure.sqlMigrationPrefix(this.flywayRuntimeConfig.sqlMigrationPrefix.get());
        }
        if (this.flywayRuntimeConfig.repeatableSqlMigrationPrefix.isPresent()) {
            configure.repeatableSqlMigrationPrefix(this.flywayRuntimeConfig.repeatableSqlMigrationPrefix.get());
        }
        configure.baselineOnMigrate(this.flywayRuntimeConfig.baselineOnMigrate);
        configure.validateOnMigrate(this.flywayRuntimeConfig.validateOnMigrate);
        configure.ignoreMissingMigrations(this.flywayRuntimeConfig.ignoreMissingMigrations);
        configure.ignoreFutureMigrations(this.flywayRuntimeConfig.ignoreFutureMigrations);
        configure.outOfOrder(this.flywayRuntimeConfig.outOfOrder);
        if (this.flywayRuntimeConfig.baselineVersion.isPresent()) {
            configure.baselineVersion(this.flywayRuntimeConfig.baselineVersion.get());
        }
        if (this.flywayRuntimeConfig.baselineDescription.isPresent()) {
            configure.baselineDescription(this.flywayRuntimeConfig.baselineDescription.get());
        }
        configure.placeholders(this.flywayRuntimeConfig.placeholders);
        configure.createSchemas(this.flywayRuntimeConfig.createSchemas);
        if (this.flywayRuntimeConfig.placeholderPrefix.isPresent()) {
            configure.placeholderPrefix(this.flywayRuntimeConfig.placeholderPrefix.get());
        }
        if (this.flywayRuntimeConfig.placeholderSuffix.isPresent()) {
            configure.placeholderSuffix(this.flywayRuntimeConfig.placeholderSuffix.get());
        }
        if (!this.callbacks.isEmpty()) {
            configure.callbacks(this.callbacks.toArray(new Callback[0]));
        }
        QuarkusPathLocationScanner quarkusPathLocationScanner = new QuarkusPathLocationScanner(Arrays.asList(configure.getLocations()));
        configure.javaMigrationClassProvider(new QuarkusFlywayClassProvider(quarkusPathLocationScanner.scanForClasses()));
        configure.resourceProvider((ResourceProvider)new QuarkusFlywayResourceProvider(quarkusPathLocationScanner.scanForResources()));
        return configure.load();
    }
}

