/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update;

import io.quarkus.devtools.project.update.ExtensionUpdateInfo;
import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProjectExtensionsUpdateInfo {
    private final Map<String, List<ExtensionUpdateInfo>> extensionsByProvider;

    public ProjectExtensionsUpdateInfo(Map<String, List<ExtensionUpdateInfo>> extensionsByProvider) {
        this.extensionsByProvider = extensionsByProvider;
    }

    public Map<String, List<ExtensionUpdateInfo>> extensionsByProvider() {
        return this.extensionsByProvider;
    }

    public boolean containsProvider(String provider) {
        return this.extensionsByProvider.containsKey(provider);
    }

    public OptionalInt getMinJavaVersion() {
        return this.streamExtensions().mapToInt(e -> Optional.ofNullable(ExtensionProcessor.getMinimumJavaVersion(e.getRecommendedMetadata())).orElse(11)).max();
    }

    private Stream<ExtensionUpdateInfo> streamExtensions() {
        return this.extensionsByProvider.values().stream().flatMap(Collection::stream);
    }

    public List<ExtensionUpdateInfo> getSimpleVersionUpdates() {
        return this.streamExtensions().filter(ExtensionUpdateInfo::isSimpleVersionUpdate).collect(Collectors.toList());
    }

    public List<ExtensionUpdateInfo> getVersionUpdates() {
        return this.streamExtensions().filter(ExtensionUpdateInfo::isVersionUpdate).collect(Collectors.toList());
    }

    public boolean shouldUpdateExtensions() {
        return this.streamExtensions().anyMatch(ExtensionUpdateInfo::shouldUpdateExtension);
    }
}

