/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.CodestartResourceLoadersBuilder;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.buildfile.MavenProjectBuildFile;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.ExtensionCatalogResolver;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.config.RegistriesConfig;
import java.nio.file.Path;

public class QuarkusProjectHelper {
    private static RegistriesConfig toolsConfig;
    private static MessageWriter log;
    private static MavenArtifactResolver artifactResolver;
    private static ExtensionCatalogResolver catalogResolver;
    private static boolean registryClientEnabled;

    private static void initRegistryClientEnabled() {
        String value = System.getProperty("quarkusRegistryClient");
        if (value == null) {
            value = System.getenv("QUARKUS_REGISTRY_CLIENT");
        }
        registryClientEnabled = value == null || value.isBlank() || Boolean.parseBoolean(value);
    }

    public static boolean isRegistryClientEnabled() {
        return registryClientEnabled;
    }

    public static BuildTool detectExistingBuildTool(Path projectDirPath) {
        return BuildTool.fromProject(projectDirPath);
    }

    public static QuarkusProject getProject(Path projectDir) {
        BuildTool buildTool = QuarkusProjectHelper.detectExistingBuildTool(projectDir);
        if (buildTool == null) {
            buildTool = BuildTool.MAVEN;
        }
        return QuarkusProjectHelper.getProject(projectDir, buildTool);
    }

    @Deprecated
    public static QuarkusProject getProject(Path projectDir, String quarkusVersion) {
        BuildTool buildTool = QuarkusProjectHelper.detectExistingBuildTool(projectDir);
        if (buildTool == null) {
            buildTool = BuildTool.MAVEN;
        }
        return QuarkusProjectHelper.getProject(projectDir, buildTool, quarkusVersion);
    }

    @Deprecated
    public static QuarkusProject getProject(Path projectDir, BuildTool buildTool, String quarkusVersion) {
        return QuarkusProjectHelper.getProject(projectDir, QuarkusProjectHelper.getExtensionCatalog(quarkusVersion), buildTool);
    }

    @Deprecated
    public static ExtensionCatalog getExtensionCatalog(String quarkusVersion) {
        try {
            if (registryClientEnabled && QuarkusProjectHelper.getCatalogResolver().hasRegistries()) {
                return quarkusVersion == null ? catalogResolver.resolveExtensionCatalog() : catalogResolver.resolveExtensionCatalog(quarkusVersion);
            }
            return ToolsUtils.resolvePlatformDescriptorDirectly(null, null, quarkusVersion, QuarkusProjectHelper.artifactResolver(), QuarkusProjectHelper.messageWriter());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve the Quarkus extension catalog", e);
        }
    }

    public static QuarkusProject getProject(Path projectDir, BuildTool buildTool) {
        ExtensionCatalog catalog;
        if (BuildTool.MAVEN.equals((Object)buildTool)) {
            try {
                return MavenProjectBuildFile.getProject(projectDir, QuarkusProjectHelper.messageWriter(), null);
            }
            catch (RegistryResolutionException e) {
                throw new RuntimeException("Failed to initialize the Quarkus Maven extension manager", e);
            }
        }
        try {
            catalog = QuarkusProjectHelper.resolveExtensionCatalog();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve the Quarkus extension catalog", e);
        }
        return QuarkusProjectHelper.getProject(projectDir, catalog, buildTool, QuarkusProjectHelper.messageWriter());
    }

    public static QuarkusProject getProject(Path projectDir, ExtensionCatalog catalog, BuildTool buildTool) {
        return QuarkusProjectHelper.getProject(projectDir, catalog, buildTool, QuarkusProjectHelper.messageWriter());
    }

    public static QuarkusProject getProject(Path projectDir, ExtensionCatalog catalog, BuildTool buildTool, MessageWriter log) {
        return QuarkusProject.of(projectDir, catalog, CodestartResourceLoadersBuilder.getCodestartResourceLoaders(catalog), log, buildTool);
    }

    public static QuarkusProject getProject(Path projectDir, ExtensionManager extManager) throws RegistryResolutionException {
        return QuarkusProjectHelper.getProject(projectDir, QuarkusProjectHelper.resolveExtensionCatalog(), extManager, QuarkusProjectHelper.messageWriter());
    }

    public static ExtensionCatalog resolveExtensionCatalog() throws RegistryResolutionException {
        return QuarkusProjectHelper.getCatalogResolver().resolveExtensionCatalog();
    }

    public static QuarkusProject getProject(Path projectDir, ExtensionCatalog catalog, ExtensionManager extManager, MessageWriter log) {
        return QuarkusProject.of(projectDir, catalog, CodestartResourceLoadersBuilder.getCodestartResourceLoaders(catalog), log, extManager);
    }

    public static ExtensionCatalogResolver getCatalogResolver() throws RegistryResolutionException {
        return catalogResolver == null ? (catalogResolver = QuarkusProjectHelper.getCatalogResolver(true, QuarkusProjectHelper.messageWriter())) : catalogResolver;
    }

    public static ExtensionCatalogResolver getCatalogResolver(MessageWriter log) throws RegistryResolutionException {
        return QuarkusProjectHelper.getCatalogResolver(true, log);
    }

    public static ExtensionCatalogResolver getCatalogResolver(boolean enableRegistryClient, MessageWriter log) throws RegistryResolutionException {
        if (catalogResolver == null) {
            catalogResolver = enableRegistryClient ? QuarkusProjectHelper.getCatalogResolver(QuarkusProjectHelper.artifactResolver(), log) : ExtensionCatalogResolver.empty();
        }
        return catalogResolver;
    }

    public static ExtensionCatalogResolver getCatalogResolver(MavenArtifactResolver resolver, MessageWriter log) throws RegistryResolutionException {
        return ExtensionCatalogResolver.builder().artifactResolver(resolver).config(QuarkusProjectHelper.toolsConfig()).messageWriter(log).build();
    }

    public static RegistriesConfig toolsConfig() {
        return toolsConfig == null ? (toolsConfig = RegistriesConfig.resolveConfig()) : toolsConfig;
    }

    public static void setToolsConfig(RegistriesConfig config) {
        toolsConfig = config;
    }

    public static void reset() {
        QuarkusProjectHelper.initRegistryClientEnabled();
        toolsConfig = null;
        artifactResolver = null;
        catalogResolver = null;
        log = null;
    }

    public static void setMessageWriter(MessageWriter newLog) {
        if (log == null) {
            log = newLog;
        }
    }

    public static MessageWriter messageWriter() {
        return log == null ? (log = QuarkusProjectHelper.toolsConfig().isDebug() ? MessageWriter.debug() : MessageWriter.info()) : log;
    }

    public static void setArtifactResolver(MavenArtifactResolver resolver) {
        if (artifactResolver == null) {
            artifactResolver = resolver;
        }
    }

    public static MavenArtifactResolver artifactResolver() {
        if (artifactResolver == null) {
            try {
                artifactResolver = ((MavenArtifactResolver.Builder)((MavenArtifactResolver.Builder)MavenArtifactResolver.builder().setArtifactTransferLogging(QuarkusProjectHelper.toolsConfig().isDebug())).setWorkspaceDiscovery(false)).build();
            }
            catch (BootstrapMavenException e) {
                throw new IllegalStateException("Failed to initialize the Maven artifact resolver", e);
            }
        }
        return artifactResolver;
    }

    static {
        QuarkusProjectHelper.initRegistryClientEnabled();
    }
}

